"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.buildAssistantMessage = buildAssistantMessage;
exports.buildConversation = buildConversation;
exports.buildFunctionResponseMessage = buildFunctionResponseMessage;
exports.buildMessage = buildMessage;
exports.buildSystemMessage = buildSystemMessage;
exports.buildUserMessage = buildUserMessage;
var _lodash = require("lodash");
var _common = require("@kbn/observability-ai-assistant-plugin/common");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function buildMessage(params) {
  return (0, _lodash.merge)({
    '@timestamp': new Date().toISOString()
  }, params);
}
function buildSystemMessage(params) {
  return buildMessage((0, _lodash.merge)({}, params, {
    message: {
      role: _common.MessageRole.System
    }
  }));
}
function buildUserMessage(params) {
  return buildMessage((0, _lodash.merge)({
    message: {
      content: "What's a function?"
    }
  }, params, {
    message: {
      role: _common.MessageRole.User
    }
  }));
}
function buildAssistantMessage(params) {
  return buildMessage((0, _lodash.merge)({
    message: {
      content: `In computer programming and mathematics, a function is a fundamental concept that represents a relationship between input values and output values. It takes one or more input values (also known as arguments or parameters) and processes them to produce a result, which is the output of the function. The input values are passed to the function, and the function performs a specific set of operations or calculations on those inputs to produce the desired output.
          A function is often defined with a name, which serves as an identifier to call and use the function in the code. It can be thought of as a reusable block of code that can be executed whenever needed, and it helps in organizing code and making it more modular and maintainable.`
    }
  }, params, {
    message: {
      role: _common.MessageRole.Assistant
    }
  }));
}
function buildFunctionResponseMessage(params) {
  return buildUserMessage((0, _lodash.merge)({}, {
    message: {
      name: 'leftpad'
    },
    ...params
  }));
}
function buildConversation(params) {
  return {
    '@timestamp': '',
    user: {
      name: 'foo'
    },
    conversation: {
      id: (0, _lodash.uniqueId)(),
      title: '',
      last_updated: ''
    },
    messages: [buildSystemMessage()],
    labels: {},
    numeric_labels: {},
    namespace: '',
    public: false,
    ...params
  };
}