"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getConnectorType = getConnectorType;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireWildcard(require("react"));
var _public = require("@kbn/observability-ai-assistant-plugin/public");
var _rule_connector = require("../../common/rule_connector");
var _translations = require("./translations");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; } /*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function getConnectorType(service) {
  return {
    id: _rule_connector.OBSERVABILITY_AI_ASSISTANT_CONNECTOR_ID,
    modalWidth: 675,
    iconClass: () => /*#__PURE__*/_react.default.createElement(_public.AssistantAvatar, null),
    isSystemActionType: true,
    isExperimental: true,
    selectMessage: _translations.CONNECTOR_DESC,
    actionTypeTitle: _translations.CONNECTOR_TITLE,
    validateParams: async actionParams => {
      const validationResult = {
        errors: {
          connector: new Array(),
          message: new Array()
        }
      };
      if (!actionParams.connector) {
        validationResult.errors.connector.push(_translations.CONNECTOR_REQUIRED);
      }
      if (!actionParams.message) {
        validationResult.errors.message.push(_translations.MESSAGE_REQUIRED);
      }
      return validationResult;
    },
    actionParamsFields: /*#__PURE__*/(0, _react.lazy)(() => Promise.resolve().then(() => _interopRequireWildcard(require('./ai_assistant_params'))).then(({
      default: ActionParamsFields
    }) => ({
      default: props => /*#__PURE__*/_react.default.createElement(ActionParamsFields, (0, _extends2.default)({}, props, {
        service: service
      }))
    }))),
    actionConnectorFields: null
  };
}