"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ConversationView = ConversationView;
var _eui = require("@elastic/eui");
var _css = require("@emotion/css");
var _uiTheme = require("@kbn/ui-theme");
var _react = _interopRequireWildcard(require("react"));
var _reactDom = _interopRequireDefault(require("react-dom"));
var _public = require("@kbn/observability-ai-assistant-plugin/public");
var _chat_body = require("../../components/chat/chat_body");
var _chat_inline_edit = require("../../components/chat/chat_inline_edit");
var _conversation_list = require("../../components/chat/conversation_list");
var _use_current_user = require("../../hooks/use_current_user");
var _use_genai_connectors = require("../../hooks/use_genai_connectors");
var _use_knowledge_base = require("../../hooks/use_knowledge_base");
var _use_observability_ai_assistant_params = require("../../hooks/use_observability_ai_assistant_params");
var _use_observability_ai_assistant_router = require("../../hooks/use_observability_ai_assistant_router");
var _use_observability_ai_assistant_app_service = require("../../hooks/use_observability_ai_assistant_app_service");
var _use_kibana = require("../../hooks/use_kibana");
var _use_conversation_key = require("../../hooks/use_conversation_key");
var _use_conversation_list = require("../../hooks/use_conversation_list");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const SECOND_SLOT_CONTAINER_WIDTH = 400;
function ConversationView() {
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const currentUser = (0, _use_current_user.useCurrentUser)();
  const service = (0, _use_observability_ai_assistant_app_service.useObservabilityAIAssistantAppService)();
  const connectors = (0, _use_genai_connectors.useGenAIConnectors)();
  const knowledgeBase = (0, _use_knowledge_base.useKnowledgeBase)();
  const observabilityAIAssistantRouter = (0, _use_observability_ai_assistant_router.useObservabilityAIAssistantRouter)();
  const {
    path
  } = (0, _use_observability_ai_assistant_params.useObservabilityAIAssistantParams)('/conversations/*');
  const {
    services: {
      plugins: {
        start: {
          observabilityAIAssistant: {
            ObservabilityAIAssistantChatServiceContext
          }
        }
      }
    }
  } = (0, _use_kibana.useKibana)();
  const chatService = (0, _public.useAbortableAsync)(({
    signal
  }) => {
    return service.start({
      signal
    });
  }, [service]);
  const conversationId = 'conversationId' in path ? path.conversationId : undefined;
  const {
    key: bodyKey,
    updateConversationIdInPlace
  } = (0, _use_conversation_key.useConversationKey)(conversationId);
  const [secondSlotContainer, setSecondSlotContainer] = (0, _react.useState)(null);
  const [isSecondSlotVisible, setIsSecondSlotVisible] = (0, _react.useState)(false);
  const conversationList = (0, _use_conversation_list.useConversationList)();
  function navigateToConversation(nextConversationId) {
    if (nextConversationId) {
      observabilityAIAssistantRouter.push('/conversations/{conversationId}', {
        path: {
          conversationId: nextConversationId
        },
        query: {}
      });
    } else {
      observabilityAIAssistantRouter.push('/conversations/new', {
        path: {},
        query: {}
      });
    }
  }
  function handleRefreshConversations() {
    conversationList.conversations.refresh();
  }
  const handleConversationUpdate = conversation => {
    if (!conversationId) {
      updateConversationIdInPlace(conversation.conversation.id);
      navigateToConversation(conversation.conversation.id);
    }
    handleRefreshConversations();
  };
  (0, _react.useEffect)(() => {
    return () => {
      setIsSecondSlotVisible(false);
      if (secondSlotContainer) {
        _reactDom.default.unmountComponentAtNode(secondSlotContainer);
      }
    };
    // eslint-disable-next-line react-hooks/exhaustive-deps
  }, []);
  const containerClassName = (0, _css.css)`
    max-width: 100%;
  `;
  const conversationListContainerName = (0, _css.css)`
    min-width: 250px;
    width: 250px;
    border-right: solid 1px ${_uiTheme.euiThemeVars.euiColorLightShade};
  `;
  const sidebarContainerClass = (0, _css.css)`
    display: flex;
    position: absolute;
    z-index: 1;
    top: 56px;
    right: 0;
    height: calc(100% - 56px);
    background-color: ${euiTheme.colors.lightestShade};
    width: ${isSecondSlotVisible ? SECOND_SLOT_CONTAINER_WIDTH : 0}px;
    border-top: solid 1px ${_uiTheme.euiThemeVars.euiColorLightShade};
    border-left: solid 1px ${_uiTheme.euiThemeVars.euiColorLightShade};

    .euiFlyoutHeader {
      padding: ${euiTheme.size.m};
    }

    .euiFlyoutFooter {
      padding: ${euiTheme.size.m};
      padding-top: ${euiTheme.size.l};
      padding-bottom: ${euiTheme.size.l};
    }
  `;
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "row",
    className: containerClassName,
    gutterSize: "none"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    className: conversationListContainerName
  }, /*#__PURE__*/_react.default.createElement(_conversation_list.ConversationList, {
    selectedConversationId: conversationId,
    conversations: conversationList.conversations,
    isLoading: conversationList.isLoading,
    onConversationDeleteClick: deletedConversationId => {
      conversationList.deleteConversation(deletedConversationId).then(() => {
        if (deletedConversationId === conversationId) {
          navigateToConversation(undefined);
        }
      });
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  })), !chatService.value ? /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    alignItems: "center",
    gutterSize: "l"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "xl"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingSpinner, {
    size: "l"
  }))) : null, chatService.value && /*#__PURE__*/_react.default.createElement(ObservabilityAIAssistantChatServiceContext.Provider, {
    value: chatService.value
  }, /*#__PURE__*/_react.default.createElement(_chat_body.ChatBody, {
    key: bodyKey,
    currentUser: currentUser,
    connectors: connectors,
    initialConversationId: conversationId,
    knowledgeBase: knowledgeBase,
    showLinkToConversationsApp: false,
    onConversationUpdate: handleConversationUpdate
  }), /*#__PURE__*/_react.default.createElement("div", {
    className: sidebarContainerClass
  }, /*#__PURE__*/_react.default.createElement(_chat_inline_edit.ChatInlineEditingContent, {
    setContainer: setSecondSlotContainer,
    visible: isSecondSlotVisible,
    style: {
      width: '100%'
    }
  }))));
}