"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useKnowledgeBase = useKnowledgeBase;
var _i18n = require("@kbn/i18n");
var _react = require("react");
var _public = require("@kbn/observability-ai-assistant-plugin/public");
var _use_kibana = require("./use_kibana");
var _use_observability_ai_assistant_app_service = require("./use_observability_ai_assistant_app_service");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function useKnowledgeBase() {
  var _ml$mlApi2;
  const {
    notifications: {
      toasts
    },
    plugins: {
      start: {
        ml
      }
    }
  } = (0, _use_kibana.useKibana)().services;
  const service = (0, _use_observability_ai_assistant_app_service.useObservabilityAIAssistantAppService)();
  const status = (0, _public.useAbortableAsync)(({
    signal
  }) => {
    return service.callApi('GET /internal/observability_ai_assistant/kb/status', {
      signal
    });
  }, []);
  const [isInstalling, setIsInstalling] = (0, _react.useState)(false);
  const [installError, setInstallError] = (0, _react.useState)();
  return (0, _react.useMemo)(() => {
    let attempts = 0;
    const MAX_ATTEMPTS = 5;
    const install = () => {
      setIsInstalling(true);
      return service.callApi('POST /internal/observability_ai_assistant/kb/setup', {
        signal: null
      }).then(() => {
        var _ml$mlApi;
        return (_ml$mlApi = ml.mlApi) === null || _ml$mlApi === void 0 ? void 0 : _ml$mlApi.savedObjects.syncSavedObjects();
      }).then(() => {
        status.refresh();
      }).catch(error => {
        var _error$body, _error$body2;
        if ((((_error$body = error.body) === null || _error$body === void 0 ? void 0 : _error$body.statusCode) === 503 || ((_error$body2 = error.body) === null || _error$body2 === void 0 ? void 0 : _error$body2.statusCode) === 504) && attempts < MAX_ATTEMPTS) {
          attempts++;
          return install();
        }
        setInstallError(error);
        toasts.addError(error, {
          title: _i18n.i18n.translate('xpack.observabilityAiAssistant.errorSettingUpKnowledgeBase', {
            defaultMessage: 'Could not set up Knowledge Base'
          })
        });
      }).finally(() => {
        setIsInstalling(false);
      });
    };
    return {
      status,
      install,
      isInstalling,
      installError
    };
  }, [status, isInstalling, installError, service, (_ml$mlApi2 = ml.mlApi) === null || _ml$mlApi2 === void 0 ? void 0 : _ml$mlApi2.savedObjects, toasts]);
}