"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useCurrentUser = useCurrentUser;
var _react = require("react");
var _use_kibana = require("./use_kibana");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function useCurrentUser() {
  const {
    services: {
      plugins: {
        start: {
          security
        }
      }
    }
  } = (0, _use_kibana.useKibana)();
  const [user, setUser] = (0, _react.useState)();
  (0, _react.useEffect)(() => {
    const getCurrentUser = async () => {
      try {
        const authenticatedUser = await security.authc.getCurrentUser();
        setUser(authenticatedUser);
      } catch {
        setUser(undefined);
      }
    };
    getCurrentUser();
  }, [security]);
  return user;
}