"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useChartTheme = useChartTheme;
var _charts = require("@elastic/charts");
var _eui = require("@elastic/eui");
var _react = require("react");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function useChartTheme() {
  const theme = (0, _eui.useEuiTheme)();
  const baseTheme = theme.colorMode === 'DARK' ? _charts.DARK_THEME : _charts.LIGHT_THEME;
  return (0, _react.useMemo)(() => {
    const themeOverrides = {
      chartMargins: {
        left: 10,
        right: 10,
        top: 35,
        bottom: 10
      },
      background: {
        color: 'transparent'
      },
      lineSeriesStyle: {
        point: {
          visible: false
        }
      },
      areaSeriesStyle: {
        point: {
          visible: false
        }
      }
    };
    return {
      theme: [themeOverrides],
      baseTheme
    };
  }, [baseTheme]);
}