"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.WelcomeMessage = WelcomeMessage;
var _react = _interopRequireWildcard(require("react"));
var _css = require("@emotion/css");
var _eui = require("@elastic/eui");
var _common = require("@kbn/actions-plugin/common");
var _public = require("@kbn/observability-ai-assistant-plugin/public");
var _disclaimer = require("./disclaimer");
var _welcome_message_connectors = require("./welcome_message_connectors");
var _welcome_message_knowledge_base = require("./welcome_message_knowledge_base");
var _use_kibana = require("../../hooks/use_kibana");
var _starter_prompts = require("./starter_prompts");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const fullHeightClassName = (0, _css.css)`
  height: 100%;
`;
const centerMaxWidthClassName = (0, _css.css)`
  max-width: 600px;
  text-align: center;
`;
function WelcomeMessage({
  connectors,
  knowledgeBase,
  onSelectPrompt
}) {
  const breakpoint = (0, _eui.useCurrentEuiBreakpoint)();
  const {
    application: {
      navigateToApp,
      capabilities
    },
    plugins: {
      start: {
        triggersActionsUi: {
          getAddConnectorFlyout: ConnectorFlyout
        }
      }
    }
  } = (0, _use_kibana.useKibana)().services;
  const [connectorFlyoutOpen, setConnectorFlyoutOpen] = (0, _react.useState)(false);
  const handleConnectorClick = () => {
    var _capabilities$managem, _capabilities$managem2;
    if ((_capabilities$managem = capabilities.management) !== null && _capabilities$managem !== void 0 && (_capabilities$managem2 = _capabilities$managem.insightsAndAlerting) !== null && _capabilities$managem2 !== void 0 && _capabilities$managem2.triggersActions) {
      setConnectorFlyoutOpen(true);
    } else {
      navigateToApp('management', {
        path: '/insightsAndAlerting/triggersActionsConnectors/connectors'
      });
    }
  };
  const onConnectorCreated = createdConnector => {
    var _knowledgeBase$status;
    setConnectorFlyoutOpen(false);
    if ((0, _public.isSupportedConnectorType)(createdConnector.actionTypeId)) {
      connectors.reloadConnectors();
    }
    if (!knowledgeBase.status.value || ((_knowledgeBase$status = knowledgeBase.status.value) === null || _knowledgeBase$status === void 0 ? void 0 : _knowledgeBase$status.ready) === false) {
      knowledgeBase.install();
    }
  };
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center",
    direction: "column",
    gutterSize: "none",
    className: fullHeightClassName
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: true,
    className: centerMaxWidthClassName
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: ['xl', 'l'].includes(breakpoint) ? 'l' : 's'
  }), /*#__PURE__*/_react.default.createElement(_welcome_message_connectors.WelcomeMessageConnectors, {
    connectors: connectors,
    onSetupConnectorClick: handleConnectorClick
  }), /*#__PURE__*/_react.default.createElement(_welcome_message_knowledge_base.WelcomeMessageKnowledgeBase, {
    connectors: connectors,
    knowledgeBase: knowledgeBase
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_starter_prompts.StarterPrompts, {
    onSelectPrompt: onSelectPrompt
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "l"
  }), /*#__PURE__*/_react.default.createElement(_disclaimer.Disclaimer, null))), connectorFlyoutOpen ? /*#__PURE__*/_react.default.createElement(ConnectorFlyout, {
    featureId: _common.GenerativeAIForObservabilityConnectorFeatureId,
    onConnectorCreated: onConnectorCreated,
    onClose: () => setConnectorFlyoutOpen(false)
  }) : null);
}