"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.IncorrectLicensePanel = IncorrectLicensePanel;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _css = require("@emotion/css");
var _i18n = require("@kbn/i18n");
var _uiTheme = require("@kbn/ui-theme");
var _i18n2 = require("../../i18n");
var _elastic_ai_assistant = _interopRequireDefault(require("../../assets/elastic_ai_assistant.png"));
var _use_license_management_locator = require("../../hooks/use_license_management_locator");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const incorrectLicenseContainer = (0, _css.css)`
  height: 100%;
  padding: ${_uiTheme.euiThemeVars.euiPanelPaddingModifiers.paddingMedium};
`;
function IncorrectLicensePanel() {
  const handleNavigateToLicenseManagement = (0, _use_license_management_locator.useLicenseManagementLocator)();
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    hasBorder: true,
    hasShadow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    alignItems: "center",
    justifyContent: "center",
    className: incorrectLicenseContainer
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiImage, {
    src: _elastic_ai_assistant.default,
    alt: "Elastic AI Assistant",
    size: "m"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, null, /*#__PURE__*/_react.default.createElement("h2", null, _i18n2.UPGRADE_LICENSE_TITLE)), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    color: "subdued"
  }, _i18n.i18n.translate('xpack.observabilityAiAssistant.incorrectLicense.body', {
    defaultMessage: 'You need an Enterprise license to use the Elastic AI Assistant.'
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    "data-test-subj": "observabilityAiAssistantIncorrectLicensePanelSubscriptionPlansButton",
    fill: true,
    href: "https://www.elastic.co/subscriptions",
    target: "_blank"
  }, _i18n.i18n.translate('xpack.observabilityAiAssistant.incorrectLicense.subscriptionPlansButton', {
    defaultMessage: 'Subscription plans'
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    "data-test-subj": "observabilityAiAssistantIncorrectLicensePanelManageLicenseButton",
    onClick: handleNavigateToLicenseManagement
  }, _i18n.i18n.translate('xpack.observabilityAiAssistant.incorrectLicense.manageLicense', {
    defaultMessage: 'Manage license'
  })))))));
}