"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ConversationList = ConversationList;
var _eui = require("@elastic/eui");
var _css = require("@emotion/css");
var _i18n = require("@kbn/i18n");
var _react = _interopRequireDefault(require("react"));
var _use_confirm_modal = require("../../hooks/use_confirm_modal");
var _use_observability_ai_assistant_router = require("../../hooks/use_observability_ai_assistant_router");
var _i18n2 = require("../../i18n");
var _new_chat_button = require("../buttons/new_chat_button");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const titleClassName = (0, _css.css)`
  text-transform: uppercase;
`;
const panelClassName = (0, _css.css)`
  max-height: 100%;
  padding-top: 56px;
`;
const overflowScrollClassName = scrollBarStyles => (0, _css.css)`
  overflow-y: auto;
  ${scrollBarStyles}
`;
const newChatButtonWrapperClassName = (0, _css.css)`
  padding-bottom: 5px;
`;
function ConversationList({
  selectedConversationId,
  onConversationSelect,
  onConversationDeleteClick,
  conversations,
  isLoading
}) {
  var _conversations$value$, _conversations$value;
  const router = (0, _use_observability_ai_assistant_router.useObservabilityAIAssistantRouter)();
  const euiTheme = (0, _eui.useEuiTheme)();
  const scrollBarStyles = (0, _eui.euiScrollBarStyles)(euiTheme);
  const containerClassName = (0, _css.css)`
    height: 100%;
    border-top: solid 1px ${euiTheme.euiTheme.border.color};
    padding: ${euiTheme.euiTheme.size.s};
  `;
  const {
    element: confirmDeleteElement,
    confirm: confirmDeleteCallback
  } = (0, _use_confirm_modal.useConfirmModal)({
    title: _i18n.i18n.translate('xpack.observabilityAiAssistant.flyout.confirmDeleteConversationTitle', {
      defaultMessage: 'Delete this conversation?'
    }),
    children: _i18n.i18n.translate('xpack.observabilityAiAssistant.flyout.confirmDeleteConversationContent', {
      defaultMessage: 'This action cannot be undone.'
    }),
    confirmButtonText: _i18n.i18n.translate('xpack.observabilityAiAssistant.flyout.confirmDeleteButtonText', {
      defaultMessage: 'Delete conversation'
    })
  });
  const displayedConversations = [...(!selectedConversationId ? [{
    id: '',
    label: _i18n2.EMPTY_CONVERSATION_TITLE,
    lastUpdated: '',
    href: router.link('/conversations/new')
  }] : []), ...((_conversations$value$ = (_conversations$value = conversations.value) === null || _conversations$value === void 0 ? void 0 : _conversations$value.conversations) !== null && _conversations$value$ !== void 0 ? _conversations$value$ : []).map(({
    conversation
  }) => ({
    id: conversation.id,
    label: conversation.title,
    lastUpdated: conversation.last_updated,
    href: router.link('/conversations/{conversationId}', {
      path: {
        conversationId: conversation.id
      }
    })
  }))];
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    paddingSize: "none",
    hasShadow: false,
    className: panelClassName
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    gutterSize: "none",
    className: containerClassName
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: true,
    className: overflowScrollClassName(scrollBarStyles)
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    gutterSize: "xs"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    hasBorder: false,
    hasShadow: false,
    paddingSize: "s"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "row",
    gutterSize: "xs",
    alignItems: "center"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    className: titleClassName,
    size: "s"
  }, /*#__PURE__*/_react.default.createElement("strong", null, _i18n.i18n.translate('xpack.observabilityAiAssistant.conversationList.title', {
    defaultMessage: 'Previously'
  })))), isLoading ? /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingSpinner, {
    size: "s"
  })) : null))), conversations.error ? /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    hasBorder: false,
    hasShadow: false,
    paddingSize: "s"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "row",
    alignItems: "center",
    gutterSize: "s"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
    type: "warning",
    color: "danger"
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s",
    color: "danger"
  }, _i18n.i18n.translate('xpack.observabilityAiAssistant.conversationList.errorMessage', {
    defaultMessage: 'Failed to load'
  })))))) : null, displayedConversations !== null && displayedConversations !== void 0 && displayedConversations.length ? /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: true
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiListGroup, {
    flush: false,
    gutterSize: "none"
  }, displayedConversations === null || displayedConversations === void 0 ? void 0 : displayedConversations.map(conversation => /*#__PURE__*/_react.default.createElement(_eui.EuiListGroupItem, {
    "data-test-subj": "observabilityAiAssistantConversationsLink",
    key: conversation.id,
    label: conversation.label,
    size: "s",
    isActive: conversation.id === selectedConversationId,
    isDisabled: isLoading,
    wrapText: true,
    showToolTip: true,
    href: conversation.href,
    onClick: event => {
      if (onConversationSelect) {
        event.preventDefault();
        onConversationSelect(conversation.id);
      }
    },
    extraAction: conversation.id ? {
      iconType: 'trash',
      'aria-label': _i18n.i18n.translate('xpack.observabilityAiAssistant.conversationList.deleteConversationIconLabel', {
        defaultMessage: 'Delete'
      }),
      onClick: () => {
        confirmDeleteCallback().then(confirmed => {
          if (!confirmed) {
            return;
          }
          onConversationDeleteClick(conversation.id);
        });
      }
    } : undefined
  })))) : null, !isLoading && !conversations.error && !(displayedConversations !== null && displayedConversations !== void 0 && displayedConversations.length) ? /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    hasBorder: false,
    hasShadow: false,
    paddingSize: "s"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    color: "subdued",
    size: "s"
  }, _i18n.i18n.translate('xpack.observabilityAiAssistant.conversationList.noConversations', {
    defaultMessage: 'No conversations'
  }))) : null)), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    paddingSize: "s",
    hasBorder: false,
    hasShadow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: true,
    className: newChatButtonWrapperClassName
  }, /*#__PURE__*/_react.default.createElement(_new_chat_button.NewChatButton, {
    href: router.link('/conversations/new'),
    onClick: event => {
      if (onConversationSelect) {
        event.preventDefault();
        onConversationSelect(undefined);
      }
    }
  }))))))), confirmDeleteElement);
}