"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ChatTimeline = ChatTimeline;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireWildcard(require("react"));
var _css = require("@emotion/css");
var _eui = require("@elastic/eui");
var _lodash = require("lodash");
var _chat_item = require("./chat_item");
var _chat_consolidated_items = require("./chat_consolidated_items");
var _get_timeline_items_from_conversation = require("../../utils/get_timeline_items_from_conversation");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function ChatTimeline({
  messages,
  chatService,
  hasConnector,
  currentUser,
  onEdit,
  onFeedback,
  onRegenerate,
  onSendTelemetry,
  onStopGenerating,
  onActionClick,
  chatState
}) {
  const items = (0, _react.useMemo)(() => {
    const timelineItems = (0, _get_timeline_items_from_conversation.getTimelineItemsfromConversation)({
      chatService,
      hasConnector,
      messages,
      currentUser,
      chatState,
      onActionClick
    });
    const consolidatedChatItems = [];
    let currentGroup = null;
    for (const item of timelineItems) {
      if (item.display.hide || !item) continue;
      if (item.display.collapsed) {
        if (currentGroup) {
          currentGroup.push(item);
        } else {
          currentGroup = [item];
          consolidatedChatItems.push(currentGroup);
        }
      } else {
        consolidatedChatItems.push(item);
        currentGroup = null;
      }
    }
    return consolidatedChatItems;
  }, [chatService, hasConnector, messages, currentUser, chatState, onActionClick]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiCommentList, {
    className: (0, _css.css)`
        padding-bottom: 32px;
      `
  }, items.map((item, index) => {
    return Array.isArray(item) ? /*#__PURE__*/_react.default.createElement(_chat_consolidated_items.ChatConsolidatedItems, {
      key: index,
      consolidatedItem: item,
      onActionClick: onActionClick,
      onEditSubmit: onEdit,
      onFeedback: onFeedback,
      onRegenerate: onRegenerate,
      onSendTelemetry: onSendTelemetry,
      onStopGenerating: onStopGenerating
    }) : /*#__PURE__*/_react.default.createElement(_chat_item.ChatItem
    // use index, not id to prevent unmounting of component when message is persisted
    , (0, _extends2.default)({
      key: index
    }, (0, _lodash.omit)(item, 'message'), {
      onActionClick: payload => {
        onActionClick({
          message: item.message,
          payload
        });
      },
      onFeedbackClick: feedback => {
        onFeedback(item.message, feedback);
      },
      onRegenerateClick: () => {
        onRegenerate(item.message);
      },
      onEditSubmit: message => {
        onEdit(item.message, message);
      },
      onSendTelemetry: onSendTelemetry,
      onStopGeneratingClick: onStopGenerating
    }));
  }));
}