"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ChatItemAvatar = ChatItemAvatar;
var _react = _interopRequireDefault(require("react"));
var _userProfileComponents = require("@kbn/user-profile-components");
var _css = require("@emotion/css");
var _eui = require("@elastic/eui");
var _public = require("@kbn/observability-ai-assistant-plugin/public");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const assistantAvatarClassName = (0, _css.css)`
  svg {
    width: 16px;
    height: 16px;
  }
`;
function ChatItemAvatar({
  currentUser,
  role,
  loading
}) {
  const isLoading = loading || !currentUser;
  if (isLoading) {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingSpinner, {
      size: "xl"
    });
  }
  switch (role) {
    case _public.MessageRole.User:
      return /*#__PURE__*/_react.default.createElement(_userProfileComponents.UserAvatar, {
        user: currentUser,
        size: "m",
        "data-test-subj": "userMenuAvatar"
      });
    case _public.MessageRole.Assistant:
    case _public.MessageRole.Elastic:
    case _public.MessageRole.Function:
      return /*#__PURE__*/_react.default.createElement(_eui.EuiAvatar, {
        name: "Elastic Assistant",
        iconType: _public.AssistantAvatar,
        color: "subdued",
        className: assistantAvatarClassName
      });
    case _public.MessageRole.System:
      return /*#__PURE__*/_react.default.createElement(_eui.EuiAvatar, {
        name: "system",
        iconType: "dot",
        color: "subdued"
      });
    default:
      return null;
  }
}