"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ChatItemActions = ChatItemActions;
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function ChatItemActions({
  canCopy,
  canEdit,
  collapsed,
  editing,
  expanded,
  onToggleEdit,
  onToggleExpand,
  onCopyToClipboard
}) {
  const [isPopoverOpen, setIsPopoverOpen] = (0, _react.useState)();
  (0, _react.useEffect)(() => {
    const timeout = setTimeout(() => {
      if (isPopoverOpen) {
        setIsPopoverOpen(undefined);
      }
    }, 800);
    return () => {
      clearTimeout(timeout);
    };
  }, [isPopoverOpen]);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, canEdit ? /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
    "aria-label": _i18n.i18n.translate('xpack.observabilityAiAssistant.chatTimeline.actions.editPrompt', {
      defaultMessage: 'Edit prompt'
    }),
    color: "text",
    "data-test-subj": "observabilityAiAssistantChatItemActionsEditPromptButton",
    display: editing ? 'fill' : 'empty',
    iconType: "documentEdit",
    onClick: onToggleEdit
  }) : null, collapsed ? /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
    "aria-label": _i18n.i18n.translate('xpack.observabilityAiAssistant.chatTimeline.actions.inspectPrompt', {
      defaultMessage: 'Inspect prompt'
    }),
    color: "text",
    "data-test-subj": "observabilityAiAssistantChatItemActionsInspectPromptButton",
    display: expanded ? 'fill' : 'empty',
    iconType: expanded ? 'eyeClosed' : 'eye',
    onClick: onToggleExpand
  }) : null, canCopy ? /*#__PURE__*/_react.default.createElement(_eui.EuiPopover, {
    button: /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
      "aria-label": _i18n.i18n.translate('xpack.observabilityAiAssistant.chatTimeline.actions.copyMessage', {
        defaultMessage: 'Copy message'
      }),
      color: "text",
      "data-test-subj": "observabilityAiAssistantChatItemActionsCopyMessageButton",
      iconType: "copyClipboard",
      display: isPopoverOpen === 'copy' ? 'fill' : 'empty',
      onClick: () => {
        setIsPopoverOpen('copy');
        onCopyToClipboard();
      }
    }),
    isOpen: isPopoverOpen === 'copy',
    panelPaddingSize: "s",
    closePopover: () => setIsPopoverOpen(undefined)
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s"
  }, _i18n.i18n.translate('xpack.observabilityAiAssistant.chatTimeline.actions.copyMessageSuccessful', {
    defaultMessage: 'Copied message'
  }))) : null);
}