"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ChatItem = ChatItem;
var _react = _interopRequireWildcard(require("react"));
var _css = require("@emotion/css");
var _eui = require("@elastic/eui");
var _public = require("@kbn/observability-ai-assistant-plugin/public");
var _chat_item_actions = require("./chat_item_actions");
var _chat_item_avatar = require("./chat_item_avatar");
var _chat_item_content_inline_prompt_editor = require("./chat_item_content_inline_prompt_editor");
var _get_role_translation = require("../../utils/get_role_translation");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const moreCompactHeaderClassName = (0, _css.css)`
  .euiCommentEvent__header > .euiPanel {
    padding-top: 4px;
    padding-bottom: 4px;
  }
`;
const normalMessageClassName = (0, _css.css)`
  ${moreCompactHeaderClassName}

  .euiCommentEvent__body {
    padding: 0;
  }

  /* targets .*euiTimelineItemEvent-top, makes sure text properly wraps and doesn't overflow */
  > :last-child {
    overflow-x: hidden;
  }
`;
const noPanelMessageClassName = (0, _css.css)`
  .euiCommentEvent {
    border: none;
  }

  .euiCommentEvent__header {
    background: transparent;
    border-block-end: none;

    > .euiPanel {
      background: none;
    }
  }

  .euiCommentEvent__body {
    display: none;
  }
`;
function ChatItem({
  actions: {
    canCopy,
    canEdit,
    canGiveFeedback,
    canRegenerate
  },
  content,
  function_call: functionCall,
  role,
  currentUser,
  display: {
    collapsed
  },
  element,
  error,
  loading,
  title,
  onActionClick,
  onEditSubmit,
  onFeedbackClick,
  onRegenerateClick,
  onSendTelemetry,
  onStopGeneratingClick
}) {
  const accordionId = (0, _eui.useGeneratedHtmlId)({
    prefix: 'chat'
  });
  const [editing, setEditing] = (0, _react.useState)(false);
  const [expanded, setExpanded] = (0, _react.useState)(Boolean(element));
  const actions = [canCopy, collapsed, canCopy].filter(Boolean);
  const noBodyMessageClassName = (0, _css.css)`
    ${moreCompactHeaderClassName}

    .euiCommentEvent__body {
      padding: 0;
      height: ${expanded ? 'fit-content' : '0px'};
      overflow: hidden;
      border: none;
    }
  `;
  const handleToggleExpand = () => {
    setExpanded(!expanded);
    if (editing) {
      setEditing(false);
    }
  };
  const handleToggleEdit = () => {
    if (collapsed && !expanded) {
      setExpanded(true);
    }
    setEditing(!editing);
  };
  const handleInlineEditSubmit = newMessage => {
    handleToggleEdit();
    return onEditSubmit(newMessage);
  };
  const handleCopyToClipboard = () => {
    navigator.clipboard.writeText(content || '');
  };
  let contentElement = content || loading || error ? /*#__PURE__*/_react.default.createElement(_chat_item_content_inline_prompt_editor.ChatItemContentInlinePromptEditor, {
    editing: editing,
    loading: loading,
    functionCall: functionCall,
    content: content,
    role: role,
    onSubmit: handleInlineEditSubmit,
    onActionClick: onActionClick,
    onSendTelemetry: onSendTelemetry
  }) : null;
  if (collapsed) {
    contentElement = /*#__PURE__*/_react.default.createElement(_eui.EuiAccordion, {
      id: accordionId,
      arrowDisplay: "none",
      forceState: expanded ? 'open' : 'closed',
      onToggle: handleToggleExpand
    }, contentElement);
  }
  return /*#__PURE__*/_react.default.createElement(_eui.EuiComment, {
    timelineAvatar: /*#__PURE__*/_react.default.createElement(_chat_item_avatar.ChatItemAvatar, {
      loading: loading,
      currentUser: currentUser,
      role: role
    }),
    username: (0, _get_role_translation.getRoleTranslation)(role),
    event: title,
    actions: /*#__PURE__*/_react.default.createElement(_chat_item_actions.ChatItemActions, {
      canCopy: canCopy,
      canEdit: canEdit,
      collapsed: collapsed,
      editing: editing,
      expanded: expanded,
      onCopyToClipboard: handleCopyToClipboard,
      onToggleEdit: handleToggleEdit,
      onToggleExpand: handleToggleExpand
    }),
    className: actions.length === 0 && !content ? noPanelMessageClassName : collapsed ? noBodyMessageClassName : normalMessageClassName
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    hasShadow: false,
    paddingSize: "s"
  }, element ? /*#__PURE__*/_react.default.createElement(_eui.EuiErrorBoundary, null, element) : null, contentElement, error ? /*#__PURE__*/_react.default.createElement(_public.FailedToLoadResponse, null) : null), /*#__PURE__*/_react.default.createElement(_public.ChatItemControls, {
    canGiveFeedback: canGiveFeedback,
    canRegenerate: canRegenerate,
    error: error,
    loading: loading,
    onFeedbackClick: onFeedbackClick,
    onRegenerateClick: onRegenerateClick,
    onStopGeneratingClick: onStopGeneratingClick
  }));
}