"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ChatHeader = ChatHeader;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _css = require("@emotion/css");
var _public = require("@kbn/observability-ai-assistant-plugin/public");
var _chat_actions_menu = require("./chat_actions_menu");
var _use_observability_ai_assistant_router = require("../../hooks/use_observability_ai_assistant_router");
var _chat_flyout = require("./chat_flyout");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

// needed to prevent InlineTextEdit component from expanding container
const minWidthClassName = (0, _css.css)`
  min-width: 0;
`;
const chatHeaderClassName = (0, _css.css)`
  padding-top: 12px;
  padding-bottom: 12px;
`;
const chatHeaderMobileClassName = (0, _css.css)`
  padding-top: 8px;
  padding-bottom: 8px;
`;
function ChatHeader({
  connectors,
  conversationId,
  flyoutPositionMode,
  licenseInvalid,
  loading,
  title,
  onCopyConversation,
  onSaveTitle,
  onToggleFlyoutPositionMode
}) {
  const theme = (0, _eui.useEuiTheme)();
  const breakpoint = (0, _eui.useCurrentEuiBreakpoint)();
  const router = (0, _use_observability_ai_assistant_router.useObservabilityAIAssistantRouter)();
  const [newTitle, setNewTitle] = (0, _react.useState)(title);
  (0, _react.useEffect)(() => {
    setNewTitle(title);
  }, [title]);
  const handleNavigateToConversations = () => {
    if (conversationId) {
      router.push('/conversations/{conversationId}', {
        path: {
          conversationId
        },
        query: {}
      });
    } else {
      router.push('/conversations/new', {
        path: {},
        query: {}
      });
    }
  };
  const handleToggleFlyoutPositionMode = () => {
    if (flyoutPositionMode) {
      onToggleFlyoutPositionMode === null || onToggleFlyoutPositionMode === void 0 ? void 0 : onToggleFlyoutPositionMode(flyoutPositionMode === _chat_flyout.FlyoutPositionMode.OVERLAY ? _chat_flyout.FlyoutPositionMode.PUSH : _chat_flyout.FlyoutPositionMode.OVERLAY);
    }
  };
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    borderRadius: "none",
    className: breakpoint === 'xs' ? chatHeaderMobileClassName : chatHeaderClassName,
    hasBorder: false,
    hasShadow: false,
    paddingSize: breakpoint === 'xs' ? 's' : 'm'
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "m",
    responsive: false,
    alignItems: "center"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, loading ? /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingSpinner, {
    size: breakpoint === 'xs' ? 'm' : 'l'
  }) : /*#__PURE__*/_react.default.createElement(_public.AssistantAvatar, {
    size: breakpoint === 'xs' ? 'xs' : 's'
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: true,
    className: minWidthClassName
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiInlineEditTitle, {
    heading: "h2",
    size: breakpoint === 'xs' ? 'xs' : 's',
    value: newTitle,
    className: (0, _css.css)`
              color: ${!!title ? theme.euiTheme.colors.text : theme.euiTheme.colors.subduedText};
            `,
    inputAriaLabel: _i18n.i18n.translate('xpack.observabilityAiAssistant.chatHeader.editConversationInput', {
      defaultMessage: 'Edit conversation'
    }),
    isReadOnly: !conversationId || !connectors.selectedConnector || licenseInvalid || !Boolean(onSaveTitle),
    onChange: e => {
      setNewTitle(e.currentTarget.nodeValue || '');
    },
    onSave: e => {
      if (onSaveTitle) {
        onSaveTitle(e);
      }
    },
    onCancel: previousTitle => {
      setNewTitle(previousTitle);
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "s",
    responsive: false
  }, flyoutPositionMode && onToggleFlyoutPositionMode ? /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiPopover, {
    anchorPosition: "downLeft",
    button: /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
      content: flyoutPositionMode === 'overlay' ? _i18n.i18n.translate('xpack.observabilityAiAssistant.chatHeader.euiToolTip.flyoutModeLabel.dock', {
        defaultMessage: 'Dock chat'
      }) : _i18n.i18n.translate('xpack.observabilityAiAssistant.chatHeader.euiToolTip.flyoutModeLabel.undock', {
        defaultMessage: 'Undock chat'
      }),
      display: "block"
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
      "aria-label": _i18n.i18n.translate('xpack.observabilityAiAssistant.chatHeader.euiButtonIcon.toggleFlyoutModeLabel', {
        defaultMessage: 'Toggle flyout mode'
      }),
      "data-test-subj": "observabilityAiAssistantChatHeaderButton",
      iconType: flyoutPositionMode === 'overlay' ? 'menuRight' : 'menuLeft',
      onClick: handleToggleFlyoutPositionMode
    }))
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiPopover, {
    anchorPosition: "downLeft",
    button: /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
      content: _i18n.i18n.translate('xpack.observabilityAiAssistant.chatHeader.euiToolTip.navigateToConversationsLabel', {
        defaultMessage: 'Navigate to conversations'
      }),
      display: "block"
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
      "aria-label": _i18n.i18n.translate('xpack.observabilityAiAssistant.chatHeader.euiButtonIcon.navigateToConversationsLabel', {
        defaultMessage: 'Navigate to conversations'
      }),
      "data-test-subj": "observabilityAiAssistantChatHeaderButton",
      iconType: "discuss",
      onClick: handleNavigateToConversations
    }))
  }))) : null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_chat_actions_menu.ChatActionsMenu, {
    connectors: connectors,
    conversationId: conversationId,
    disabled: licenseInvalid,
    onCopyConversationClick: onCopyConversation
  }))))));
}