"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ChatBody = ChatBody;
exports.reverseToLastUserMessage = reverseToLastUserMessage;
var _eui = require("@elastic/eui");
var _css = require("@emotion/css");
var _i18n = require("@kbn/i18n");
var _public = require("@kbn/observability-ai-assistant-plugin/public");
var _uiTheme = require("@kbn/ui-theme");
var _lodash = require("lodash");
var _react = _interopRequireWildcard(require("react"));
var _use_conversation = require("../../hooks/use_conversation");
var _use_license = require("../../hooks/use_license");
var _use_observability_ai_assistant_chat_service = require("../../hooks/use_observability_ai_assistant_chat_service");
var _use_simulated_function_calling = require("../../hooks/use_simulated_function_calling");
var _i18n2 = require("../../i18n");
var _prompt_editor = require("../prompt_editor/prompt_editor");
var _chat_header = require("./chat_header");
var _chat_timeline = require("./chat_timeline");
var _incorrect_license_panel = require("./incorrect_license_panel");
var _simulated_function_calling_callout = require("./simulated_function_calling_callout");
var _welcome_message = require("./welcome_message");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const fullHeightClassName = (0, _css.css)`
  height: 100%;
`;
const timelineClassName = scrollBarStyles => (0, _css.css)`
  overflow-y: auto;
  ${scrollBarStyles}
`;
const promptEditorClassname = (0, _css.css)`
  overflow: hidden;
  transition: height ${_uiTheme.euiThemeVars.euiAnimSpeedFast} ${_uiTheme.euiThemeVars.euiAnimSlightResistance};
`;
const incorrectLicenseContainer = (0, _css.css)`
  height: 100%;
  padding: ${_uiTheme.euiThemeVars.euiPanelPaddingModifiers.paddingMedium};
`;
const chatBodyContainerClassNameWithError = (0, _css.css)`
  align-self: center;
`;
const promptEditorContainerClassName = (0, _css.css)`
  padding-top: 12px;
  padding-bottom: 8px;
`;
const fadeInAnimation = (0, _css.keyframes)`
  from {
    opacity: 0;
    transform: scale(0.9);
  }
  to {
    opacity: 1;
    transform: scale(1);
  }
`;
const animClassName = (0, _css.css)`
  height: 100%;
  opacity: 0;
  animation: ${fadeInAnimation} ${_uiTheme.euiThemeVars.euiAnimSpeedNormal}
    ${_uiTheme.euiThemeVars.euiAnimSlightBounce} ${_uiTheme.euiThemeVars.euiAnimSpeedNormal} forwards;
`;
const containerClassName = (0, _css.css)`
  min-width: 0;
  max-height: 100%;
`;
const PADDING_AND_BORDER = 32;
function ChatBody({
  connectors,
  currentUser,
  flyoutPositionMode,
  initialConversationId,
  initialMessages,
  initialTitle,
  knowledgeBase,
  showLinkToConversationsApp,
  onConversationUpdate,
  onToggleFlyoutPositionMode
}) {
  var _conversation$value, _conversation$value4;
  const license = (0, _use_license.useLicense)();
  const hasCorrectLicense = license === null || license === void 0 ? void 0 : license.hasAtLeast('enterprise');
  const euiTheme = (0, _eui.useEuiTheme)();
  const scrollBarStyles = (0, _eui.euiScrollBarStyles)(euiTheme);
  const chatService = (0, _use_observability_ai_assistant_chat_service.useObservabilityAIAssistantChatService)();
  const {
    simulatedFunctionCallingEnabled
  } = (0, _use_simulated_function_calling.useSimulatedFunctionCalling)();
  const {
    conversation,
    messages,
    next,
    state,
    stop,
    saveTitle
  } = (0, _use_conversation.useConversation)({
    initialConversationId,
    initialMessages,
    initialTitle,
    chatService,
    connectorId: connectors.selectedConnector,
    onConversationUpdate
  });
  const timelineContainerRef = (0, _react.useRef)(null);
  let footer;
  const isLoading = Boolean(connectors.loading || knowledgeBase.status.loading || state === _public.ChatState.Loading || conversation.loading);
  let title = ((_conversation$value = conversation.value) === null || _conversation$value === void 0 ? void 0 : _conversation$value.conversation.title) || initialTitle;
  if (!title) {
    if (!connectors.selectedConnector) {
      title = _i18n2.ASSISTANT_SETUP_TITLE;
    } else if (!hasCorrectLicense && !initialConversationId) {
      title = _i18n2.UPGRADE_LICENSE_TITLE;
    } else {
      title = _i18n2.EMPTY_CONVERSATION_TITLE;
    }
  }
  const headerContainerClassName = (0, _css.css)`
    padding-right: ${showLinkToConversationsApp ? '32px' : '0'};
  `;
  const [stickToBottom, setStickToBottom] = (0, _react.useState)(true);
  const isAtBottom = parent => parent.scrollTop + parent.clientHeight >= parent.scrollHeight;
  const [promptEditorHeight, setPromptEditorHeight] = (0, _react.useState)(0);
  const handleFeedback = (message, feedback) => {
    var _conversation$value2;
    if ((_conversation$value2 = conversation.value) !== null && _conversation$value2 !== void 0 && _conversation$value2.conversation && 'user' in conversation.value) {
      chatService.sendAnalyticsEvent({
        type: _public.ObservabilityAIAssistantTelemetryEventType.ChatFeedback,
        payload: {
          messageWithFeedback: {
            message,
            feedback
          },
          conversation: conversation.value
        }
      });
    }
  };
  const handleChangeHeight = (0, _react.useCallback)(editorHeight => {
    if (editorHeight === 0) {
      setPromptEditorHeight(0);
    } else {
      setPromptEditorHeight(editorHeight + PADDING_AND_BORDER);
    }
  }, []);
  (0, _react.useEffect)(() => {
    var _timelineContainerRef;
    const parent = (_timelineContainerRef = timelineContainerRef.current) === null || _timelineContainerRef === void 0 ? void 0 : _timelineContainerRef.parentElement;
    if (!parent) {
      return;
    }
    function onScroll() {
      setStickToBottom(isAtBottom(parent));
    }
    parent.addEventListener('scroll', onScroll);
    return () => {
      parent.removeEventListener('scroll', onScroll);
    };
    // eslint-disable-next-line react-hooks/exhaustive-deps
  }, [timelineContainerRef.current]);
  (0, _react.useEffect)(() => {
    var _timelineContainerRef2;
    const parent = (_timelineContainerRef2 = timelineContainerRef.current) === null || _timelineContainerRef2 === void 0 ? void 0 : _timelineContainerRef2.parentElement;
    if (!parent) {
      return;
    }
    if (stickToBottom) {
      parent.scrollTop = parent.scrollHeight;
    }
  });
  const handleCopyConversation = () => {
    var _conversation$value$m, _conversation$value3, _navigator$clipboard;
    const content = JSON.stringify({
      title: initialTitle,
      messages: (_conversation$value$m = (_conversation$value3 = conversation.value) === null || _conversation$value3 === void 0 ? void 0 : _conversation$value3.messages) !== null && _conversation$value$m !== void 0 ? _conversation$value$m : messages
    });
    (_navigator$clipboard = navigator.clipboard) === null || _navigator$clipboard === void 0 ? void 0 : _navigator$clipboard.writeText(content || '');
  };
  const handleActionClick = ({
    message,
    payload
  }) => {
    var _visualizeQueryRespon;
    setStickToBottom(true);
    switch (payload.type) {
      case _public.ChatActionClickType.executeEsqlQuery:
        next(messages.concat({
          '@timestamp': new Date().toISOString(),
          message: {
            role: _public.MessageRole.Assistant,
            content: '',
            function_call: {
              name: 'execute_query',
              arguments: JSON.stringify({
                query: payload.query
              }),
              trigger: _public.MessageRole.User
            }
          }
        }));
        break;
      case _public.ChatActionClickType.updateVisualization:
        const visualizeQueryResponse = message;
        const visualizeQueryResponseData = JSON.parse((_visualizeQueryRespon = visualizeQueryResponse.message.data) !== null && _visualizeQueryRespon !== void 0 ? _visualizeQueryRespon : '{}');
        next(messages.slice(0, messages.indexOf(visualizeQueryResponse)).concat({
          '@timestamp': new Date().toISOString(),
          message: {
            name: 'visualize_query',
            content: visualizeQueryResponse.message.content,
            data: JSON.stringify({
              ...visualizeQueryResponseData,
              userOverrides: payload.userOverrides
            }),
            role: _public.MessageRole.User
          }
        }));
        break;
      case _public.ChatActionClickType.visualizeEsqlQuery:
        next(messages.concat({
          '@timestamp': new Date().toISOString(),
          message: {
            role: _public.MessageRole.Assistant,
            content: '',
            function_call: {
              name: 'visualize_query',
              arguments: JSON.stringify({
                query: payload.query,
                intention: _public.VisualizeESQLUserIntention.visualizeAuto
              }),
              trigger: _public.MessageRole.User
            }
          }
        }));
        break;
    }
  };
  if (!hasCorrectLicense && !initialConversationId) {
    var _connectors$connector;
    footer = /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: true,
      className: incorrectLicenseContainer
    }, /*#__PURE__*/_react.default.createElement(_incorrect_license_panel.IncorrectLicensePanel, null)), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiHorizontalRule, {
      margin: "none"
    })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
      hasBorder: false,
      hasShadow: false,
      paddingSize: "m"
    }, /*#__PURE__*/_react.default.createElement(_prompt_editor.PromptEditor, {
      hidden: connectors.loading || ((_connectors$connector = connectors.connectors) === null || _connectors$connector === void 0 ? void 0 : _connectors$connector.length) === 0,
      loading: isLoading,
      disabled: true,
      onChangeHeight: setPromptEditorHeight,
      onSubmit: message => {
        next(messages.concat(message));
      },
      onSendTelemetry: eventWithPayload => chatService.sendAnalyticsEvent(eventWithPayload)
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "s"
    }))));
  } else if (!conversation.value && conversation.loading) {
    footer = null;
  } else {
    var _connectors$connector2, _connectors$connector3, _connectors$connector4;
    footer = /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: true,
      className: timelineClassName(scrollBarStyles)
    }, /*#__PURE__*/_react.default.createElement("div", {
      ref: timelineContainerRef,
      className: fullHeightClassName
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
      grow: true,
      hasBorder: false,
      hasShadow: false,
      paddingSize: "m",
      className: animClassName
    }, ((_connectors$connector2 = connectors.connectors) === null || _connectors$connector2 === void 0 ? void 0 : _connectors$connector2.length) === 0 || messages.length === 1 ? /*#__PURE__*/_react.default.createElement(_welcome_message.WelcomeMessage, {
      connectors: connectors,
      knowledgeBase: knowledgeBase,
      onSelectPrompt: message => next(messages.concat([{
        '@timestamp': new Date().toISOString(),
        message: {
          content: message,
          role: _public.MessageRole.User
        }
      }]))
    }) : /*#__PURE__*/_react.default.createElement(_chat_timeline.ChatTimeline, {
      messages: messages,
      knowledgeBase: knowledgeBase,
      chatService: chatService,
      currentUser: currentUser,
      chatState: state,
      hasConnector: !!((_connectors$connector3 = connectors.connectors) !== null && _connectors$connector3 !== void 0 && _connectors$connector3.length),
      onEdit: (editedMessage, newMessage) => {
        setStickToBottom(true);
        const indexOf = messages.indexOf(editedMessage);
        next(messages.slice(0, indexOf).concat(newMessage));
      },
      onFeedback: handleFeedback,
      onRegenerate: message => {
        next(reverseToLastUserMessage(messages, message));
      },
      onSendTelemetry: eventWithPayload => chatService.sendAnalyticsEvent(eventWithPayload),
      onStopGenerating: stop,
      onActionClick: handleActionClick
    })))), simulatedFunctionCallingEnabled ? /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, /*#__PURE__*/_react.default.createElement(_simulated_function_calling_callout.SimulatedFunctionCallingCallout, null)) : null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false,
      className: promptEditorClassname,
      style: {
        height: promptEditorHeight
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiHorizontalRule, {
      margin: "none"
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
      hasBorder: false,
      hasShadow: false,
      paddingSize: "m",
      color: "subdued",
      className: promptEditorContainerClassName
    }, /*#__PURE__*/_react.default.createElement(_prompt_editor.PromptEditor, {
      disabled: !connectors.selectedConnector || !hasCorrectLicense,
      hidden: connectors.loading || ((_connectors$connector4 = connectors.connectors) === null || _connectors$connector4 === void 0 ? void 0 : _connectors$connector4.length) === 0,
      loading: isLoading,
      onChangeHeight: handleChangeHeight,
      onSendTelemetry: eventWithPayload => chatService.sendAnalyticsEvent(eventWithPayload),
      onSubmit: message => {
        setStickToBottom(true);
        return next(messages.concat(message));
      }
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "s"
    }))));
  }
  if (conversation.error) {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      direction: "column",
      className: containerClassName,
      gutterSize: "none",
      justifyContent: "center",
      responsive: false
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false,
      className: chatBodyContainerClassNameWithError
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
      color: "danger",
      title: _i18n.i18n.translate('xpack.observabilityAiAssistant.couldNotFindConversationTitle', {
        defaultMessage: 'Conversation not found'
      }),
      iconType: "warning"
    }, _i18n.i18n.translate('xpack.observabilityAiAssistant.couldNotFindConversationContent', {
      defaultMessage: 'Could not find a conversation with id {conversationId}. Make sure the conversation exists and you have access to it.',
      values: {
        conversationId: initialConversationId
      }
    }))));
  }
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    gutterSize: "none",
    className: containerClassName,
    responsive: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    className: conversation.error ? chatBodyContainerClassNameWithError : undefined
  }, conversation.error ? /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    color: "danger",
    title: _i18n.i18n.translate('xpack.observabilityAiAssistant.couldNotFindConversationTitle', {
      defaultMessage: 'Conversation not found'
    }),
    iconType: "warning"
  }, _i18n.i18n.translate('xpack.observabilityAiAssistant.couldNotFindConversationContent', {
    defaultMessage: 'Could not find a conversation with id {conversationId}. Make sure the conversation exists and you have access to it.',
    values: {
      conversationId: initialConversationId
    }
  })) : null), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    className: headerContainerClassName
  }, /*#__PURE__*/_react.default.createElement(_chat_header.ChatHeader, {
    connectors: connectors,
    conversationId: (_conversation$value4 = conversation.value) !== null && _conversation$value4 !== void 0 && _conversation$value4.conversation && 'id' in conversation.value.conversation ? conversation.value.conversation.id : undefined,
    flyoutPositionMode: flyoutPositionMode,
    licenseInvalid: !hasCorrectLicense && !initialConversationId,
    loading: isLoading,
    title: title,
    onCopyConversation: handleCopyConversation,
    onSaveTitle: newTitle => {
      saveTitle(newTitle);
    },
    onToggleFlyoutPositionMode: onToggleFlyoutPositionMode
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiHorizontalRule, {
    margin: "none"
  })), footer);
}

// Exported for testing only
function reverseToLastUserMessage(messages, message) {
  // Drop messages after and including the one marked for regeneration
  const indexOf = messages.indexOf(message);
  const previousMessages = messages.slice(0, indexOf);

  // Go back to the last written user message to fully regenerate function calls
  const lastUserMessageIndex = (0, _lodash.findLastIndex)(previousMessages, aMessage => aMessage.message.role === 'user' && !aMessage.message.name);
  const nextMessages = previousMessages.slice(0, lastUserMessageIndex + 1);
  return nextMessages;
}