"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SparkPlot = SparkPlot;
var _charts = require("@elastic/charts");
var _react = _interopRequireDefault(require("react"));
var _i18n = require("@kbn/i18n");
var _use_chart_theme = require("../../hooks/use_chart_theme");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function SparkPlot({
  type,
  timeseries,
  annotations
}) {
  const defaultChartTheme = (0, _use_chart_theme.useChartTheme)();
  const sparkplotChartTheme = {
    chartMargins: {
      left: 0,
      right: 0,
      top: 0,
      bottom: 0
    },
    chartPaddings: {
      top: 12,
      bottom: 12
    },
    lineSeriesStyle: {
      point: {
        opacity: 0
      }
    },
    areaSeriesStyle: {
      point: {
        opacity: 0
      }
    }
  };
  return /*#__PURE__*/_react.default.createElement(_charts.Chart, {
    size: {
      width: 128,
      height: 64
    }
  }, /*#__PURE__*/_react.default.createElement(_charts.Settings, {
    theme: [sparkplotChartTheme, ...defaultChartTheme.theme],
    baseTheme: defaultChartTheme.baseTheme,
    showLegend: false,
    locale: _i18n.i18n.getLocale()
  }), /*#__PURE__*/_react.default.createElement(_charts.Tooltip, {
    type: "none"
  }), type && type === 'bar' ? /*#__PURE__*/_react.default.createElement(_charts.BarSeries, {
    id: "Sparkbar",
    xScaleType: _charts.ScaleType.Linear,
    yScaleType: _charts.ScaleType.Linear,
    xAccessor: "x",
    yAccessors: ['y'],
    data: timeseries
  }) : /*#__PURE__*/_react.default.createElement(_charts.LineSeries, {
    id: "Sparkline",
    xScaleType: _charts.ScaleType.Time,
    yScaleType: _charts.ScaleType.Linear,
    xAccessor: 'x',
    yAccessors: ['y'],
    data: timeseries,
    curve: _charts.CurveType.CURVE_MONOTONE_X
  }), annotations === null || annotations === void 0 ? void 0 : annotations.map(annotation => {
    return /*#__PURE__*/_react.default.createElement(_charts.LineAnnotation, {
      id: annotation.id,
      dataValues: [{
        dataValue: annotation.x,
        header: annotation.label
      }],
      domainType: _charts.AnnotationDomainType.XDomain,
      marker: annotation.icon,
      markerPosition: _charts.Position.Bottom,
      style: {
        line: {
          strokeWidth: 2,
          stroke: annotation.color
        }
      }
    });
  }));
}