"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getUiSettings = void 0;
var _configSchema = require("@kbn/config-schema");
var _i18n = require("@kbn/i18n");
var _constants = require("../common/constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const categoryLabel = _i18n.i18n.translate('navigation.uiSettings.categoryLabel', {
  defaultMessage: 'Technical preview'
});

/**
 * uiSettings definitions for Navigation
 */
const getUiSettings = config => {
  return {
    [_constants.ENABLE_SOLUTION_NAV_UI_SETTING_ID]: {
      category: [categoryLabel],
      name: _i18n.i18n.translate('navigation.uiSettings.enableSolutionNav.name', {
        defaultMessage: 'Enable solution navigation'
      }),
      description: _i18n.i18n.translate('navigation.uiSettings.enableSolutionNav.description', {
        defaultMessage: 'Let users opt in or out from the new solution navigation experience.'
      }),
      schema: _configSchema.schema.boolean(),
      value: config.solutionNavigation.enabled,
      order: 1
    }
  };
};
exports.getUiSettings = getUiSettings;