"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useSolutionNavUserProfileToggle = void 0;
var _react = require("react");
var _userProfileComponents = require("@kbn/user-profile-components");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const useSolutionNavUserProfileToggle = ({
  defaultOptOutValue
}) => {
  const [hasOptOut, setHasOptOut] = (0, _react.useState)(defaultOptOutValue);
  const {
    userProfileData,
    isLoading,
    update,
    userProfileEnabled
  } = (0, _userProfileComponents.useUpdateUserProfile)();
  const {
    userSettings: {
      solutionNavOptOut = defaultOptOutValue
    } = {}
  } = userProfileData !== null && userProfileData !== void 0 ? userProfileData : {};
  const toggle = (0, _react.useCallback)(on => {
    if (isLoading) {
      return;
    }

    // optimistic update
    setHasOptOut(on);
    update({
      userSettings: {
        solutionNavOptOut: on
      }
    });
  }, [isLoading, update]);
  (0, _react.useEffect)(() => {
    setHasOptOut(solutionNavOptOut);
  }, [solutionNavOptOut]);
  return {
    toggle,
    hasOptOut,
    userProfileEnabled
  };
};
exports.useSolutionNavUserProfileToggle = useSolutionNavUserProfileToggle;