"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.NavigationPublicPlugin = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _react = _interopRequireDefault(require("react"));
var _rxjs = require("rxjs");
var _solutionNavEs = require("@kbn/solution-nav-es");
var _solutionNavOblt = require("@kbn/solution-nav-oblt");
var _solutionNavAnalytics = require("@kbn/solution-nav-analytics");
var _common = require("../common");
var _top_nav_menu = require("./top_nav_menu");
var _side_navigation = require("./side_navigation");
var _solution_nav_userprofile_toggle = require("./solution_nav_userprofile_toggle");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const DEFAULT_OPT_OUT_NEW_NAV = false;
class NavigationPublicPlugin {
  constructor(initializerContext) {
    (0, _defineProperty2.default)(this, "topNavMenuExtensionsRegistry", new _top_nav_menu.TopNavMenuExtensionsRegistry());
    (0, _defineProperty2.default)(this, "stop$", new _rxjs.ReplaySubject(1));
    (0, _defineProperty2.default)(this, "coreStart", void 0);
    (0, _defineProperty2.default)(this, "depsStart", void 0);
    (0, _defineProperty2.default)(this, "isSolutionNavEnabled$", (0, _rxjs.of)(false));
    (0, _defineProperty2.default)(this, "userProfileOptOut$", (0, _rxjs.of)(undefined));
    (0, _defineProperty2.default)(this, "userProfileMenuItemAdded", false);
    this.initializerContext = initializerContext;
  }
  setup(_core) {
    return {
      registerMenuItem: this.topNavMenuExtensionsRegistry.register.bind(this.topNavMenuExtensionsRegistry)
    };
  }
  start(core, depsStart) {
    this.coreStart = core;
    this.depsStart = depsStart;
    const {
      unifiedSearch,
      cloud,
      security,
      cloudExperiments
    } = depsStart;
    const extensions = this.topNavMenuExtensionsRegistry.getAll();
    const chrome = core.chrome;
    if (security) {
      this.userProfileOptOut$ = security.userProfiles.userProfileLoaded$.pipe((0, _rxjs.skipWhile)(loaded => {
        return !loaded;
      }), (0, _rxjs.switchMap)(() => {
        return security.userProfiles.userProfile$;
      }), (0, _rxjs.map)(profile => {
        var _profile$userSettings;
        return profile === null || profile === void 0 ? void 0 : (_profile$userSettings = profile.userSettings) === null || _profile$userSettings === void 0 ? void 0 : _profile$userSettings.solutionNavOptOut;
      }), (0, _rxjs.distinctUntilChanged)());
    }

    /*
     *
     *  This helps clients of navigation to create
     *  a TopNav Search Bar which does not uses global unifiedSearch/data/query service
     *
     *  Useful in creating multiple stateful SearchBar in the same app without affecting
     *  global filters
     *
     * */
    const createCustomTopNav = (customUnifiedSearch, customExtensions) => {
      return (0, _top_nav_menu.createTopNav)(customUnifiedSearch !== null && customUnifiedSearch !== void 0 ? customUnifiedSearch : unifiedSearch, customExtensions !== null && customExtensions !== void 0 ? customExtensions : extensions);
    };
    const config = this.initializerContext.config.get();
    const {
      solutionNavigation: {
        defaultSolution
      }
    } = config;
    const onCloud = cloud !== undefined; // The new side nav will initially only be available to cloud users
    const isServerless = this.initializerContext.env.packageInfo.buildFlavor === 'serverless';
    let isSolutionNavExperiementEnabled$ = (0, _rxjs.of)(false);
    this.isSolutionNavEnabled$ = (0, _rxjs.of)(false);
    if (cloudExperiments) {
      isSolutionNavExperiementEnabled$ = !onCloud || isServerless ? (0, _rxjs.of)(false) : (0, _rxjs.from)(cloudExperiments.getVariation(_common.SOLUTION_NAV_FEATURE_FLAG_NAME, false)).pipe((0, _rxjs.shareReplay)(1));
      this.isSolutionNavEnabled$ = isSolutionNavExperiementEnabled$.pipe((0, _rxjs.switchMap)(isFeatureEnabled => {
        return !isFeatureEnabled ? (0, _rxjs.of)(false) : (0, _rxjs.combineLatest)([core.settings.globalClient.get$(_common.ENABLE_SOLUTION_NAV_UI_SETTING_ID), this.userProfileOptOut$]).pipe((0, _rxjs.takeUntil)(this.stop$), (0, _rxjs.debounceTime)(10), (0, _rxjs.map)(([enabled, userOptedOut]) => {
          if (!enabled || userOptedOut === true) return false;
          return true;
        }));
      }));
    }
    this.isSolutionNavEnabled$.pipe((0, _rxjs.takeUntil)(this.stop$), (0, _rxjs.distinctUntilChanged)()).subscribe(isSolutionNavEnabled => {
      if (isServerless) return; // Serverless already controls the chrome style

      chrome.setChromeStyle(isSolutionNavEnabled ? 'project' : 'classic');
    });

    // Initialize the solution navigation if it is enabled
    isSolutionNavExperiementEnabled$.pipe((0, _rxjs.take)(1)).subscribe(isFeatureEnabled => {
      if (!isFeatureEnabled) return;
      chrome.project.setCloudUrls(cloud);
      this.addDefaultSolutionNavigation({
        chrome
      });
      this.susbcribeToSolutionNavUiSettings({
        core,
        security,
        defaultSolution
      });
    });

    // Keep track of the solution navigation enabled state
    let isSolutionNavEnabled = false;
    isSolutionNavExperiementEnabled$.pipe((0, _rxjs.takeUntil)(this.stop$)).subscribe(_isSolutionNavEnabled => {
      isSolutionNavEnabled = _isSolutionNavEnabled;
    });
    return {
      ui: {
        TopNavMenu: (0, _top_nav_menu.createTopNav)(unifiedSearch, extensions),
        AggregateQueryTopNavMenu: (0, _top_nav_menu.createTopNav)(unifiedSearch, extensions),
        createTopNavWithCustomContext: createCustomTopNav
      },
      addSolutionNavigation: solutionNavigation => {
        if (!isSolutionNavEnabled) return;
        return this.addSolutionNavigation(solutionNavigation);
      },
      isSolutionNavEnabled$: this.isSolutionNavEnabled$
    };
  }
  stop() {
    this.stop$.next();
  }
  susbcribeToSolutionNavUiSettings({
    core,
    security,
    defaultSolution
  }) {
    const chrome = core.chrome;
    (0, _rxjs.combineLatest)([core.settings.globalClient.get$(_common.ENABLE_SOLUTION_NAV_UI_SETTING_ID), this.userProfileOptOut$]).pipe((0, _rxjs.takeUntil)(this.stop$), (0, _rxjs.debounceTime)(10)).subscribe(([enabled, userOptedOut]) => {
      if (enabled) {
        // Add menu item in the user profile menu to opt in/out of the new navigation
        this.addOptInOutUserProfile({
          core,
          security,
          userOptedOut
        });
      } else {
        // TODO. Remove the user profile menu item if the feature is disabled.
        // But first let's wait as maybe there will be a page refresh when opting out.
      }
      if (!enabled || userOptedOut === true) {
        chrome.project.changeActiveSolutionNavigation(null);
        chrome.setChromeStyle('classic');
      } else {
        chrome.project.changeActiveSolutionNavigation(defaultSolution, {
          onlyIfNotSet: true
        });
      }
    });
  }
  getSideNavComponent({
    dataTestSubj,
    panelContentProvider
  } = {}) {
    if (!this.coreStart) throw new Error('coreStart is not available');
    if (!this.depsStart) throw new Error('depsStart is not available');
    const core = this.coreStart;
    const {
      project
    } = core.chrome;
    const activeNavigationNodes$ = project.getActiveNavigationNodes$();
    const navigationTreeUi$ = project.getNavigationTreeUi$();
    return () => /*#__PURE__*/_react.default.createElement(_side_navigation.SideNavComponent, {
      navProps: {
        navigationTree$: navigationTreeUi$,
        dataTestSubj,
        panelContentProvider
      },
      deps: {
        core,
        activeNodes$: activeNavigationNodes$
      }
    });
  }
  addSolutionNavigation(solutionNavigation) {
    if (!this.coreStart) throw new Error('coreStart is not available');
    const {
      dataTestSubj,
      panelContentProvider,
      ...rest
    } = solutionNavigation;
    const sideNavComponent = this.getSideNavComponent({
      dataTestSubj,
      panelContentProvider
    });
    const {
      project
    } = this.coreStart.chrome;
    project.updateSolutionNavigations({
      [solutionNavigation.id]: {
        ...rest,
        sideNavComponent
      }
    });
  }
  addDefaultSolutionNavigation({
    chrome
  }) {
    const solutionNavs = {
      es: {
        ..._solutionNavEs.definition,
        sideNavComponent: this.getSideNavComponent({
          dataTestSubj: 'searchSideNav'
        })
      },
      oblt: {
        ..._solutionNavOblt.definition,
        sideNavComponent: this.getSideNavComponent({
          dataTestSubj: 'observabilitySideNav'
        })
      },
      analytics: {
        ..._solutionNavAnalytics.definition,
        sideNavComponent: this.getSideNavComponent({
          dataTestSubj: 'analyticsSideNav'
        })
      }
    };
    chrome.project.updateSolutionNavigations(solutionNavs, true);
  }
  addOptInOutUserProfile({
    core,
    security,
    userOptedOut
  }) {
    if (!security || this.userProfileMenuItemAdded) return;
    const defaultOptOutValue = userOptedOut !== undefined ? userOptedOut : DEFAULT_OPT_OUT_NEW_NAV;
    const menuLink = {
      content: /*#__PURE__*/_react.default.createElement(_solution_nav_userprofile_toggle.SolutionNavUserProfileToggle, {
        core: core,
        security: security,
        defaultOptOutValue: defaultOptOutValue
      }),
      order: 500,
      label: '',
      iconType: '',
      href: ''
    };
    security.navControlService.addUserMenuLinks([menuLink]);
    this.userProfileMenuItemAdded = true;
  }
}
exports.NavigationPublicPlugin = NavigationPublicPlugin;