"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ESQLWorker = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _antlr = require("antlr4");
var _esqlAst = require("@kbn/esql-ast");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

/**
 * While this function looks similar to the wrapAsMonacoMessages one, it prevents from
 * loading the whole monaco stuff within the WebWorker.
 * Given that we're dealing only with EditorError objects here, and not other types, it is
 * possible to use this simpler inline function to work.
 */
function inlineToMonacoErrors({
  severity,
  ...error
}) {
  return {
    ...error,
    severity: severity === 'error' ? 8 : 4 // monaco.MarkerSeverity.Error : monaco.MarkerSeverity.Warning
  };
}
class ESQLWorker {
  constructor(ctx) {
    (0, _defineProperty2.default)(this, "_ctx", void 0);
    this._ctx = ctx;
  }
  getModelCharStream(modelUri) {
    const model = this._ctx.getMirrorModels().find(m => m.uri.toString() === modelUri);
    const text = model === null || model === void 0 ? void 0 : model.getValue();
    if (text) {
      return _antlr.CharStreams.fromString(text);
    }
  }
  async getSyntaxErrors(modelUri) {
    const inputStream = this.getModelCharStream(modelUri);
    if (inputStream) {
      const errorListener = new _esqlAst.ESQLErrorListener();
      const parser = (0, _esqlAst.getParser)(inputStream, errorListener);
      parser[_esqlAst.ROOT_STATEMENT]();
      return errorListener.getErrors().map(inlineToMonacoErrors);
    }
    return [];
  }
  getAst(text) {
    const rawAst = (0, _esqlAst.getAstAndSyntaxErrors)(text);
    return {
      ast: rawAst.ast,
      errors: rawAst.errors.map(inlineToMonacoErrors)
    };
  }
}
exports.ESQLWorker = ESQLWorker;