"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.wrapAsMonacoSuggestions = wrapAsMonacoSuggestions;
var _monaco_imports = require("../../../monaco_imports");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

function wrapAsMonacoSuggestions(suggestions) {
  return suggestions.map(({
    label,
    text,
    asSnippet,
    kind,
    detail,
    documentation,
    sortText,
    command
  }) => ({
    label,
    insertText: text,
    kind: kind in _monaco_imports.monaco.languages.CompletionItemKind ? _monaco_imports.monaco.languages.CompletionItemKind[kind] : _monaco_imports.monaco.languages.CompletionItemKind.Method,
    // fallback to Method
    detail,
    documentation,
    sortText,
    command,
    insertTextRules: asSnippet ? _monaco_imports.monaco.languages.CompletionItemInsertTextRule.InsertAsSnippet : undefined,
    range: undefined
  }));
}