"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.buildConsoleSharedTheme = void 0;
var _eui = require("@elastic/eui");
var _uiTheme = require("@kbn/ui-theme");
var _theme = require("../../common/theme");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const buildRuleGroup = (0, _theme.themeRuleGroupBuilderFactory)();
const background = _uiTheme.euiThemeVars.euiColorLightestShade;
const stringTextColor = '#009926';
const commentTextColor = '#4C886B';
const variableTextColor = '#0079A5';
const booleanTextColor = '#585CF6';
const numericTextColor = variableTextColor;
const buildConsoleSharedTheme = () => {
  return {
    base: _uiTheme.darkMode ? 'vs-dark' : 'vs',
    inherit: true,
    rules: [...buildRuleGroup(['string', 'string-literal', 'multi-string', 'punctuation.end-triple-quote'], (0, _eui.makeHighContrastColor)(stringTextColor)(background)), ...buildRuleGroup(['comment'], (0, _eui.makeHighContrastColor)(commentTextColor)(background)), ...buildRuleGroup(['variable'], (0, _eui.makeHighContrastColor)(variableTextColor)(background)), ...buildRuleGroup(['constant.language.boolean'], (0, _eui.makeHighContrastColor)(booleanTextColor)(background)), ...buildRuleGroup(['constant.numeric'], (0, _eui.makeHighContrastColor)(numericTextColor)(background))],
    colors: {
      'editor.background': background,
      // color of the line numbers
      'editorLineNumber.foreground': _uiTheme.euiThemeVars.euiColorDarkShade,
      // color of the active line number
      'editorLineNumber.activeForeground': _uiTheme.euiThemeVars.euiColorDarkShade,
      // background of the line numbers side panel
      'editorGutter.background': _uiTheme.euiThemeVars.euiColorEmptyShade
    }
  };
};
exports.buildConsoleSharedTheme = buildConsoleSharedTheme;