"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
Object.defineProperty(exports, "CONSOLE_LANG_ID", {
  enumerable: true,
  get: function () {
    return _constants.CONSOLE_LANG_ID;
  }
});
Object.defineProperty(exports, "CONSOLE_OUTPUT_LANG_ID", {
  enumerable: true,
  get: function () {
    return _constants.CONSOLE_OUTPUT_LANG_ID;
  }
});
Object.defineProperty(exports, "CONSOLE_OUTPUT_THEME_ID", {
  enumerable: true,
  get: function () {
    return _constants.CONSOLE_OUTPUT_THEME_ID;
  }
});
Object.defineProperty(exports, "CONSOLE_THEME_ID", {
  enumerable: true,
  get: function () {
    return _constants.CONSOLE_THEME_ID;
  }
});
exports.ConsoleOutputLang = exports.ConsoleLang = void 0;
Object.defineProperty(exports, "ConsoleParsedRequestsProvider", {
  enumerable: true,
  get: function () {
    return _console_parsed_requests_provider.ConsoleParsedRequestsProvider;
  }
});
Object.defineProperty(exports, "buildConsoleOutputTheme", {
  enumerable: true,
  get: function () {
    return _theme.buildConsoleOutputTheme;
  }
});
Object.defineProperty(exports, "buildConsoleTheme", {
  enumerable: true,
  get: function () {
    return _theme.buildConsoleTheme;
  }
});
Object.defineProperty(exports, "getParsedRequestsProvider", {
  enumerable: true,
  get: function () {
    return _language.getParsedRequestsProvider;
  }
});
var _language = require("./language");
var _constants = require("./constants");
var _lexer_rules = require("./lexer_rules");
var _theme = require("./theme");
var _console_parsed_requests_provider = require("./console_parsed_requests_provider");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

/**
 * This import registers the Console monaco language contribution
 */

const ConsoleLang = exports.ConsoleLang = {
  ID: _constants.CONSOLE_LANG_ID,
  lexerRules: _lexer_rules.lexerRules,
  languageConfiguration: _lexer_rules.languageConfiguration
};
const ConsoleOutputLang = exports.ConsoleOutputLang = {
  ID: _constants.CONSOLE_OUTPUT_LANG_ID,
  lexerRules: _lexer_rules.consoleOutputLexerRules,
  languageConfiguration: _lexer_rules.consoleOutputLanguageConfiguration
};