"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.setupWorker = void 0;
var _monaco_imports = require("../monaco_imports");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const setupWorker = (langId, owner, worker) => {
  worker.setup(langId);
  const updateAnnotations = async model => {
    if (model.isDisposed()) {
      return;
    }
    const parseResult = await worker.getAnnos(model.uri);
    if (!parseResult) {
      return;
    }
    const {
      annotations
    } = parseResult;
    _monaco_imports.monaco.editor.setModelMarkers(model, owner, annotations.map(({
      at,
      text,
      type
    }) => {
      const {
        column,
        lineNumber
      } = model.getPositionAt(at);
      return {
        startLineNumber: lineNumber,
        startColumn: column,
        endLineNumber: lineNumber,
        endColumn: column,
        message: text,
        severity: type === 'error' ? _monaco_imports.monaco.MarkerSeverity.Error : _monaco_imports.monaco.MarkerSeverity.Warning
      };
    }));
  };
  const onModelAdd = model => {
    if (model.getLanguageId() !== langId) {
      return;
    }
    const {
      dispose
    } = model.onDidChangeContent(async () => {
      updateAnnotations(model);
    });
    model.onWillDispose(() => {
      dispose();
    });
    updateAnnotations(model);
  };
  _monaco_imports.monaco.editor.onDidCreateModel(onModelAdd);
};
exports.setupWorker = setupWorker;