"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.OPEN_IN_ANOMALY_EXPLORER_ACTION = void 0;
exports.createOpenInExplorerAction = createOpenInExplorerAction;
exports.isAnomalyChartsEmbeddableContext = isAnomalyChartsEmbeddableContext;
var _i18n = require("@kbn/i18n");
var _mlAnomalyUtils = require("@kbn/ml-anomaly-utils");
var _mlIsPopulatedObject = require("@kbn/ml-is-populated-object");
var _presentationPublishing = require("@kbn/presentation-publishing");
var _locator = require("../../common/constants/locator");
var _embeddables = require("../embeddables");
var _types = require("../embeddables/anomaly_swimlane/types");
var _get_embeddable_time_range = require("./get_embeddable_time_range");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const OPEN_IN_ANOMALY_EXPLORER_ACTION = exports.OPEN_IN_ANOMALY_EXPLORER_ACTION = 'openInAnomalyExplorerAction';
function isAnomalyChartsEmbeddableContext(arg) {
  return (0, _mlIsPopulatedObject.isPopulatedObject)(arg, ['embeddable']) && (0, _presentationPublishing.apiIsOfType)(arg.embeddable, _embeddables.ANOMALY_EXPLORER_CHARTS_EMBEDDABLE_TYPE);
}
function createOpenInExplorerAction(getStartServices) {
  return {
    id: 'open-in-anomaly-explorer',
    type: OPEN_IN_ANOMALY_EXPLORER_ACTION,
    order: 40,
    getIconType() {
      return 'visTable';
    },
    getDisplayName() {
      return _i18n.i18n.translate('xpack.ml.actions.openInAnomalyExplorerTitle', {
        defaultMessage: 'Open in Anomaly Explorer'
      });
    },
    async getHref(context) {
      const [, pluginsStart] = await getStartServices();
      const locator = pluginsStart.share.url.locators.get(_locator.ML_APP_LOCATOR);
      if ((0, _types.isSwimLaneEmbeddableContext)(context)) {
        const {
          data,
          embeddable
        } = context;
        const {
          viewBy,
          jobIds,
          perPage,
          fromPage
        } = embeddable;
        return locator.getUrl({
          page: 'explorer',
          pageState: {
            jobIds: jobIds.getValue(),
            timeRange: (0, _get_embeddable_time_range.getEmbeddableTimeRange)(embeddable),
            mlExplorerSwimlane: {
              viewByFromPage: fromPage.getValue(),
              viewByPerPage: perPage.getValue(),
              viewByFieldName: viewBy.getValue(),
              ...(data ? {
                selectedType: data.type,
                selectedTimes: data.times,
                selectedLanes: data.lanes
              } : {})
            }
          }
        });
      } else if (isAnomalyChartsEmbeddableContext(context)) {
        const {
          embeddable
        } = context;
        const {
          jobIds,
          entityFields
        } = embeddable;
        let mlExplorerFilter;
        const entityFieldsValue = entityFields.getValue();
        if (Array.isArray(entityFieldsValue) && entityFieldsValue.length === 1 && entityFieldsValue[0].operation === _mlAnomalyUtils.ML_ENTITY_FIELD_OPERATIONS.ADD) {
          const {
            fieldName,
            fieldValue
          } = entityFieldsValue[0];
          if (fieldName !== undefined && fieldValue !== undefined) {
            const influencersFilterQuery = {
              bool: {
                should: [{
                  match_phrase: {
                    [fieldName]: String(fieldValue)
                  }
                }],
                minimum_should_match: 1
              }
            };
            const filteredFields = [fieldName, fieldValue];
            mlExplorerFilter = {
              influencersFilterQuery,
              filterActive: true,
              queryString: `${fieldName}:"${fieldValue}"`,
              ...(Array.isArray(filteredFields) ? {
                filteredFields
              } : {})
            };
          }
        }
        return locator.getUrl({
          page: 'explorer',
          pageState: {
            jobIds: jobIds.getValue(),
            timeRange: (0, _get_embeddable_time_range.getEmbeddableTimeRange)(embeddable),
            // @ts-ignore QueryDslQueryContainer is not compatible with SerializableRecord
            ...(mlExplorerFilter ? {
              mlExplorerFilter
            } : {}),
            query: {}
          }
        });
      }
    },
    async execute(context) {
      if (!context.embeddable) {
        throw new Error('Not possible to execute an action without the embeddable context');
      }
      const [{
        application
      }] = await getStartServices();
      const anomalyExplorerUrl = await this.getHref(context);
      if (anomalyExplorerUrl) {
        await application.navigateToUrl(anomalyExplorerUrl);
      }
    },
    async isCompatible(context) {
      return (0, _types.isSwimLaneEmbeddableContext)(context) || isAnomalyChartsEmbeddableContext(context);
    }
  };
}