"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
Object.defineProperty(exports, "APPLY_INFLUENCER_FILTERS_ACTION", {
  enumerable: true,
  get: function () {
    return _apply_influencer_filters_action.APPLY_INFLUENCER_FILTERS_ACTION;
  }
});
Object.defineProperty(exports, "APPLY_TIME_RANGE_SELECTION_ACTION", {
  enumerable: true,
  get: function () {
    return _apply_time_range_action.APPLY_TIME_RANGE_SELECTION_ACTION;
  }
});
Object.defineProperty(exports, "CREATE_LENS_VIS_TO_ML_AD_JOB_ACTION", {
  enumerable: true,
  get: function () {
    return _open_vis_in_ml_action.CREATE_LENS_VIS_TO_ML_AD_JOB_ACTION;
  }
});
Object.defineProperty(exports, "EDIT_SWIMLANE_PANEL_ACTION", {
  enumerable: true,
  get: function () {
    return _edit_swimlane_panel_action.EDIT_SWIMLANE_PANEL_ACTION;
  }
});
Object.defineProperty(exports, "OPEN_IN_ANOMALY_EXPLORER_ACTION", {
  enumerable: true,
  get: function () {
    return _open_in_anomaly_explorer_action.OPEN_IN_ANOMALY_EXPLORER_ACTION;
  }
});
Object.defineProperty(exports, "SWIM_LANE_SELECTION_TRIGGER", {
  enumerable: true,
  get: function () {
    return _triggers.SWIM_LANE_SELECTION_TRIGGER;
  }
});
exports.registerMlUiActions = registerMlUiActions;
var _public = require("@kbn/embeddable-plugin/public");
var _mlUiActions = require("@kbn/ml-ui-actions");
var _apply_entity_filters_action = require("./apply_entity_filters_action");
var _apply_influencer_filters_action = require("./apply_influencer_filters_action");
var _apply_time_range_action = require("./apply_time_range_action");
var _clear_selection_action = require("./clear_selection_action");
var _create_swim_lane = require("./create_swim_lane");
var _edit_anomaly_charts_panel_action = require("./edit_anomaly_charts_panel_action");
var _edit_swimlane_panel_action = require("./edit_swimlane_panel_action");
var _edit_single_metric_viewer_panel_action = require("./edit_single_metric_viewer_panel_action");
var _open_create_categorization_job_action = require("./open_create_categorization_job_action");
var _open_in_anomaly_explorer_action = require("./open_in_anomaly_explorer_action");
var _open_in_single_metric_viewer_action = require("./open_in_single_metric_viewer_action");
var _open_vis_in_ml_action = require("./open_vis_in_ml_action");
var _triggers = require("./triggers");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * Register ML UI actions
 */
function registerMlUiActions(uiActions, core) {
  // Initialize actions
  const addSwimlanePanelAction = (0, _create_swim_lane.createAddSwimlanePanelAction)(core.getStartServices);
  const editSwimlanePanelAction = (0, _edit_swimlane_panel_action.createEditSwimlanePanelAction)(core.getStartServices);
  const editSingleMetricViewerPanelAction = (0, _edit_single_metric_viewer_panel_action.createEditSingleMetricViewerPanelAction)(core.getStartServices);
  const openInExplorerAction = (0, _open_in_anomaly_explorer_action.createOpenInExplorerAction)(core.getStartServices);
  const openInSingleMetricViewerAction = (0, _open_in_single_metric_viewer_action.createOpenInSingleMetricViewerAction)(core.getStartServices);
  const applyInfluencerFiltersAction = (0, _apply_influencer_filters_action.createApplyInfluencerFiltersAction)(core.getStartServices);
  const applyEntityFieldFilterAction = (0, _apply_entity_filters_action.createApplyEntityFieldFiltersAction)(core.getStartServices);
  const applyTimeRangeSelectionAction = (0, _apply_time_range_action.createApplyTimeRangeSelectionAction)(core.getStartServices);
  const clearSelectionAction = (0, _clear_selection_action.createClearSelectionAction)(core.getStartServices);
  const editExplorerPanelAction = (0, _edit_anomaly_charts_panel_action.createEditAnomalyChartsPanelAction)(core.getStartServices);
  const visToAdJobAction = (0, _open_vis_in_ml_action.createVisToADJobAction)(core.getStartServices);
  const categorizationADJobAction = (0, _open_create_categorization_job_action.createCategorizationADJobAction)(core.getStartServices);

  // Register actions
  uiActions.registerAction(applyEntityFieldFilterAction);
  uiActions.registerAction(applyTimeRangeSelectionAction);
  uiActions.registerAction(categorizationADJobAction);

  // Assign triggers
  uiActions.addTriggerAction('ADD_PANEL_TRIGGER', addSwimlanePanelAction);
  uiActions.addTriggerAction(_public.CONTEXT_MENU_TRIGGER, editSwimlanePanelAction);
  uiActions.addTriggerAction(_public.CONTEXT_MENU_TRIGGER, editSingleMetricViewerPanelAction);
  uiActions.addTriggerAction(_public.CONTEXT_MENU_TRIGGER, editExplorerPanelAction);
  uiActions.addTriggerAction(_public.CONTEXT_MENU_TRIGGER, openInExplorerAction);
  uiActions.attachAction(_public.CONTEXT_MENU_TRIGGER, openInSingleMetricViewerAction.id);
  uiActions.registerTrigger(_triggers.swimLaneSelectionTrigger);
  uiActions.registerTrigger(_triggers.entityFieldSelectionTrigger);
  uiActions.registerTrigger(_open_create_categorization_job_action.createCategorizationADJobTrigger);
  uiActions.addTriggerAction(_triggers.SWIM_LANE_SELECTION_TRIGGER, applyInfluencerFiltersAction);
  uiActions.addTriggerAction(_triggers.SWIM_LANE_SELECTION_TRIGGER, applyTimeRangeSelectionAction);
  uiActions.addTriggerAction(_triggers.SWIM_LANE_SELECTION_TRIGGER, openInExplorerAction);
  uiActions.addTriggerAction(_triggers.SWIM_LANE_SELECTION_TRIGGER, openInSingleMetricViewerAction);
  uiActions.addTriggerAction(_triggers.SWIM_LANE_SELECTION_TRIGGER, clearSelectionAction);
  uiActions.addTriggerAction(_triggers.EXPLORER_ENTITY_FIELD_SELECTION_TRIGGER, applyEntityFieldFilterAction);
  uiActions.addTriggerAction(_public.CONTEXT_MENU_TRIGGER, visToAdJobAction);
  uiActions.addTriggerAction(_mlUiActions.CREATE_PATTERN_ANALYSIS_TO_ML_AD_JOB_TRIGGER, categorizationADJobAction);
}