"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EDIT_SWIMLANE_PANEL_ACTION = void 0;
exports.createEditSwimlanePanelAction = createEditSwimlanePanelAction;
var _i18n = require("@kbn/i18n");
var _public = require("@kbn/ui-actions-plugin/public");
var _types = require("../embeddables/anomaly_swimlane/types");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; } /*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const EDIT_SWIMLANE_PANEL_ACTION = exports.EDIT_SWIMLANE_PANEL_ACTION = 'editSwimlanePanelAction';
function createEditSwimlanePanelAction(getStartServices) {
  return {
    id: 'edit-anomaly-swimlane',
    type: EDIT_SWIMLANE_PANEL_ACTION,
    order: 50,
    getIconType() {
      return 'pencil';
    },
    getDisplayName: () => _i18n.i18n.translate('xpack.ml.actions.editSwimlaneTitle', {
      defaultMessage: 'Edit swim lane'
    }),
    async execute(context) {
      if (!(0, _types.isSwimLaneEmbeddableContext)(context)) {
        throw new _public.IncompatibleActionError();
      }
      const [coreStart, deps] = await getStartServices();
      try {
        const {
          resolveAnomalySwimlaneUserInput
        } = await Promise.resolve().then(() => _interopRequireWildcard(require('../embeddables/anomaly_swimlane/anomaly_swimlane_setup_flyout')));
        const {
          jobIds,
          viewBy,
          swimlaneType,
          panelTitle
        } = context.embeddable;
        const result = await resolveAnomalySwimlaneUserInput(coreStart, deps.data.dataViews, {
          jobIds: jobIds.getValue(),
          swimlaneType: swimlaneType.getValue(),
          viewBy: viewBy.getValue(),
          title: panelTitle === null || panelTitle === void 0 ? void 0 : panelTitle.getValue()
        });
        context.embeddable.updateUserInput(result);
        context.embeddable.setPanelTitle(result.panelTitle);
      } catch (e) {
        return Promise.reject();
      }
    },
    async isCompatible(context) {
      var _context$embeddable$p, _context$embeddable$p2;
      return (0, _types.isSwimLaneEmbeddableContext)(context) && ((_context$embeddable$p = context.embeddable.parentApi) === null || _context$embeddable$p === void 0 ? void 0 : (_context$embeddable$p2 = _context$embeddable$p.viewMode) === null || _context$embeddable$p2 === void 0 ? void 0 : _context$embeddable$p2.getValue()) === 'edit';
    }
  };
}