"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useSingleMetricViewerInputResolver = useSingleMetricViewerInputResolver;
var _react = require("react");
var _rxjs = require("rxjs");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function useSingleMetricViewerInputResolver(embeddableInput, refresh, timefilter, onRenderComplete) {
  const [data, setData] = (0, _react.useState)();
  const [bounds, setBounds] = (0, _react.useState)();
  const [lastRefresh, setLastRefresh] = (0, _react.useState)();
  (0, _react.useEffect)(function subscribeToEmbeddableInput() {
    const subscription = (0, _rxjs.combineLatest)([embeddableInput, refresh.pipe((0, _rxjs.startWith)(null))]).subscribe(input => {
      if (input !== undefined) {
        setData(input[0]);
        if (timefilter !== undefined) {
          const {
            timeRange
          } = input[0];
          const currentBounds = timefilter.calculateBounds(timeRange);
          setBounds(currentBounds);
          setLastRefresh(Date.now());
        }
        onRenderComplete();
      }
    });
    return () => subscription.unsubscribe();
    // eslint-disable-next-line react-hooks/exhaustive-deps
  }, []);
  return {
    data,
    bounds,
    lastRefresh
  };
}