"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SingleMetricViewerInitializer = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _series_controls = require("../../application/timeseriesexplorer/components/series_controls");
var _timeseriesexplorer_constants = require("../../application/timeseriesexplorer/timeseriesexplorer_constants");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const SingleMetricViewerInitializer = ({
  defaultTitle,
  bounds,
  initialInput,
  job,
  onCreate,
  onCancel
}) => {
  const isNewJob = (initialInput === null || initialInput === void 0 ? void 0 : initialInput.jobIds) !== undefined && (initialInput === null || initialInput === void 0 ? void 0 : initialInput.jobIds[0]) !== job.job_id;
  const [panelTitle, setPanelTitle] = (0, _react.useState)(defaultTitle);
  const [functionDescription, setFunctionDescription] = (0, _react.useState)(initialInput === null || initialInput === void 0 ? void 0 : initialInput.functionDescription);
  // Reset detector index and entities if the job has changed
  const [selectedDetectorIndex, setSelectedDetectorIndex] = (0, _react.useState)(!isNewJob && initialInput !== null && initialInput !== void 0 && initialInput.selectedDetectorIndex ? initialInput.selectedDetectorIndex : 0);
  const [selectedEntities, setSelectedEntities] = (0, _react.useState)(!isNewJob && initialInput !== null && initialInput !== void 0 && initialInput.selectedEntities ? initialInput.selectedEntities : undefined);
  const isPanelTitleValid = panelTitle.length > 0;
  const handleStateUpdate = (action, payload) => {
    switch (action) {
      case _timeseriesexplorer_constants.APP_STATE_ACTION.SET_ENTITIES:
        setSelectedEntities(payload);
        break;
      case _timeseriesexplorer_constants.APP_STATE_ACTION.SET_FUNCTION_DESCRIPTION:
        setFunctionDescription(payload);
        break;
      case _timeseriesexplorer_constants.APP_STATE_ACTION.SET_DETECTOR_INDEX:
        setSelectedDetectorIndex(payload);
        break;
      default:
        break;
    }
  };
  return /*#__PURE__*/_react.default.createElement(_eui.EuiModal, {
    maxWidth: false,
    initialFocus: "[name=panelTitle]",
    onClose: onCancel,
    "data-test-subj": 'mlSingleMetricViewerEmbeddableInitializer'
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiModalHeader, null, /*#__PURE__*/_react.default.createElement(_eui.EuiModalHeaderTitle, null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.ml.SingleMetricViewerEmbeddable.setupModal.title",
    defaultMessage: "Single metric viewer configuration"
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiModalBody, null, /*#__PURE__*/_react.default.createElement(_eui.EuiForm, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.ml.singleMetricViewerEmbeddable.panelTitleLabel",
      defaultMessage: "Panel title"
    }),
    isInvalid: !isPanelTitleValid
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldText, {
    "data-test-subj": "panelTitleInput",
    id: "panelTitle",
    name: "panelTitle",
    value: panelTitle,
    onChange: e => setPanelTitle(e.target.value),
    isInvalid: !isPanelTitleValid
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), /*#__PURE__*/_react.default.createElement(_series_controls.SeriesControls, {
    selectedJobId: job.job_id,
    job: job,
    appStateHandler: handleStateUpdate,
    selectedDetectorIndex: selectedDetectorIndex,
    selectedEntities: selectedEntities,
    bounds: bounds,
    functionDescription: functionDescription,
    setFunctionDescription: setFunctionDescription
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiModalFooter, null, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    onClick: onCancel,
    "data-test-subj": "mlsingleMetricViewerInitializerCancelButton"
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.ml.singleMetricViewerEmbeddable.setupModal.cancelButtonLabel",
    defaultMessage: "Cancel"
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    "data-test-subj": "mlSingleMetricViewerInitializerConfirmButton",
    isDisabled: !isPanelTitleValid,
    onClick: onCreate.bind(null, {
      functionDescription,
      panelTitle,
      selectedDetectorIndex,
      selectedEntities
    }),
    fill: true
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.ml.singleMetricViewerEmbeddable.setupModal.confirmButtonLabel",
    defaultMessage: "Confirm configurations"
  }))));
};
exports.SingleMetricViewerInitializer = SingleMetricViewerInitializer;