"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = exports.EmbeddableSingleMetricViewerContainer = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _moment = _interopRequireDefault(require("moment"));
var _lodash = require("lodash");
var _usePrevious = _interopRequireDefault(require("react-use/lib/usePrevious"));
var _mlErrorUtils = require("@kbn/ml-error-utils");
var _toast_notification_service = require("../../application/services/toast_notification_service");
var _use_embeddable_execution_context = require("../common/use_embeddable_execution_context");
var _use_single_metric_viewer_input_resolver = require("./use_single_metric_viewer_input_resolver");
var _ = require("..");
var _timeseriesexplorer_embeddable_chart = require("../../application/timeseriesexplorer/timeseriesexplorer_embeddable_chart");
var _timeseriesexplorer_constants = require("../../application/timeseriesexplorer/timeseriesexplorer_constants");
var _time_series_explorer_service = require("../../application/util/time_series_explorer_service");
require("./_index.scss");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const RESIZE_THROTTLE_TIME_MS = 500;
const EmbeddableSingleMetricViewerContainer = ({
  id,
  embeddableContext,
  embeddableInput$,
  services,
  refresh,
  onRenderComplete
}) => {
  var _data$functionDescrip;
  (0, _use_embeddable_execution_context.useEmbeddableExecutionContext)(services[0].executionContext, embeddableInput$, _.ANOMALY_SINGLE_METRIC_VIEWER_EMBEDDABLE_TYPE, id);
  const [chartWidth, setChartWidth] = (0, _react.useState)(0);
  const [zoom, setZoom] = (0, _react.useState)();
  const [selectedForecastId, setSelectedForecastId] = (0, _react.useState)();
  const [selectedJob, setSelectedJob] = (0, _react.useState)();
  const [autoZoomDuration, setAutoZoomDuration] = (0, _react.useState)();
  const [jobsLoaded, setJobsLoaded] = (0, _react.useState)(false);
  const [error, setError] = (0, _react.useState)();
  const {
    mlApiServices,
    mlJobService
  } = services[2];
  const {
    data,
    bounds,
    lastRefresh
  } = (0, _use_single_metric_viewer_input_resolver.useSingleMetricViewerInputResolver)(embeddableInput$, refresh, services[1].data.query.timefilter.timefilter, onRenderComplete);
  const selectedJobId = data === null || data === void 0 ? void 0 : data.jobIds[0];
  // Need to make sure we fall back to `undefined` if `functionDescription` is an empty string,
  // otherwise anomaly table data will not be loaded.
  const functionDescription = ((_data$functionDescrip = data === null || data === void 0 ? void 0 : data.functionDescription) !== null && _data$functionDescrip !== void 0 ? _data$functionDescrip : '') === '' ? undefined : data.functionDescription;
  const previousRefresh = (0, _usePrevious.default)(lastRefresh !== null && lastRefresh !== void 0 ? lastRefresh : 0);
  const mlTimeSeriesExplorer = (0, _time_series_explorer_service.useTimeSeriesExplorerService)();

  // Holds the container height for previously fetched data
  const containerHeightRef = (0, _react.useRef)();
  const toastNotificationService = (0, _toast_notification_service.useToastNotificationService)();
  (0, _react.useEffect)(function setUpJobsLoaded() {
    async function loadJobs() {
      try {
        await mlJobService.loadJobsWrapper();
        setJobsLoaded(true);
      } catch (e) {
        const errorMessage = (0, _mlErrorUtils.extractErrorMessage)(e);
        setError(errorMessage);
      }
    }
    loadJobs();
    // eslint-disable-next-line react-hooks/exhaustive-deps
  }, []);
  (0, _react.useEffect)(function setUpSelectedJob() {
    async function fetchSelectedJob() {
      if (mlApiServices && selectedJobId !== undefined && error === undefined) {
        try {
          const {
            jobs
          } = await mlApiServices.getJobs({
            jobId: selectedJobId
          });
          const job = jobs[0];
          setSelectedJob(job);
        } catch (e) {
          const errorMessage = (0, _mlErrorUtils.extractErrorMessage)(e);
          setError(errorMessage);
        }
      }
    }
    fetchSelectedJob();
  }, [selectedJobId, mlApiServices, error]);
  (0, _react.useEffect)(function setUpAutoZoom() {
    let zoomDuration;
    if (selectedJobId !== undefined && selectedJob !== undefined) {
      zoomDuration = mlTimeSeriesExplorer.getAutoZoomDuration(selectedJob);
      setAutoZoomDuration(zoomDuration);
    }
  },
  // eslint-disable-next-line react-hooks/exhaustive-deps
  [selectedJobId, selectedJob === null || selectedJob === void 0 ? void 0 : selectedJob.job_id, mlTimeSeriesExplorer]);

  // eslint-disable-next-line react-hooks/exhaustive-deps
  const resizeHandler = (0, _react.useCallback)((0, _lodash.throttle)(e => {
    // Keep previous container height so it doesn't change the page layout
    containerHeightRef.current = e.height;
    if (Math.abs(chartWidth - e.width) > 20) {
      setChartWidth(e.width);
    }
  }, RESIZE_THROTTLE_TIME_MS), [chartWidth]);
  const appStateHandler = (0, _react.useCallback)((action, payload) => {
    /**
     * Empty zoom indicates that chart hasn't been rendered yet,
     * hence any updates prior that should replace the URL state.
     */

    switch (action) {
      case _timeseriesexplorer_constants.APP_STATE_ACTION.SET_FORECAST_ID:
        setSelectedForecastId(payload);
        setZoom(undefined);
        break;
      case _timeseriesexplorer_constants.APP_STATE_ACTION.SET_ZOOM:
        setZoom(payload);
        break;
      case _timeseriesexplorer_constants.APP_STATE_ACTION.UNSET_ZOOM:
        setZoom(undefined);
        break;
    }
  }, [setZoom, setSelectedForecastId]);
  const containerPadding = 10;
  if (error) {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
      title: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.ml.singleMetricViewerEmbeddable.errorMessage",
        defaultMessage: "Unable to load the data for the single metric viewer"
      }),
      color: "danger",
      iconType: "warning",
      css: {
        width: '100%'
      }
    }, /*#__PURE__*/_react.default.createElement("p", null, error));
  }
  return /*#__PURE__*/_react.default.createElement(_eui.EuiResizeObserver, {
    onResize: resizeHandler
  }, resizeRef => /*#__PURE__*/_react.default.createElement("div", {
    id: `mlSingleMetricViewerEmbeddableWrapper-${id}`,
    style: {
      width: '100%',
      overflowY: 'auto',
      overflowX: 'hidden',
      padding: '8px'
    },
    "data-test-subj": `mlSingleMetricViewer_${embeddableContext.id}`,
    ref: resizeRef,
    className: "ml-time-series-explorer"
  }, data !== undefined && autoZoomDuration !== undefined && jobsLoaded && selectedJobId === (selectedJob === null || selectedJob === void 0 ? void 0 : selectedJob.job_id) && /*#__PURE__*/_react.default.createElement(_timeseriesexplorer_embeddable_chart.TimeSeriesExplorerEmbeddableChart, {
    chartWidth: chartWidth - containerPadding,
    dataViewsService: services[1].data.dataViews,
    toastNotificationService: toastNotificationService,
    appStateHandler: appStateHandler,
    autoZoomDuration: autoZoomDuration,
    bounds: bounds,
    dateFormatTz: _moment.default.tz.guess(),
    lastRefresh: lastRefresh !== null && lastRefresh !== void 0 ? lastRefresh : 0,
    previousRefresh: previousRefresh,
    selectedJobId: selectedJobId,
    selectedDetectorIndex: data.selectedDetectorIndex,
    selectedEntities: data.selectedEntities,
    selectedForecastId: selectedForecastId,
    tableInterval: "auto",
    tableSeverity: 0,
    zoom: zoom,
    functionDescription: functionDescription,
    selectedJob: selectedJob
  })));
};

// required for dynamic import using React.lazy()
// eslint-disable-next-line import/no-default-export
exports.EmbeddableSingleMetricViewerContainer = EmbeddableSingleMetricViewerContainer;
var _default = exports.default = EmbeddableSingleMetricViewerContainer;