"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
var _exportNames = {
  registerEmbeddables: true,
  getEmbeddableComponent: true
};
Object.defineProperty(exports, "getEmbeddableComponent", {
  enumerable: true,
  get: function () {
    return _get_embeddable_component.getEmbeddableComponent;
  }
});
exports.registerEmbeddables = registerEmbeddables;
var _public = require("@kbn/embeddable-plugin/public");
var _anomaly_charts = require("./anomaly_charts");
var _constants = require("./constants");
Object.keys(_constants).forEach(function (key) {
  if (key === "default" || key === "__esModule") return;
  if (Object.prototype.hasOwnProperty.call(_exportNames, key)) return;
  if (key in exports && exports[key] === _constants[key]) return;
  Object.defineProperty(exports, key, {
    enumerable: true,
    get: function () {
      return _constants[key];
    }
  });
});
var _single_metric_viewer = require("./single_metric_viewer");
var _get_embeddable_component = require("./get_embeddable_component");
var _types = require("./types");
Object.keys(_types).forEach(function (key) {
  if (key === "default" || key === "__esModule") return;
  if (Object.prototype.hasOwnProperty.call(_exportNames, key)) return;
  if (key in exports && exports[key] === _types[key]) return;
  Object.defineProperty(exports, key, {
    enumerable: true,
    get: function () {
      return _types[key];
    }
  });
});
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; } /*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function registerEmbeddables(embeddable, core) {
  (0, _public.registerReactEmbeddableFactory)(_constants.ANOMALY_SWIMLANE_EMBEDDABLE_TYPE, async () => {
    const {
      getAnomalySwimLaneEmbeddableFactory
    } = await Promise.resolve().then(() => _interopRequireWildcard(require('./anomaly_swimlane')));
    return getAnomalySwimLaneEmbeddableFactory(core.getStartServices);
  });
  const anomalyChartsFactory = new _anomaly_charts.AnomalyChartsEmbeddableFactory(core.getStartServices);
  embeddable.registerEmbeddableFactory(anomalyChartsFactory.type, anomalyChartsFactory);
  const singleMetricViewerFactory = new _single_metric_viewer.SingleMetricViewerEmbeddableFactory(core.getStartServices);
  embeddable.registerEmbeddableFactory(singleMetricViewerFactory.type, singleMetricViewerFactory);
}