"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.resolveEmbeddableAnomalyChartsUserInput = resolveEmbeddableAnomalyChartsUserInput;
var _react = _interopRequireDefault(require("react"));
var _reactKibanaMount = require("@kbn/react-kibana-mount");
var _job_utils = require("../../../common/util/job_utils");
var _explorer_constants = require("../../application/explorer/explorer_constants");
var _anomaly_charts_embeddable = require("./anomaly_charts_embeddable");
var _http_service = require("../../application/services/http_service");
var _resolve_job_selection = require("../common/resolve_job_selection");
var _anomaly_charts_initializer = require("./anomaly_charts_initializer");
var _ml_api_service = require("../../application/services/ml_api_service");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

async function resolveEmbeddableAnomalyChartsUserInput(coreStart, dataViews, input) {
  const {
    http,
    overlays,
    theme,
    i18n
  } = coreStart;
  const {
    getJobs
  } = (0, _ml_api_service.mlApiServicesProvider)(new _http_service.HttpService(http));
  return new Promise(async (resolve, reject) => {
    try {
      var _input$title;
      const {
        jobIds
      } = await (0, _resolve_job_selection.resolveJobSelection)(coreStart, dataViews, input === null || input === void 0 ? void 0 : input.jobIds);
      const title = (_input$title = input === null || input === void 0 ? void 0 : input.title) !== null && _input$title !== void 0 ? _input$title : (0, _anomaly_charts_embeddable.getDefaultExplorerChartsPanelTitle)(jobIds);
      const {
        jobs
      } = await getJobs({
        jobId: jobIds.join(',')
      });
      const influencers = (0, _job_utils.extractInfluencers)(jobs);
      influencers.push(_explorer_constants.VIEW_BY_JOB_LABEL);
      const modalSession = overlays.openModal((0, _reactKibanaMount.toMountPoint)( /*#__PURE__*/_react.default.createElement(_anomaly_charts_initializer.AnomalyChartsInitializer, {
        defaultTitle: title,
        initialInput: input,
        onCreate: ({
          panelTitle,
          maxSeriesToPlot
        }) => {
          modalSession.close();
          resolve({
            jobIds,
            title: panelTitle,
            maxSeriesToPlot
          });
        },
        onCancel: () => {
          modalSession.close();
          reject();
        }
      }), {
        theme,
        i18n
      }));
    } catch (error) {
      reject(error);
    }
  });
}