"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.MAX_ANOMALY_CHARTS_ALLOWED = exports.AnomalyChartsInitializer = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _anomaly_explorer_charts_service = require("../../application/services/anomaly_explorer_charts_service");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const MAX_ANOMALY_CHARTS_ALLOWED = exports.MAX_ANOMALY_CHARTS_ALLOWED = 50;
const AnomalyChartsInitializer = ({
  defaultTitle,
  initialInput,
  onCreate,
  onCancel
}) => {
  var _initialInput$maxSeri;
  const [panelTitle, setPanelTitle] = (0, _react.useState)(defaultTitle);
  const [maxSeriesToPlot, setMaxSeriesToPlot] = (0, _react.useState)((_initialInput$maxSeri = initialInput === null || initialInput === void 0 ? void 0 : initialInput.maxSeriesToPlot) !== null && _initialInput$maxSeri !== void 0 ? _initialInput$maxSeri : _anomaly_explorer_charts_service.DEFAULT_MAX_SERIES_TO_PLOT);
  const isPanelTitleValid = panelTitle.length > 0;
  const isMaxSeriesToPlotValid = maxSeriesToPlot >= 1 && maxSeriesToPlot <= MAX_ANOMALY_CHARTS_ALLOWED;
  const isFormValid = isPanelTitleValid && isMaxSeriesToPlotValid;
  return /*#__PURE__*/_react.default.createElement(_eui.EuiModal, {
    initialFocus: "[name=panelTitle]",
    onClose: onCancel,
    "data-test-subj": 'mlAnomalyChartsEmbeddableInitializer'
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiModalHeader, null, /*#__PURE__*/_react.default.createElement(_eui.EuiModalHeaderTitle, null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.ml.anomalyChartsEmbeddable.setupModal.title",
    defaultMessage: "Anomaly explorer charts configuration"
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiModalBody, null, /*#__PURE__*/_react.default.createElement(_eui.EuiForm, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.ml.anomalyChartsEmbeddable.panelTitleLabel",
      defaultMessage: "Panel title"
    }),
    isInvalid: !isPanelTitleValid
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldText, {
    "data-test-subj": "panelTitleInput",
    id: "panelTitle",
    name: "panelTitle",
    value: panelTitle,
    onChange: e => setPanelTitle(e.target.value),
    isInvalid: !isPanelTitleValid
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    isInvalid: !isMaxSeriesToPlotValid,
    error: !isMaxSeriesToPlotValid ? /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.ml.anomalyChartsEmbeddable.maxSeriesToPlotError",
      defaultMessage: "Maximum number of series to plot must be between 1 and 50."
    }) : undefined,
    label: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.ml.anomalyChartsEmbeddable.maxSeriesToPlotLabel",
      defaultMessage: "Maximum number of series to plot"
    })
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldNumber, {
    "data-test-subj": "mlAnomalyChartsInitializerMaxSeries",
    id: "selectMaxSeriesToPlot",
    name: "selectMaxSeriesToPlot",
    value: maxSeriesToPlot,
    onChange: e => setMaxSeriesToPlot(parseInt(e.target.value, 10)),
    min: 1,
    max: MAX_ANOMALY_CHARTS_ALLOWED
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiModalFooter, null, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    onClick: onCancel,
    "data-test-subj": "mlAnomalyChartsInitializerCancelButton"
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.ml.anomalyChartsEmbeddable.setupModal.cancelButtonLabel",
    defaultMessage: "Cancel"
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    "data-test-subj": "mlAnomalyChartsInitializerConfirmButton",
    isDisabled: !isFormValid,
    onClick: onCreate.bind(null, {
      panelTitle,
      maxSeriesToPlot
    }),
    fill: true
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.ml.anomalyChartsEmbeddable.setupModal.confirmButtonLabel",
    defaultMessage: "Confirm configurations"
  }))));
};
exports.AnomalyChartsInitializer = AnomalyChartsInitializer;