"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Page = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _public = require("@kbn/saved-objects-finder-plugin/public");
var _create_data_view_button = require("../../../../components/create_data_view_button");
var _kibana = require("../../../../contexts/kibana");
var _page_header = require("../../../../components/page_header");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const RESULTS_PER_PAGE = 20;
const Page = ({
  nextStepPath,
  extraButtons
}) => {
  const {
    contentManagement,
    uiSettings
  } = (0, _kibana.useMlKibana)().services;
  const navigateToPath = (0, _kibana.useNavigateToPath)();
  const onObjectSelection = (0, _react.useCallback)((id, type, name) => {
    navigateToPath(`${nextStepPath}?${type === 'index-pattern' ? 'index' : 'savedSearchId'}=${encodeURIComponent(id)}`);
  }, [navigateToPath, nextStepPath]);
  return /*#__PURE__*/_react.default.createElement("div", {
    "data-test-subj": "mlPageSourceSelection"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiPageBody, {
    restrictWidth: 1200
  }, /*#__PURE__*/_react.default.createElement(_page_header.MlPageHeader, null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.ml.newJob.wizard.selectDataViewOrSavedSearch",
    defaultMessage: "Select data view or saved search"
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    hasShadow: false,
    hasBorder: true
  }, /*#__PURE__*/_react.default.createElement(_public.SavedObjectFinder, {
    key: "searchSavedObjectFinder",
    onChoose: onObjectSelection,
    showFilter: true,
    noItemsMessage: _i18n.i18n.translate('xpack.ml.newJob.wizard.searchSelection.notFoundLabel', {
      defaultMessage: 'No matching data views or saved searches found.'
    }),
    savedObjectMetaData: [{
      type: 'search',
      getIconForSavedObject: () => 'search',
      name: _i18n.i18n.translate('xpack.ml.newJob.wizard.searchSelection.savedObjectType.search', {
        defaultMessage: 'Saved search'
      })
    }, {
      type: 'index-pattern',
      getIconForSavedObject: () => 'indexPatternApp',
      name: _i18n.i18n.translate('xpack.ml.newJob.wizard.searchSelection.savedObjectType.dataView', {
        defaultMessage: 'Data view'
      })
    }],
    fixedPageSize: RESULTS_PER_PAGE,
    services: {
      contentClient: contentManagement.client,
      uiSettings
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "row",
    gutterSize: "s"
  }, /*#__PURE__*/_react.default.createElement(_create_data_view_button.CreateDataViewButton, {
    onDataViewCreated: dataView => {
      onObjectSelection(dataView.id, 'index-pattern', dataView.getIndexPattern());
    },
    allowAdHocDataView: true
  }), extraButtons ? extraButtons : null)))));
};
exports.Page = Page;