"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.GeoMapExamples = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _split_cards = require("../split_cards");
var _ml_embedded_map = require("../../../../../../../components/ml_embedded_map");
var _new_job = require("../../../../../../../../../common/constants/new_job");
var _detector_title = require("../detector_title");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const GeoMapExamples = ({
  geoField,
  splitField,
  fieldValues,
  geoAgg,
  layerList
}) => {
  const animateSplit = (0, _split_cards.useAnimateSplit)();
  return /*#__PURE__*/_react.default.createElement(_split_cards.SplitCards, {
    fieldValues: fieldValues,
    splitField: splitField,
    numberOfDetectors: fieldValues.length,
    jobType: _new_job.JOB_TYPE.GEO,
    animate: animateSplit
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGrid, {
    columns: 1
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    "data-test-subj": 'mlGeoMap',
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, geoAgg && geoField ? /*#__PURE__*/_react.default.createElement(_detector_title.DetectorTitle, {
    index: 0,
    agg: geoAgg,
    field: geoField
  }) : null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }), /*#__PURE__*/_react.default.createElement("span", {
    "data-test-subj": "mlGeoJobWizardMap",
    style: {
      width: '100%',
      height: 400
    }
  }, /*#__PURE__*/_react.default.createElement(_ml_embedded_map.MlEmbeddedMapComponent, {
    layerList: layerList
  }))))));
};
exports.GeoMapExamples = GeoMapExamples;