"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.GeoFieldSelect = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _use_field_stats_trigger = require("../../../../../../../components/field_stats_flyout/use_field_stats_trigger");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const GeoFieldSelect = ({
  fields,
  changeHandler,
  selectedField
}) => {
  const {
    renderOption,
    optionCss
  } = (0, _use_field_stats_trigger.useFieldStatsTrigger)();
  const options = (0, _react.useMemo)(() => fields.map(f => ({
    label: f.name,
    field: f,
    css: optionCss
  })), [fields, optionCss]);
  const selection = (0, _react.useMemo)(() => {
    const selectedOptions = [];
    if (selectedField !== null) {
      selectedOptions.push({
        label: selectedField.name,
        field: selectedField
      });
    }
    return selectedOptions;
  }, [selectedField]);
  const onChange = (0, _react.useCallback)(selectedOptions => {
    const option = selectedOptions[0];
    if (typeof option !== 'undefined') {
      changeHandler(option.field);
    } else {
      changeHandler(null);
    }
  }, [changeHandler]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiComboBox, {
    singleSelection: {
      asPlainText: true
    },
    options: options,
    selectedOptions: selection,
    onChange: onChange,
    isClearable: true,
    "data-test-subj": "mlGeoFieldNameSelect",
    renderOption: renderOption
  });
};
exports.GeoFieldSelect = GeoFieldSelect;