"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.CategorizationDetectors = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _mlCategoryValidator = require("@kbn/ml-category-validator");
var _toast_notification_service = require("../../../../../../../services/toast_notification_service");
var _job_creator_context = require("../../../job_creator_context");
var _categorization_field = require("../categorization_field");
var _categorization_detector = require("../categorization_detector");
var _categorization_partition_field = require("../categorization_partition_field");
var _field_examples = require("./field_examples");
var _examples_valid_callout = require("./examples_valid_callout");
var _invalid_ccs_version_valid_callout = require("./invalid_ccs_version_valid_callout");
var _loading_wrapper = require("../../../charts/loading_wrapper");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const CategorizationDetectors = ({
  setIsValid
}) => {
  const {
    jobCreator: jc,
    jobCreatorUpdate,
    jobCreatorUpdated
  } = (0, _react.useContext)(_job_creator_context.JobCreatorContext);
  const jobCreator = jc;
  const [loadingData, setLoadingData] = (0, _react.useState)(false);
  const [ccsVersionFailure, setCcsVersionFailure] = (0, _react.useState)(false);
  const [start, setStart] = (0, _react.useState)(jobCreator.start);
  const [end, setEnd] = (0, _react.useState)(jobCreator.end);
  const [categorizationAnalyzerString, setCategorizationAnalyzerString] = (0, _react.useState)(JSON.stringify(jobCreator.categorizationAnalyzer));
  const [fieldExamples, setFieldExamples] = (0, _react.useState)(null);
  const [overallValidStatus, setOverallValidStatus] = (0, _react.useState)(_mlCategoryValidator.CATEGORY_EXAMPLES_VALIDATION_STATUS.INVALID);
  const [validationChecks, setValidationChecks] = (0, _react.useState)([]);
  const [categorizationFieldName, setCategorizationFieldName] = (0, _react.useState)(jobCreator.categorizationFieldName);
  (0, _react.useEffect)(() => {
    if (jobCreator.categorizationFieldName !== categorizationFieldName) {
      jobCreator.categorizationFieldName = categorizationFieldName;
      jobCreatorUpdate();
    }
    loadFieldExamples();
    // eslint-disable-next-line react-hooks/exhaustive-deps
  }, [categorizationFieldName]);
  (0, _react.useEffect)(() => {
    let updateExamples = false;
    if (jobCreator.start !== start || jobCreator.end !== end) {
      setStart(jobCreator.start);
      setEnd(jobCreator.end);
      updateExamples = true;
    }
    const tempCategorizationAnalyzerString = JSON.stringify(jobCreator.categorizationAnalyzer);
    if (tempCategorizationAnalyzerString !== categorizationAnalyzerString) {
      setCategorizationAnalyzerString(tempCategorizationAnalyzerString);
      updateExamples = true;
    }
    if (updateExamples) {
      loadFieldExamples();
    }
    if (jobCreator.categorizationFieldName !== categorizationFieldName) {
      setCategorizationFieldName(jobCreator.categorizationFieldName);
    }
    // eslint-disable-next-line react-hooks/exhaustive-deps
  }, [jobCreatorUpdated]);
  async function loadFieldExamples() {
    if (categorizationFieldName !== null) {
      setLoadingData(true);
      try {
        const {
          examples,
          overallValidStatus: tempOverallValidStatus,
          validationChecks: tempValidationChecks,
          ccsVersionFailure: tempCcsVersionFailure
        } = await jobCreator.loadCategorizationFieldExamples();
        setFieldExamples(examples);
        setOverallValidStatus(tempOverallValidStatus);
        setValidationChecks(tempValidationChecks);
        setCcsVersionFailure(tempCcsVersionFailure);
        setLoadingData(false);
      } catch (error) {
        setLoadingData(false);
        setFieldExamples(null);
        setValidationChecks([]);
        setOverallValidStatus(_mlCategoryValidator.CATEGORY_EXAMPLES_VALIDATION_STATUS.INVALID);
        (0, _toast_notification_service.getToastNotificationService)().displayErrorToast(error);
        setCcsVersionFailure(false);
      }
    } else {
      setFieldExamples(null);
      setValidationChecks([]);
      setOverallValidStatus(_mlCategoryValidator.CATEGORY_EXAMPLES_VALIDATION_STATUS.INVALID);
      setCcsVersionFailure(false);
    }
    setIsValid(categorizationFieldName !== null);
  }
  (0, _react.useEffect)(() => {
    jobCreatorUpdate();
    // eslint-disable-next-line react-hooks/exhaustive-deps
  }, [overallValidStatus]);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_categorization_detector.CategorizationDetector, null), /*#__PURE__*/_react.default.createElement(_eui.EuiHorizontalRule, null), /*#__PURE__*/_react.default.createElement(_categorization_field.CategorizationField, null), loadingData === true && /*#__PURE__*/_react.default.createElement(_loading_wrapper.LoadingWrapper, {
    hasData: false,
    loading: true
  }, /*#__PURE__*/_react.default.createElement("div", null)), ccsVersionFailure === false && fieldExamples !== null && loadingData === false && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_examples_valid_callout.ExamplesValidCallout, {
    overallValidStatus: overallValidStatus,
    validationChecks: validationChecks,
    categorizationAnalyzer: jobCreator.categorizationAnalyzer
  }), /*#__PURE__*/_react.default.createElement(_field_examples.FieldExamples, {
    fieldExamples: fieldExamples
  })), ccsVersionFailure === true && /*#__PURE__*/_react.default.createElement(_invalid_ccs_version_valid_callout.InvalidCssVersionCallout, null), /*#__PURE__*/_react.default.createElement(_eui.EuiHorizontalRule, null), /*#__PURE__*/_react.default.createElement(_categorization_partition_field.CategorizationPerPartitionField, null));
};
exports.CategorizationDetectors = CategorizationDetectors;