"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ESTIMATE_STATUS = void 0;
exports.useEstimateBucketSpan = useEstimateBucketSpan;
var _react = require("react");
var _i18n = require("@kbn/i18n");
var _mlAnomalyUtils = require("@kbn/ml-anomaly-utils");
var _job_creator_context = require("../../../job_creator_context");
var _job_creator = require("../../../../../common/job_creator");
var _ml_api_service = require("../../../../../../../services/ml_api_service");
var _ml = require("../../../../../../../contexts/ml");
var _toast_notification_service = require("../../../../../../../services/toast_notification_service");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
let ESTIMATE_STATUS = exports.ESTIMATE_STATUS = /*#__PURE__*/function (ESTIMATE_STATUS) {
  ESTIMATE_STATUS[ESTIMATE_STATUS["NOT_RUNNING"] = 0] = "NOT_RUNNING";
  ESTIMATE_STATUS[ESTIMATE_STATUS["RUNNING"] = 1] = "RUNNING";
  return ESTIMATE_STATUS;
}({});
function useEstimateBucketSpan() {
  var _jobCreator$runtimeMa;
  const {
    jobCreator,
    jobCreatorUpdate
  } = (0, _react.useContext)(_job_creator_context.JobCreatorContext);
  const dataSourceContext = (0, _ml.useDataSource)();
  const [status, setStatus] = (0, _react.useState)(ESTIMATE_STATUS.NOT_RUNNING);
  const data = {
    aggTypes: jobCreator.aggregations.map(a => a.dslName),
    duration: {
      start: jobCreator.start,
      end: jobCreator.end
    },
    fields: jobCreator.fields.map(f => f.id === _mlAnomalyUtils.EVENT_RATE_FIELD_ID ? null : f.id),
    index: dataSourceContext.selectedDataView.title,
    query: dataSourceContext.combinedQuery,
    splitField: undefined,
    timeField: dataSourceContext.selectedDataView.timeFieldName,
    runtimeMappings: (_jobCreator$runtimeMa = jobCreator.runtimeMappings) !== null && _jobCreator$runtimeMa !== void 0 ? _jobCreator$runtimeMa : undefined,
    indicesOptions: jobCreator.datafeedConfig.indices_options
  };
  if ((0, _job_creator.isMultiMetricJobCreator)(jobCreator) && jobCreator.splitField !== null) {
    data.splitField = jobCreator.splitField.id;
  } else if ((0, _job_creator.isPopulationJobCreator)(jobCreator) && jobCreator.populationField !== null) {
    data.splitField = jobCreator.populationField.id;
  } else if ((0, _job_creator.isRareJobCreator)(jobCreator)) {
    data.fields = [null];
    if (jobCreator.populationField) {
      data.splitField = jobCreator.populationField.id;
    } else {
      var _jobCreator$rareField;
      data.splitField = (_jobCreator$rareField = jobCreator.rareField) === null || _jobCreator$rareField === void 0 ? void 0 : _jobCreator$rareField.id;
    }
  } else if ((0, _job_creator.isAdvancedJobCreator)(jobCreator)) {
    jobCreator.richDetectors.some(d => {
      if (d.partitionField !== null) {
        data.splitField = d.partitionField.id;
        return true;
      }
      if (d.overField !== null) {
        data.splitField = d.overField.id;
        return true;
      }
      if (d.byField !== null) {
        data.splitField = d.byField.id;
        return true;
      }
    });
  }
  async function estimateBucketSpan() {
    setStatus(ESTIMATE_STATUS.RUNNING);
    const {
      name,
      error,
      message: text
    } = await _ml_api_service.ml.estimateBucketSpan(data);
    setStatus(ESTIMATE_STATUS.NOT_RUNNING);
    if (error === true) {
      const title = _i18n.i18n.translate('xpack.ml.newJob.wizard.pickFieldsStep.bucketSpanEstimator.errorTitle', {
        defaultMessage: 'Bucket span could not be estimated'
      });
      (0, _toast_notification_service.getToastNotificationService)().displayWarningToast({
        title,
        text
      });
    } else {
      jobCreator.bucketSpan = name;
      jobCreatorUpdate();
    }
  }
  return {
    status,
    estimateBucketSpan
  };
}