"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AggSelect = void 0;
exports.createLabel = createLabel;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _mlAnomalyUtils = require("@kbn/ml-anomaly-utils");
var _field_stats_info_button = require("../../../../../../../components/field_stats_flyout/field_stats_info_button");
var _job_creator_context = require("../../../job_creator_context");
var _use_field_stats_trigger = require("../../../../../../../components/field_stats_flyout/use_field_stats_trigger");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

// The display label used for an aggregation e.g. sum(bytes).

// Label object structured for EUI's ComboBox.

// Label object structure for EUI's ComboBox with support for nesting.

const AggSelect = ({
  fields,
  changeHandler,
  selectedOptions,
  removeOptions
}) => {
  const {
    jobValidator,
    jobValidatorUpdated
  } = (0, _react.useContext)(_job_creator_context.JobCreatorContext);
  const [validation, setValidation] = (0, _react.useState)(jobValidator.duplicateDetectors);
  // create list of labels based on already selected detectors
  // so they can be removed from the dropdown list
  const removeLabels = removeOptions.map(createLabel);
  const {
    handleFieldStatsButtonClick,
    populatedFields
  } = (0, _use_field_stats_trigger.useFieldStatsTrigger)();
  const options = (0, _react.useMemo)(() => fields.map(f => {
    const aggOption = {
      isGroupLabelOption: true,
      key: f.name,
      // @ts-ignore Purposefully passing label as element instead of string
      // for more robust rendering
      label: /*#__PURE__*/_react.default.createElement(_field_stats_info_button.FieldStatsInfoButton, {
        hideTrigger: f.id === _mlAnomalyUtils.EVENT_RATE_FIELD_ID,
        isEmpty: f.id === _mlAnomalyUtils.EVENT_RATE_FIELD_ID ? false : !(populatedFields !== null && populatedFields !== void 0 && populatedFields.has(f.name)),
        field: f,
        label: f.name,
        onButtonClick: handleFieldStatsButtonClick
      }),
      options: []
    };
    if (typeof f.aggs !== 'undefined') {
      aggOption.options = f.aggs.filter(a => a.dslName !== null) // don't include aggs which have no ES equivalent
      .map(a => ({
        label: `${a.title}(${f.name})`,
        agg: a,
        field: f
      })).filter(o => removeLabels.includes(o.label) === false);
    }
    return aggOption;
  }),
  // eslint-disable-next-line react-hooks/exhaustive-deps
  [handleFieldStatsButtonClick, fields, removeLabels, populatedFields === null || populatedFields === void 0 ? void 0 : populatedFields.size]);
  (0, _react.useEffect)(() => {
    setValidation(jobValidator.duplicateDetectors);
    // eslint-disable-next-line react-hooks/exhaustive-deps
  }, [jobValidatorUpdated]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    error: validation.message,
    isInvalid: validation.valid === false,
    "data-test-subj": "mlJobWizardAggSelection"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiComboBox, {
    singleSelection: {
      asPlainText: true
    },
    options: options,
    selectedOptions: selectedOptions,
    onChange: changeHandler,
    isClearable: false,
    isInvalid: validation.valid === false
  }));
};
exports.AggSelect = AggSelect;
function createLabel(pair) {
  return `${pair.agg.title}(${pair.field.name})`;
}