"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Page = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _mlUrlState = require("@kbn/ml-url-state");
var _node_available_warning = require("../../../components/node_available_warning");
var _saved_objects_warning = require("../../../components/saved_objects_warning");
var _upgrade = require("../../../components/upgrade");
var _ = require(".");
var _help_menu = require("../../../components/help_menu");
var _kibana = require("../../../contexts/kibana");
var _common = require("../../common");
var _page_header = require("../../../components/page_header");
var _analytics_selector = require("../components/analytics_selector");
var _empty_prompt = require("../analytics_management/components/empty_prompt");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const Page = () => {
  var _globalState$ml, _globalState$ml2;
  const [globalState, setGlobalState] = (0, _mlUrlState.useUrlState)('_g');
  const jobId = globalState === null || globalState === void 0 ? void 0 : (_globalState$ml = globalState.ml) === null || _globalState$ml === void 0 ? void 0 : _globalState$ml.jobId;
  const modelId = globalState === null || globalState === void 0 ? void 0 : (_globalState$ml2 = globalState.ml) === null || _globalState$ml2 === void 0 ? void 0 : _globalState$ml2.modelId;
  const [isLoading, setIsLoading] = (0, _react.useState)(false);
  const [isIdSelectorFlyoutVisible, setIsIdSelectorFlyoutVisible] = (0, _react.useState)(!jobId && !modelId);
  const [jobsExist, setJobsExist] = (0, _react.useState)(true);
  const {
    refresh
  } = (0, _common.useRefreshAnalyticsList)({
    isLoading: setIsLoading
  });
  const setAnalyticsId = (0, _react.useCallback)(analyticsId => {
    setGlobalState({
      ml: {
        ...(analyticsId.job_id && !analyticsId.model_id ? {
          jobId: analyticsId.job_id
        } : {}),
        ...(analyticsId.model_id ? {
          modelId: analyticsId.model_id
        } : {})
      }
    });
  }, [setGlobalState]);
  const {
    services: {
      docLinks
    }
  } = (0, _kibana.useMlKibana)();
  const {
    dataFrameAnalytics: {
      getDataFrameAnalytics
    }
  } = (0, _kibana.useMlApiContext)();
  const helpLink = docLinks.links.ml.dataFrameAnalytics;
  const checkJobsExist = async () => {
    try {
      const {
        count
      } = await getDataFrameAnalytics(undefined, undefined, 0);
      setJobsExist(count > 0);
    } catch (e) {
      // Swallow the error and just show the empty table in the analytics id selector
      console.error('Error checking analytics jobs exist', e); // eslint-disable-line no-console
    }
  };
  (0, _react.useEffect)(function checkJobs() {
    checkJobsExist();
    // eslint-disable-next-line react-hooks/exhaustive-deps
  }, []);
  const getEmptyState = () => {
    if (jobsExist === false) {
      return /*#__PURE__*/_react.default.createElement(_empty_prompt.AnalyticsEmptyPrompt, null);
    }
    return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiEmptyPrompt, {
      iconType: "warning",
      title: /*#__PURE__*/_react.default.createElement("h2", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.ml.dataframe.analyticsMap.noJobSelectedLabel",
        defaultMessage: "No Analytics ID selected"
      })),
      "data-test-subj": "mlNoAnalyticsFound"
    }));
  };
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_analytics_selector.AnalyticsIdSelectorControls, {
    setIsIdSelectorFlyoutVisible: setIsIdSelectorFlyoutVisible,
    selectedId: jobId !== null && jobId !== void 0 ? jobId : modelId
  }), isIdSelectorFlyoutVisible ? /*#__PURE__*/_react.default.createElement(_analytics_selector.AnalyticsIdSelector, {
    setAnalyticsId: setAnalyticsId,
    setIsIdSelectorFlyoutVisible: setIsIdSelectorFlyoutVisible
  }) : null, jobId === undefined && modelId === undefined ? /*#__PURE__*/_react.default.createElement(_page_header.MlPageHeader, null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    "data-test-subj": "mlPageDataFrameAnalyticsMapTitle",
    id: "xpack.ml.dataframe.analyticsMap.title",
    defaultMessage: "Map for Analytics"
  })) : null, jobId !== undefined && modelId === undefined ? /*#__PURE__*/_react.default.createElement(_page_header.MlPageHeader, null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    "data-test-subj": "mlPageDataFrameAnalyticsMapTitle",
    id: "xpack.ml.dataframe.analyticsMap.analyticsIdTitle",
    defaultMessage: "Map for job ID {jobId}",
    values: {
      jobId
    }
  })) : null, modelId !== undefined && jobId === undefined ? /*#__PURE__*/_react.default.createElement(_page_header.MlPageHeader, null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    "data-test-subj": "mlPageDataFrameAnalyticsMapTitle",
    id: "xpack.ml.dataframe.analyticsMap.modelIdTitle",
    defaultMessage: "Map for trained model ID {modelId}",
    values: {
      modelId
    }
  })) : null, /*#__PURE__*/_react.default.createElement(_node_available_warning.NodeAvailableWarning, null), /*#__PURE__*/_react.default.createElement(_saved_objects_warning.SavedObjectsWarning, {
    onCloseFlyout: refresh
  }), /*#__PURE__*/_react.default.createElement(_upgrade.UpgradeWarning, null), jobId || modelId ? /*#__PURE__*/_react.default.createElement(_.JobMap, {
    key: `${jobId !== null && jobId !== void 0 ? jobId : modelId}-id`,
    analyticsId: jobId,
    modelId: modelId,
    forceRefresh: isLoading
  }) : getEmptyState(), /*#__PURE__*/_react.default.createElement(_help_menu.HelpMenu, {
    docLink: helpLink
  }));
};
exports.Page = Page;