"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.StopActionModal = void 0;
var _react = _interopRequireDefault(require("react"));
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _eui = require("@elastic/eui");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const StopActionModal = ({
  closeModal,
  item,
  forceStopAndCloseModal
}) => {
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, item !== undefined && /*#__PURE__*/_react.default.createElement(_eui.EuiConfirmModal, {
    title: _i18n.i18n.translate('xpack.ml.dataframe.analyticsList.forceStopModalTitle', {
      defaultMessage: 'Force this job to stop?'
    }),
    onCancel: closeModal,
    onConfirm: forceStopAndCloseModal,
    cancelButtonText: _i18n.i18n.translate('xpack.ml.dataframe.analyticsList.forceStopModalCancelButton', {
      defaultMessage: 'Cancel'
    }),
    confirmButtonText: _i18n.i18n.translate('xpack.ml.dataframe.analyticsList.forceStopModalStartButton', {
      defaultMessage: 'Stop'
    }),
    defaultFocusedButton: _eui.EUI_MODAL_CONFIRM_BUTTON,
    buttonColor: "primary"
  }, /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.ml.dataframe.analyticsList.forceStopModalBody",
    defaultMessage: "{analyticsId} is in a failed state. You must stop the job and fix the failure.",
    values: {
      analyticsId: item.config.id
    }
  }))));
};
exports.StopActionModal = StopActionModal;