"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EnabledFeaturesContextProvider = exports.EnabledFeaturesContext = void 0;
exports.useEnabledFeatures = useEnabledFeatures;
var _react = _interopRequireWildcard(require("react"));
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const EnabledFeaturesContext = exports.EnabledFeaturesContext = /*#__PURE__*/(0, _react.createContext)({
  showNodeInfo: true,
  showMLNavMenu: true,
  showLicenseInfo: true,
  isADEnabled: true,
  isDFAEnabled: true,
  isNLPEnabled: true
});
const EnabledFeaturesContextProvider = ({
  children,
  isServerless,
  showMLNavMenu = true,
  mlFeatures,
  experimentalFeatures
}) => {
  var _experimentalFeatures;
  const features = {
    showNodeInfo: !isServerless,
    showMLNavMenu,
    showLicenseInfo: !isServerless,
    isADEnabled: mlFeatures.ad,
    isDFAEnabled: mlFeatures.dfa,
    isNLPEnabled: mlFeatures.nlp,
    showRuleFormV2: (_experimentalFeatures = experimentalFeatures === null || experimentalFeatures === void 0 ? void 0 : experimentalFeatures.ruleFormV2) !== null && _experimentalFeatures !== void 0 ? _experimentalFeatures : false
  };
  return /*#__PURE__*/_react.default.createElement(EnabledFeaturesContext.Provider, {
    value: features
  }, children);
};
exports.EnabledFeaturesContextProvider = EnabledFeaturesContextProvider;
function useEnabledFeatures() {
  const context = (0, _react.useContext)(EnabledFeaturesContext);
  return (0, _react.useMemo)(() => {
    return context;
  }, [context]);
}