"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.CustomSelectionTable = CustomSelectionTable;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _propTypes = require("prop-types");
var _services = require("@elastic/eui/lib/services");
var _i18n = require("@kbn/i18n");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ITEMS_PER_PAGE = 20;
function getError(error) {
  if (error !== null) {
    return _i18n.i18n.translate('xpack.ml.jobSelector.filterBar.invalidSearchErrorMessage', {
      defaultMessage: `Invalid search: {errorMessage}`,
      values: {
        errorMessage: error.message
      }
    });
  }
  return '';
}
function CustomSelectionTable({
  checkboxDisabledCheck,
  columns,
  currentPage = 0,
  filterDefaultFields,
  filters,
  items,
  itemsPerPage = ITEMS_PER_PAGE,
  onTableChange,
  radioDisabledCheck,
  selectedIds,
  setCurrentPaginationData,
  singleSelection,
  sortableProperties,
  tableItemId = 'id'
}) {
  const [itemIdToSelectedMap, setItemIdToSelectedMap] = (0, _react.useState)(getCurrentlySelectedItemIdsMap());
  const [currentItems, setCurrentItems] = (0, _react.useState)(items);
  const [lastSelected, setLastSelected] = (0, _react.useState)(selectedIds);
  const [sortedColumn, setSortedColumn] = (0, _react.useState)('');
  const [pager, setPager] = (0, _react.useState)();
  const [pagerSettings, setPagerSettings] = (0, _react.useState)({
    itemsPerPage: itemsPerPage,
    firstItemIndex: 0,
    lastItemIndex: 1
  });
  const [query, setQuery] = (0, _react.useState)(_eui.EuiSearchBar.Query.MATCH_ALL);
  const [error, setError] = (0, _react.useState)(null);
  (0, _react.useEffect)(() => {
    setCurrentItems(items);
    handleQueryChange({
      query: query
    });
    // eslint-disable-next-line react-hooks/exhaustive-deps
  }, [items]);

  // When changes to selected ids made via badge removal - update selection in the table accordingly
  (0, _react.useEffect)(() => {
    setItemIdToSelectedMap(getCurrentlySelectedItemIdsMap());
    // eslint-disable-next-line react-hooks/exhaustive-deps
  }, [selectedIds]);
  (0, _react.useEffect)(() => {
    const tablePager = new _services.Pager(currentItems.length, itemsPerPage, currentPage);
    setPagerSettings({
      itemsPerPage: itemsPerPage,
      firstItemIndex: tablePager.getFirstItemIndex(),
      lastItemIndex: tablePager.getLastItemIndex()
    });
    setPager(tablePager);
    // eslint-disable-next-line react-hooks/exhaustive-deps
  }, [currentItems]);
  function getCurrentlySelectedItemIdsMap() {
    const selectedIdsMap = {
      all: false
    };
    selectedIds.forEach(id => {
      selectedIdsMap[id] = true;
    });
    return selectedIdsMap;
  }
  function handleSingleSelectionTableChange(itemId) {
    onTableChange([itemId]);
  }
  function handleTableChange({
    isSelected,
    itemId
  }) {
    const selectedMapIds = Object.getOwnPropertyNames(itemIdToSelectedMap);
    const currentItemIds = currentItems.map(item => item[tableItemId]);
    let currentSelected = selectedMapIds.filter(id => itemIdToSelectedMap[id] === true && id !== itemId);
    if (itemId !== 'all') {
      if (isSelected === true) {
        currentSelected.push(itemId);
      }
    } else {
      if (isSelected === false) {
        // don't include any current items in the selection update since we're deselecting 'all'
        currentSelected = currentSelected.filter(id => currentItemIds.includes(id) === false);
      } else {
        // grab all id's
        currentSelected = [...currentSelected, ...currentItemIds];
        currentSelected = [...new Set(currentSelected)];
      }
    }
    if (setCurrentPaginationData) {
      setCurrentPaginationData({
        pageIndex: pager.getCurrentPageIndex(),
        itemsPerPage: pagerSettings.itemsPerPage
      });
    }
    onTableChange(currentSelected);
  }
  function handleChangeItemsPerPage(numItemsPerPage) {
    pager.setItemsPerPage(numItemsPerPage);
    setPagerSettings({
      ...pagerSettings,
      itemsPerPage: numItemsPerPage,
      firstItemIndex: pager.getFirstItemIndex(),
      lastItemIndex: pager.getLastItemIndex()
    });
  }
  function handlePageChange(pageIndex) {
    pager.goToPageIndex(pageIndex);
    setPagerSettings({
      ...pagerSettings,
      firstItemIndex: pager.getFirstItemIndex(),
      lastItemIndex: pager.getLastItemIndex()
    });
  }
  function handleQueryChange({
    query: incomingQuery,
    error: newError
  }) {
    if (newError) {
      setError(newError);
    } else {
      const queriedItems = _eui.EuiSearchBar.Query.execute(incomingQuery, items, {
        defaultFields: filterDefaultFields
      });
      setError(null);
      setCurrentItems(queriedItems);
      setQuery(incomingQuery);
    }
  }
  function isItemSelected(itemId) {
    return itemIdToSelectedMap[itemId] === true;
  }
  function areAllItemsSelected() {
    const indexOfUnselectedItem = currentItems.findIndex(item => !isItemSelected(item[tableItemId]));
    return indexOfUnselectedItem === -1;
  }
  const selectAllCheckboxId = (0, _react.useMemo)(() => (0, _eui.htmlIdGenerator)()(), []);
  function renderSelectAll(mobile) {
    const selectAll = _i18n.i18n.translate('xpack.ml.jobSelector.customTable.selectAllCheckboxLabel', {
      defaultMessage: 'Select all'
    });
    return /*#__PURE__*/_react.default.createElement(_eui.EuiCheckbox, {
      id: `${mobile ? `mobile-` : ''}${selectAllCheckboxId}`,
      label: mobile ? selectAll : null,
      checked: areAllItemsSelected(),
      onChange: toggleAll,
      type: mobile ? null : 'inList'
    });
  }
  function toggleItem(itemId) {
    // If enforcing singleSelection select incoming and deselect the last selected
    if (singleSelection) {
      const lastId = lastSelected[0];
      // deselect last selected and select incoming id
      setItemIdToSelectedMap({
        ...itemIdToSelectedMap,
        [lastId]: false,
        [itemId]: true
      });
      handleSingleSelectionTableChange(itemId);
      setLastSelected([itemId]);
    } else {
      const isSelected = !isItemSelected(itemId);
      setItemIdToSelectedMap({
        ...itemIdToSelectedMap,
        [itemId]: isSelected
      });
      handleTableChange({
        isSelected,
        itemId
      });
    }
  }
  function toggleAll() {
    const allSelected = areAllItemsSelected() || itemIdToSelectedMap.all === true;
    const newItemIdToSelectedMap = {};
    currentItems.forEach(item => newItemIdToSelectedMap[item[tableItemId]] = !allSelected);
    setItemIdToSelectedMap(newItemIdToSelectedMap);
    handleTableChange({
      isSelected: !allSelected,
      itemId: 'all'
    });
  }
  function onSort(prop) {
    sortableProperties.sortOn(prop);
    const sortedItems = sortableProperties.sortItems(currentItems);
    setCurrentItems(sortedItems);
    setSortedColumn(prop);
  }
  function renderHeaderCells() {
    const headers = [];
    columns.forEach((column, columnIndex) => {
      if (column.isCheckbox && !singleSelection) {
        headers.push( /*#__PURE__*/_react.default.createElement(_eui.EuiTableHeaderCellCheckbox, {
          key: column.id,
          width: column.width
        }, renderSelectAll()));
      } else {
        headers.push( /*#__PURE__*/_react.default.createElement(_eui.EuiTableHeaderCell, {
          key: column.id,
          align: columns[columnIndex].alignment,
          width: column.width,
          onSort: column.isSortable ? () => onSort(column.id) : undefined,
          isSorted: sortedColumn === column.id,
          isSortAscending: sortableProperties ? sortableProperties.isAscendingByName(column.id) : true,
          mobileOptions: column.mobileOptions
        }, column.label));
      }
    });
    return headers.length ? headers : null;
  }
  function renderRows() {
    const renderRow = item => {
      const cells = columns.map(column => {
        const cell = item[column.id];
        let child;
        if (column.isCheckbox) {
          return /*#__PURE__*/_react.default.createElement(_eui.EuiTableRowCellCheckbox, {
            key: column.id
          }, !singleSelection && /*#__PURE__*/_react.default.createElement(_eui.EuiCheckbox, {
            disabled: checkboxDisabledCheck !== undefined ? checkboxDisabledCheck(item) : undefined,
            id: `${item[tableItemId]}-checkbox`,
            "data-test-subj": `${item[tableItemId]}-checkbox`,
            checked: isItemSelected(item[tableItemId]),
            onChange: () => toggleItem(item[tableItemId]),
            type: "inList"
          }), singleSelection && /*#__PURE__*/_react.default.createElement(_eui.EuiRadio, {
            id: item[tableItemId],
            "data-test-subj": `${item[tableItemId]}-radio-button`,
            checked: isItemSelected(item[tableItemId]),
            onChange: () => toggleItem(item[tableItemId]),
            disabled: radioDisabledCheck !== undefined ? radioDisabledCheck(item) : undefined
          }));
        }
        if (column.render) {
          child = column.render(item);
        } else {
          child = cell;
        }
        return /*#__PURE__*/_react.default.createElement(_eui.EuiTableRowCell, {
          key: column.id,
          align: column.alignment,
          truncateText: cell && cell.truncateText,
          textOnly: cell ? cell.textOnly : true,
          mobileOptions: {
            header: column.label,
            ...column.mobileOptions
          }
        }, child);
      });
      return /*#__PURE__*/_react.default.createElement(_eui.EuiTableRow, {
        key: item[tableItemId],
        isSelected: isItemSelected(item[tableItemId]),
        isSelectable: true,
        hasActions: true,
        "data-test-subj": `mlCustomSelectionTableRow row-${item[tableItemId]}`
      }, cells);
    };
    const rows = [];
    for (let itemIndex = pagerSettings.firstItemIndex; itemIndex <= pagerSettings.lastItemIndex; itemIndex++) {
      const item = currentItems[itemIndex];
      if (item === undefined) {
        break;
      }
      rows.push(renderRow(item));
    }
    return rows;
  }
  return /*#__PURE__*/_react.default.createElement(_react.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    "data-test-subj": "mlCustomSelectionTableSearchBar"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSearchBar, {
    defaultQuery: query,
    box: {
      incremental: true,
      placeholder: _i18n.i18n.translate('xpack.ml.jobSelector.customTable.searchBarPlaceholder', {
        defaultMessage: 'Search...'
      })
    },
    filters: filters,
    onChange: handleQueryChange
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    fullWidth: true,
    isInvalid: error !== null,
    error: getError(error),
    style: {
      maxHeight: '0px'
    }
  }, /*#__PURE__*/_react.default.createElement(_react.Fragment, null)))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiTableHeaderMobile, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    responsive: false,
    justifyContent: "spaceBetween",
    alignItems: "baseline"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, renderSelectAll(true)))), /*#__PURE__*/_react.default.createElement(_eui.EuiTable, {
    "data-test-subj": "mlCustomSelectionTable"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTableHeader, null, renderHeaderCells()), /*#__PURE__*/_react.default.createElement(_eui.EuiTableBody, null, renderRows())), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), pager !== undefined && /*#__PURE__*/_react.default.createElement(_eui.EuiTablePagination, {
    activePage: pager.getCurrentPageIndex(),
    itemsPerPage: pagerSettings.itemsPerPage,
    itemsPerPageOptions: [5, 10, 20, 50],
    pageCount: pager.getTotalPages(),
    onChangeItemsPerPage: handleChangeItemsPerPage,
    onChangePage: pageIndex => handlePageChange(pageIndex)
  }));
}
CustomSelectionTable.propTypes = {
  checkboxDisabledCheck: _propTypes.PropTypes.func,
  columns: _propTypes.PropTypes.array.isRequired,
  currentPage: _propTypes.PropTypes.number,
  filterDefaultFields: _propTypes.PropTypes.array,
  filters: _propTypes.PropTypes.array,
  items: _propTypes.PropTypes.array.isRequired,
  itemsPerPage: _propTypes.PropTypes.number,
  onTableChange: _propTypes.PropTypes.func.isRequired,
  radioDisabledCheck: _propTypes.PropTypes.func,
  selectedId: _propTypes.PropTypes.array,
  setCurrentPaginationData: _propTypes.PropTypes.func,
  singleSelection: _propTypes.PropTypes.bool,
  sortableProperties: _propTypes.PropTypes.object,
  tableItemId: _propTypes.PropTypes.string
};