"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.registerJobsHealthAlertingRule = registerJobsHealthAlertingRule;
var _react = require("react");
var _i18n = require("@kbn/i18n");
var _alerts = require("../../../common/constants/alerts");
var _alerts2 = require("../../../common/util/alerts");
var _validators = require("../validators");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; } /*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function registerJobsHealthAlertingRule(triggersActionsUi, alerting) {
  triggersActionsUi.ruleTypeRegistry.register({
    id: _alerts.ML_ALERT_TYPES.AD_JOBS_HEALTH,
    description: _i18n.i18n.translate('xpack.ml.alertTypes.jobsHealthAlertingRule.description', {
      defaultMessage: 'Alert when anomaly detection jobs experience operational issues. Enable suitable alerts for critically important jobs.'
    }),
    iconClass: 'bell',
    documentationUrl(docLinks) {
      return docLinks.links.ml.alertingRules;
    },
    ruleParamsExpression: /*#__PURE__*/(0, _react.lazy)(() => Promise.resolve().then(() => _interopRequireWildcard(require('./anomaly_detection_jobs_health_rule_trigger')))),
    validate: alertParams => {
      var _alertParams$includeJ, _alertParams$includeJ2, _alertParams$includeJ3, _alertParams$includeJ4;
      const validationResult = {
        errors: {
          includeJobs: new Array(),
          testsConfig: new Array(),
          delayedData: new Array()
        }
      };
      if (!((_alertParams$includeJ = alertParams.includeJobs) !== null && _alertParams$includeJ !== void 0 && (_alertParams$includeJ2 = _alertParams$includeJ.jobIds) !== null && _alertParams$includeJ2 !== void 0 && _alertParams$includeJ2.length) && !((_alertParams$includeJ3 = alertParams.includeJobs) !== null && _alertParams$includeJ3 !== void 0 && (_alertParams$includeJ4 = _alertParams$includeJ3.groupIds) !== null && _alertParams$includeJ4 !== void 0 && _alertParams$includeJ4.length)) {
        validationResult.errors.includeJobs.push(_i18n.i18n.translate('xpack.ml.alertTypes.jobsHealthAlertingRule.includeJobs.errorMessage', {
          defaultMessage: 'Job selection is required'
        }));
      }
      const resultTestConfig = (0, _alerts2.getResultJobsHealthRuleConfig)(alertParams.testsConfig);
      if (Object.values(resultTestConfig).every(v => (v === null || v === void 0 ? void 0 : v.enabled) === false)) {
        validationResult.errors.testsConfig.push(_i18n.i18n.translate('xpack.ml.alertTypes.jobsHealthAlertingRule.testsConfig.errorMessage', {
          defaultMessage: 'At least one health check must be enabled.'
        }));
      }
      if (!!resultTestConfig.delayedData.timeInterval && (0, _validators.validateLookbackInterval)(resultTestConfig.delayedData.timeInterval)) {
        validationResult.errors.delayedData.push(_i18n.i18n.translate('xpack.ml.alertTypes.jobsHealthAlertingRule.testsConfig.delayedData.timeIntervalErrorMessage', {
          defaultMessage: 'Invalid time interval'
        }));
      }
      if (resultTestConfig.delayedData.docsCount === 0) {
        validationResult.errors.delayedData.push(_i18n.i18n.translate('xpack.ml.alertTypes.jobsHealthAlertingRule.testsConfig.delayedData.docsCountErrorMessage', {
          defaultMessage: 'Invalid number of documents'
        }));
      }
      return validationResult;
    },
    requiresAppContext: false,
    defaultActionMessage: _i18n.i18n.translate('xpack.ml.alertTypes.jobsHealthAlertingRule.defaultActionMessage', {
      defaultMessage: `[\\{\\{rule.name\\}\\}] Anomaly detection jobs health check result:
\\{\\{context.message\\}\\}
\\{\\{#context.results\\}\\}
  Job ID: \\{\\{job_id\\}\\}
  \\{\\{#datafeed_id\\}\\}Datafeed ID: \\{\\{datafeed_id\\}\\}
  \\{\\{/datafeed_id\\}\\}\\{\\{#datafeed_state\\}\\}Datafeed state: \\{\\{datafeed_state\\}\\}
  \\{\\{/datafeed_state\\}\\}\\{\\{#memory_status\\}\\}Memory status: \\{\\{memory_status\\}\\}
  \\{\\{/memory_status\\}\\}\\{\\{#model_bytes\\}\\}Model size: \\{\\{model_bytes\\}\\}
  \\{\\{/model_bytes\\}\\}\\{\\{#model_bytes_memory_limit\\}\\}Model memory limit: \\{\\{model_bytes_memory_limit\\}\\}
  \\{\\{/model_bytes_memory_limit\\}\\}\\{\\{#peak_model_bytes\\}\\}Peak model bytes: \\{\\{peak_model_bytes\\}\\}
  \\{\\{/peak_model_bytes\\}\\}\\{\\{#model_bytes_exceeded\\}\\}Model exceeded: \\{\\{model_bytes_exceeded\\}\\}
  \\{\\{/model_bytes_exceeded\\}\\}\\{\\{#log_time\\}\\}Memory logging time: \\{\\{log_time\\}\\}
  \\{\\{/log_time\\}\\}\\{\\{#failed_category_count\\}\\}Failed category count: \\{\\{failed_category_count\\}\\}
  \\{\\{/failed_category_count\\}\\}\\{\\{#annotation\\}\\}Annotation: \\{\\{annotation\\}\\}
  \\{\\{/annotation\\}\\}\\{\\{#missed_docs_count\\}\\}Number of missed documents: \\{\\{missed_docs_count\\}\\}
  \\{\\{/missed_docs_count\\}\\}\\{\\{#end_timestamp\\}\\}Latest finalized bucket with missing docs: \\{\\{end_timestamp\\}\\}
  \\{\\{/end_timestamp\\}\\}\\{\\{#errors\\}\\}Error message: \\{\\{message\\}\\} \\{\\{/errors\\}\\}
\\{\\{/context.results\\}\\}
`
    })
  });
}