"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SIGNIFICANCE_LEVELS = exports.CRITICAL_VALUES_TABLE = void 0;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * Table generated from following python code

import scipy.stats as stats
import numpy as np

# generate a chi-squared critical value table

# degrees of freedom
df = range(1,100)

# levels of significance
significance_levels = np.concatenate((np.logspace(-6, -3, 3), np.linspace(0.01, 0.99, 99)))

# create the table
table = []
for d in df:
    row = []
    for l in significance_levels:
        row.append(round(stats.chi2.ppf(1 - l, d), 2))
    table.append(row)

critical_value_table = np.array(table)

# print the critical value table as a TypeScipt array
print("export const CRITICAL_VALUES_TABLE = [")
for row in critical_value_table:
    print(f"  [{', '.join([str(x) for x in row])}],")
print("];")

# print the significance levels as a TypeScript array
print("export const SIGNIFICANCE_LEVELS = [")
print(f"  {', '.join([f'{x:.6f}' for x in significance_levels])}")
print("];")

 * until we find a low size replacement for doing chi2test in js
 */
const CRITICAL_VALUES_TABLE = exports.CRITICAL_VALUES_TABLE = [[23.93, 17.32, 10.83, 6.63, 5.41, 4.71, 4.22, 3.84, 3.54, 3.28, 3.06, 2.87, 2.71, 2.55, 2.42, 2.29, 2.18, 2.07, 1.97, 1.88, 1.8, 1.72, 1.64, 1.57, 1.5, 1.44, 1.38, 1.32, 1.27, 1.22, 1.17, 1.12, 1.07, 1.03, 0.99, 0.95, 0.91, 0.87, 0.84, 0.8, 0.77, 0.74, 0.71, 0.68, 0.65, 0.62, 0.6, 0.57, 0.55, 0.52, 0.5, 0.48, 0.45, 0.43, 0.41, 0.39, 0.38, 0.36, 0.34, 0.32, 0.31, 0.29, 0.27, 0.26, 0.25, 0.23, 0.22, 0.21, 0.19, 0.18, 0.17, 0.16, 0.15, 0.14, 0.13, 0.12, 0.11, 0.1, 0.09, 0.09, 0.08, 0.07, 0.06, 0.06, 0.05, 0.05, 0.04, 0.04, 0.03, 0.03, 0.02, 0.02, 0.02, 0.01, 0.01, 0.01, 0.01, 0.0, 0.0, 0.0, 0.0, 0.0], [27.63, 20.72, 13.82, 9.21, 7.82, 7.01, 6.44, 5.99, 5.63, 5.32, 5.05, 4.82, 4.61, 4.41, 4.24, 4.08, 3.93, 3.79, 3.67, 3.54, 3.43, 3.32, 3.22, 3.12, 3.03, 2.94, 2.85, 2.77, 2.69, 2.62, 2.55, 2.48, 2.41, 2.34, 2.28, 2.22, 2.16, 2.1, 2.04, 1.99, 1.94, 1.88, 1.83, 1.78, 1.74, 1.69, 1.64, 1.6, 1.55, 1.51, 1.47, 1.43, 1.39, 1.35, 1.31, 1.27, 1.23, 1.2, 1.16, 1.12, 1.09, 1.06, 1.02, 0.99, 0.96, 0.92, 0.89, 0.86, 0.83, 0.8, 0.77, 0.74, 0.71, 0.68, 0.66, 0.63, 0.6, 0.58, 0.55, 0.52, 0.5, 0.47, 0.45, 0.42, 0.4, 0.37, 0.35, 0.33, 0.3, 0.28, 0.26, 0.23, 0.21, 0.19, 0.17, 0.15, 0.12, 0.1, 0.08, 0.06, 0.04, 0.02], [30.66, 23.51, 16.27, 11.34, 9.84, 8.95, 8.31, 7.81, 7.41, 7.06, 6.76, 6.49, 6.25, 6.03, 5.83, 5.65, 5.48, 5.32, 5.17, 5.02, 4.89, 4.76, 4.64, 4.53, 4.41, 4.31, 4.21, 4.11, 4.01, 3.92, 3.83, 3.75, 3.66, 3.58, 3.51, 3.43, 3.36, 3.28, 3.21, 3.14, 3.08, 3.01, 2.95, 2.88, 2.82, 2.76, 2.7, 2.64, 2.59, 2.53, 2.47, 2.42, 2.37, 2.31, 2.26, 2.21, 2.16, 2.11, 2.06, 2.01, 1.96, 1.92, 1.87, 1.82, 1.78, 1.73, 1.69, 1.64, 1.6, 1.55, 1.51, 1.47, 1.42, 1.38, 1.34, 1.3, 1.25, 1.21, 1.17, 1.13, 1.09, 1.05, 1.01, 0.96, 0.92, 0.88, 0.84, 0.8, 0.76, 0.71, 0.67, 0.63, 0.58, 0.54, 0.49, 0.45, 0.4, 0.35, 0.3, 0.25, 0.18, 0.11], [33.38, 26.0, 18.47, 13.28, 11.67, 10.71, 10.03, 9.49, 9.04, 8.67, 8.34, 8.04, 7.78, 7.54, 7.32, 7.11, 6.92, 6.74, 6.58, 6.42, 6.27, 6.13, 5.99, 5.86, 5.73, 5.61, 5.5, 5.39, 5.28, 5.17, 5.07, 4.97, 4.88, 4.79, 4.7, 4.61, 4.52, 4.44, 4.36, 4.28, 4.2, 4.12, 4.04, 3.97, 3.9, 3.83, 3.76, 3.69, 3.62, 3.55, 3.49, 3.42, 3.36, 3.29, 3.23, 3.17, 3.11, 3.05, 2.99, 2.93, 2.87, 2.81, 2.75, 2.7, 2.64, 2.58, 2.53, 2.47, 2.41, 2.36, 2.3, 2.25, 2.19, 2.14, 2.09, 2.03, 1.98, 1.92, 1.87, 1.81, 1.76, 1.7, 1.65, 1.59, 1.54, 1.48, 1.42, 1.37, 1.31, 1.25, 1.19, 1.13, 1.06, 1.0, 0.93, 0.86, 0.79, 0.71, 0.63, 0.54, 0.43, 0.3], [35.89, 28.31, 20.52, 15.09, 13.39, 12.37, 11.64, 11.07, 10.6, 10.19, 9.84, 9.52, 9.24, 8.98, 8.74, 8.52, 8.31, 8.12, 7.93, 7.76, 7.6, 7.44, 7.29, 7.15, 7.01, 6.88, 6.75, 6.63, 6.51, 6.39, 6.28, 6.17, 6.06, 5.96, 5.86, 5.76, 5.67, 5.57, 5.48, 5.39, 5.3, 5.22, 5.13, 5.05, 4.97, 4.89, 4.81, 4.73, 4.65, 4.57, 4.5, 4.42, 4.35, 4.28, 4.21, 4.14, 4.07, 4.0, 3.93, 3.86, 3.79, 3.72, 3.66, 3.59, 3.52, 3.46, 3.39, 3.33, 3.26, 3.19, 3.13, 3.06, 3.0, 2.94, 2.87, 2.81, 2.74, 2.67, 2.61, 2.54, 2.48, 2.41, 2.34, 2.27, 2.21, 2.14, 2.07, 1.99, 1.92, 1.85, 1.77, 1.69, 1.61, 1.53, 1.44, 1.35, 1.25, 1.15, 1.03, 0.9, 0.75, 0.55], [38.26, 30.5, 22.46, 16.81, 15.03, 13.97, 13.2, 12.59, 12.09, 11.66, 11.28, 10.95, 10.64, 10.37, 10.11, 9.88, 9.65, 9.45, 9.25, 9.06, 8.89, 8.72, 8.56, 8.4, 8.26, 8.11, 7.97, 7.84, 7.71, 7.59, 7.46, 7.35, 7.23, 7.12, 7.01, 6.9, 6.8, 6.69, 6.59, 6.5, 6.4, 6.3, 6.21, 6.12, 6.03, 5.94, 5.85, 5.77, 5.68, 5.6, 5.51, 5.43, 5.35, 5.27, 5.19, 5.11, 5.03, 4.95, 4.87, 4.8, 4.72, 4.65, 4.57, 4.5, 4.42, 4.35, 4.27, 4.2, 4.12, 4.05, 3.98, 3.9, 3.83, 3.75, 3.68, 3.6, 3.53, 3.45, 3.38, 3.3, 3.23, 3.15, 3.07, 2.99, 2.91, 2.83, 2.75, 2.66, 2.57, 2.49, 2.4, 2.3, 2.2, 2.1, 2.0, 1.88, 1.76, 1.64, 1.49, 1.33, 1.13, 0.87], [40.52, 32.59, 24.32, 18.48, 16.62, 15.51, 14.7, 14.07, 13.54, 13.09, 12.69, 12.34, 12.02, 11.72, 11.45, 11.2, 10.97, 10.75, 10.54, 10.34, 10.15, 9.97, 9.8, 9.64, 9.48, 9.33, 9.18, 9.04, 8.9, 8.76, 8.63, 8.51, 8.38, 8.26, 8.14, 8.03, 7.92, 7.81, 7.7, 7.59, 7.49, 7.38, 7.28, 7.18, 7.09, 6.99, 6.89, 6.8, 6.71, 6.62, 6.52, 6.43, 6.35, 6.26, 6.17, 6.08, 6.0, 5.91, 5.83, 5.74, 5.66, 5.58, 5.49, 5.41, 5.33, 5.25, 5.16, 5.08, 5.0, 4.92, 4.84, 4.75, 4.67, 4.59, 4.51, 4.42, 4.34, 4.25, 4.17, 4.08, 4.0, 3.91, 3.82, 3.73, 3.64, 3.55, 3.45, 3.36, 3.26, 3.16, 3.05, 2.95, 2.83, 2.72, 2.59, 2.46, 2.32, 2.17, 2.0, 1.8, 1.56, 1.24], [42.7, 34.6, 26.12, 20.09, 18.17, 17.01, 16.17, 15.51, 14.96, 14.48, 14.07, 13.7, 13.36, 13.05, 12.77, 12.51, 12.26, 12.03, 11.81, 11.6, 11.4, 11.21, 11.03, 10.86, 10.69, 10.53, 10.37, 10.22, 10.07, 9.93, 9.79, 9.66, 9.52, 9.4, 9.27, 9.15, 9.03, 8.91, 8.79, 8.68, 8.57, 8.46, 8.35, 8.24, 8.14, 8.04, 7.93, 7.83, 7.73, 7.63, 7.54, 7.44, 7.34, 7.25, 7.16, 7.06, 6.97, 6.88, 6.78, 6.69, 6.6, 6.51, 6.42, 6.33, 6.24, 6.15, 6.06, 5.98, 5.89, 5.8, 5.71, 5.62, 5.53, 5.44, 5.35, 5.26, 5.16, 5.07, 4.98, 4.88, 4.79, 4.69, 4.59, 4.49, 4.39, 4.29, 4.19, 4.08, 3.97, 3.85, 3.74, 3.62, 3.49, 3.36, 3.22, 3.07, 2.91, 2.73, 2.54, 2.31, 2.03, 1.65], [44.81, 36.55, 27.88, 21.67, 19.68, 18.48, 17.61, 16.92, 16.35, 15.85, 15.42, 15.03, 14.68, 14.36, 14.07, 13.79, 13.53, 13.29, 13.06, 12.84, 12.63, 12.43, 12.24, 12.06, 11.88, 11.71, 11.55, 11.39, 11.23, 11.08, 10.94, 10.8, 10.66, 10.52, 10.39, 10.26, 10.13, 10.01, 9.88, 9.76, 9.64, 9.53, 9.41, 9.3, 9.19, 9.08, 8.97, 8.86, 8.76, 8.65, 8.55, 8.44, 8.34, 8.24, 8.14, 8.04, 7.94, 7.84, 7.75, 7.65, 7.55, 7.45, 7.36, 7.26, 7.16, 7.07, 6.97, 6.88, 6.78, 6.68, 6.59, 6.49, 6.39, 6.3, 6.2, 6.1, 6.0, 5.9, 5.8, 5.7, 5.59, 5.49, 5.38, 5.27, 5.16, 5.05, 4.93, 4.82, 4.7, 4.57, 4.44, 4.31, 4.17, 4.02, 3.87, 3.7, 3.52, 3.33, 3.1, 2.85, 2.53, 2.09], [46.86, 38.45, 29.59, 23.21, 21.16, 19.92, 19.02, 18.31, 17.71, 17.2, 16.75, 16.35, 15.99, 15.65, 15.34, 15.06, 14.79, 14.53, 14.29, 14.07, 13.85, 13.64, 13.44, 13.25, 13.07, 12.89, 12.72, 12.55, 12.39, 12.23, 12.08, 11.93, 11.78, 11.64, 11.5, 11.36, 11.23, 11.1, 10.97, 10.84, 10.72, 10.59, 10.47, 10.35, 10.24, 10.12, 10.01, 9.89, 9.78, 9.67, 9.56, 9.45, 9.34, 9.23, 9.13, 9.02, 8.92, 8.81, 8.71, 8.6, 8.5, 8.4, 8.3, 8.19, 8.09, 7.99, 7.89, 7.78, 7.68, 7.58, 7.47, 7.37, 7.27, 7.16, 7.06, 6.95, 6.84, 6.74, 6.63, 6.52, 6.41, 6.29, 6.18, 6.06, 5.94, 5.82, 5.7, 5.57, 5.44, 5.3, 5.16, 5.02, 4.87, 4.7, 4.54, 4.35, 4.16, 3.94, 3.7, 3.41, 3.06, 2.56], [48.87, 40.31, 31.26, 24.72, 22.62, 21.34, 20.41, 19.68, 19.06, 18.53, 18.07, 17.65, 17.28, 16.93, 16.61, 16.31, 16.03, 15.77, 15.52, 15.28, 15.05, 14.84, 14.63, 14.43, 14.24, 14.05, 13.87, 13.7, 13.53, 13.37, 13.21, 13.05, 12.9, 12.75, 12.6, 12.46, 12.32, 12.18, 12.05, 11.92, 11.79, 11.66, 11.53, 11.4, 11.28, 11.16, 11.04, 10.92, 10.8, 10.69, 10.57, 10.45, 10.34, 10.23, 10.12, 10.0, 9.89, 9.78, 9.67, 9.56, 9.45, 9.35, 9.24, 9.13, 9.02, 8.91, 8.8, 8.7, 8.59, 8.48, 8.37, 8.26, 8.15, 8.04, 7.93, 7.81, 7.7, 7.58, 7.47, 7.35, 7.23, 7.11, 6.99, 6.86, 6.74, 6.61, 6.47, 6.34, 6.2, 6.05, 5.9, 5.74, 5.58, 5.4, 5.22, 5.02, 4.81, 4.57, 4.31, 4.0, 3.61, 3.05], [50.83, 42.13, 32.91, 26.22, 24.05, 22.74, 21.79, 21.03, 20.39, 19.85, 19.37, 18.94, 18.55, 18.19, 17.86, 17.55, 17.26, 16.99, 16.73, 16.49, 16.25, 16.03, 15.81, 15.61, 15.41, 15.21, 15.03, 14.85, 14.67, 14.5, 14.33, 14.17, 14.01, 13.86, 13.7, 13.56, 13.41, 13.27, 13.13, 12.99, 12.85, 12.72, 12.58, 12.45, 12.32, 12.2, 12.07, 11.95, 11.82, 11.7, 11.58, 11.46, 11.34, 11.22, 11.1, 10.99, 10.87, 10.76, 10.64, 10.53, 10.41, 10.3, 10.18, 10.07, 9.95, 9.84, 9.73, 9.61, 9.5, 9.38, 9.27, 9.15, 9.03, 8.92, 8.8, 8.68, 8.56, 8.44, 8.32, 8.19, 8.07, 7.94, 7.81, 7.67, 7.54, 7.4, 7.26, 7.11, 6.96, 6.81, 6.65, 6.48, 6.3, 6.12, 5.92, 5.71, 5.48, 5.23, 4.94, 4.6, 4.18, 3.57], [52.75, 43.92, 34.53, 27.69, 25.47, 24.12, 23.14, 22.36, 21.71, 21.15, 20.66, 20.21, 19.81, 19.44, 19.1, 18.78, 18.48, 18.2, 17.94, 17.68, 17.44, 17.21, 16.98, 16.77, 16.56, 16.36, 16.17, 15.98, 15.8, 15.62, 15.45, 15.28, 15.12, 14.96, 14.8, 14.65, 14.49, 14.35, 14.2, 14.05, 13.91, 13.77, 13.64, 13.5, 13.37, 13.23, 13.1, 12.97, 12.84, 12.72, 12.59, 12.46, 12.34, 12.22, 12.09, 11.97, 11.85, 11.73, 11.61, 11.49, 11.37, 11.25, 11.13, 11.01, 10.89, 10.77, 10.65, 10.53, 10.41, 10.29, 10.17, 10.05, 9.93, 9.8, 9.68, 9.55, 9.43, 9.3, 9.17, 9.04, 8.91, 8.77, 8.63, 8.49, 8.35, 8.2, 8.05, 7.9, 7.74, 7.58, 7.41, 7.23, 7.04, 6.84, 6.63, 6.41, 6.16, 5.89, 5.58, 5.22, 4.77, 4.11], [54.64, 45.68, 36.12, 29.14, 26.87, 25.49, 24.49, 23.68, 23.02, 22.44, 21.93, 21.48, 21.06, 20.68, 20.33, 20.0, 19.7, 19.41, 19.13, 18.87, 18.62, 18.38, 18.15, 17.93, 17.72, 17.51, 17.31, 17.12, 16.93, 16.75, 16.57, 16.39, 16.22, 16.06, 15.89, 15.73, 15.58, 15.42, 15.27, 15.12, 14.97, 14.83, 14.69, 14.54, 14.4, 14.27, 14.13, 14.0, 13.86, 13.73, 13.6, 13.47, 13.34, 13.21, 13.08, 12.96, 12.83, 12.7, 12.58, 12.45, 12.33, 12.2, 12.08, 11.95, 11.83, 11.7, 11.58, 11.45, 11.33, 11.2, 11.08, 10.95, 10.82, 10.69, 10.56, 10.43, 10.3, 10.17, 10.03, 9.89, 9.75, 9.61, 9.47, 9.32, 9.17, 9.02, 8.86, 8.7, 8.53, 8.36, 8.18, 7.99, 7.79, 7.58, 7.36, 7.12, 6.86, 6.57, 6.24, 5.86, 5.37, 4.66], [56.49, 47.41, 37.7, 30.58, 28.26, 26.85, 25.82, 25.0, 24.31, 23.72, 23.2, 22.73, 22.31, 21.92, 21.56, 21.22, 20.9, 20.6, 20.32, 20.05, 19.79, 19.55, 19.31, 19.08, 18.86, 18.65, 18.44, 18.25, 18.05, 17.86, 17.68, 17.5, 17.32, 17.15, 16.98, 16.82, 16.65, 16.49, 16.34, 16.18, 16.03, 15.88, 15.73, 15.59, 15.44, 15.3, 15.16, 15.02, 14.88, 14.74, 14.61, 14.47, 14.34, 14.21, 14.07, 13.94, 13.81, 13.68, 13.55, 13.42, 13.29, 13.16, 13.03, 12.9, 12.77, 12.64, 12.51, 12.38, 12.25, 12.12, 11.99, 11.85, 11.72, 11.59, 11.45, 11.31, 11.18, 11.04, 10.9, 10.75, 10.61, 10.46, 10.31, 10.15, 10.0, 9.83, 9.67, 9.5, 9.32, 9.14, 8.95, 8.75, 8.55, 8.33, 8.09, 7.84, 7.57, 7.26, 6.91, 6.5, 5.98, 5.23], [58.32, 49.12, 39.25, 32.0, 29.63, 28.19, 27.14, 26.3, 25.59, 24.99, 24.46, 23.98, 23.54, 23.14, 22.77, 22.42, 22.1, 21.79, 21.5, 21.23, 20.96, 20.71, 20.47, 20.23, 20.0, 19.79, 19.57, 19.37, 19.17, 18.97, 18.78, 18.6, 18.42, 18.24, 18.07, 17.9, 17.73, 17.56, 17.4, 17.24, 17.09, 16.93, 16.78, 16.63, 16.48, 16.33, 16.19, 16.04, 15.9, 15.76, 15.62, 15.48, 15.34, 15.2, 15.06, 14.93, 14.79, 14.66, 14.52, 14.39, 14.25, 14.12, 13.98, 13.85, 13.71, 13.58, 13.44, 13.31, 13.17, 13.04, 12.9, 12.76, 12.62, 12.48, 12.34, 12.2, 12.06, 11.91, 11.76, 11.62, 11.46, 11.31, 11.15, 10.99, 10.83, 10.66, 10.49, 10.31, 10.13, 9.94, 9.74, 9.53, 9.31, 9.08, 8.84, 8.57, 8.28, 7.96, 7.6, 7.16, 6.61, 5.81], [60.13, 50.81, 40.79, 33.41, 31.0, 29.52, 28.44, 27.59, 26.87, 26.25, 25.71, 25.21, 24.77, 24.36, 23.98, 23.62, 23.29, 22.98, 22.68, 22.4, 22.12, 21.86, 21.61, 21.37, 21.14, 20.92, 20.7, 20.49, 20.28, 20.08, 19.89, 19.7, 19.51, 19.33, 19.15, 18.97, 18.8, 18.63, 18.47, 18.3, 18.14, 17.98, 17.82, 17.67, 17.52, 17.36, 17.21, 17.06, 16.92, 16.77, 16.63, 16.48, 16.34, 16.2, 16.05, 15.91, 15.77, 15.63, 15.49, 15.35, 15.21, 15.08, 14.94, 14.8, 14.66, 14.52, 14.38, 14.24, 14.1, 13.96, 13.82, 13.67, 13.53, 13.39, 13.24, 13.09, 12.94, 12.79, 12.64, 12.48, 12.33, 12.17, 12.0, 11.84, 11.66, 11.49, 11.31, 11.12, 10.93, 10.74, 10.53, 10.31, 10.09, 9.84, 9.59, 9.31, 9.01, 8.67, 8.29, 7.83, 7.26, 6.41], [61.91, 52.47, 42.31, 34.81, 32.35, 30.84, 29.75, 28.87, 28.14, 27.5, 26.95, 26.45, 25.99, 25.57, 25.18, 24.82, 24.48, 24.16, 23.85, 23.56, 23.28, 23.02, 22.76, 22.51, 22.28, 22.04, 21.82, 21.6, 21.39, 21.19, 20.99, 20.79, 20.6, 20.41, 20.23, 20.05, 19.87, 19.7, 19.53, 19.36, 19.19, 19.03, 18.87, 18.71, 18.55, 18.39, 18.24, 18.09, 17.93, 17.78, 17.63, 17.49, 17.34, 17.19, 17.05, 16.9, 16.76, 16.61, 16.47, 16.32, 16.18, 16.04, 15.89, 15.75, 15.61, 15.46, 15.32, 15.17, 15.03, 14.88, 14.74, 14.59, 14.44, 14.29, 14.14, 13.99, 13.83, 13.68, 13.52, 13.36, 13.19, 13.03, 12.86, 12.68, 12.51, 12.33, 12.14, 11.95, 11.75, 11.54, 11.33, 11.1, 10.86, 10.61, 10.35, 10.06, 9.74, 9.39, 8.99, 8.51, 7.91, 7.01], [63.68, 54.12, 43.82, 36.19, 33.69, 32.16, 31.04, 30.14, 29.4, 28.75, 28.18, 27.67, 27.2, 26.78, 26.38, 26.01, 25.66, 25.33, 25.02, 24.72, 24.43, 24.16, 23.9, 23.65, 23.4, 23.17, 22.94, 22.72, 22.5, 22.29, 22.09, 21.89, 21.69, 21.5, 21.31, 21.12, 20.94, 20.76, 20.59, 20.42, 20.24, 20.08, 19.91, 19.75, 19.58, 19.42, 19.26, 19.11, 18.95, 18.8, 18.64, 18.49, 18.34, 18.19, 18.04, 17.89, 17.74, 17.59, 17.44, 17.29, 17.15, 17.0, 16.85, 16.7, 16.55, 16.41, 16.26, 16.11, 15.96, 15.81, 15.66, 15.51, 15.35, 15.2, 15.04, 14.88, 14.72, 14.56, 14.4, 14.23, 14.06, 13.89, 13.72, 13.54, 13.35, 13.17, 12.97, 12.77, 12.57, 12.35, 12.13, 11.9, 11.65, 11.39, 11.11, 10.81, 10.48, 10.12, 9.7, 9.2, 8.57, 7.63], [65.42, 55.76, 45.31, 37.57, 35.02, 33.46, 32.32, 31.41, 30.65, 29.99, 29.41, 28.89, 28.41, 27.97, 27.57, 27.19, 26.83, 26.5, 26.18, 25.87, 25.58, 25.31, 25.04, 24.78, 24.53, 24.29, 24.05, 23.83, 23.61, 23.39, 23.18, 22.98, 22.77, 22.58, 22.38, 22.2, 22.01, 21.83, 21.65, 21.47, 21.29, 21.12, 20.95, 20.78, 20.62, 20.45, 20.29, 20.13, 19.97, 19.81, 19.65, 19.49, 19.34, 19.18, 19.03, 18.87, 18.72, 18.57, 18.42, 18.26, 18.11, 17.96, 17.81, 17.66, 17.5, 17.35, 17.2, 17.05, 16.89, 16.74, 16.58, 16.42, 16.27, 16.11, 15.95, 15.78, 15.62, 15.45, 15.28, 15.11, 14.94, 14.76, 14.58, 14.39, 14.2, 14.01, 13.81, 13.6, 13.39, 13.17, 12.94, 12.7, 12.44, 12.17, 11.88, 11.57, 11.23, 10.85, 10.42, 9.9, 9.24, 8.26], [67.15, 57.37, 46.8, 38.93, 36.34, 34.76, 33.6, 32.67, 31.89, 31.22, 30.63, 30.1, 29.62, 29.17, 28.76, 28.37, 28.01, 27.66, 27.34, 27.03, 26.73, 26.44, 26.17, 25.91, 25.65, 25.41, 25.17, 24.93, 24.71, 24.49, 24.27, 24.06, 23.86, 23.66, 23.46, 23.27, 23.07, 22.89, 22.7, 22.52, 22.34, 22.17, 21.99, 21.82, 21.65, 21.48, 21.31, 21.15, 20.98, 20.82, 20.66, 20.5, 20.34, 20.18, 20.02, 19.86, 19.71, 19.55, 19.39, 19.24, 19.08, 18.92, 18.77, 18.61, 18.46, 18.3, 18.14, 17.98, 17.83, 17.67, 17.51, 17.34, 17.18, 17.02, 16.85, 16.69, 16.52, 16.34, 16.17, 15.99, 15.81, 15.63, 15.44, 15.25, 15.06, 14.86, 14.65, 14.44, 14.22, 13.99, 13.75, 13.5, 13.24, 12.96, 12.66, 12.34, 11.99, 11.59, 11.14, 10.6, 9.91, 8.9], [68.86, 58.98, 48.27, 40.29, 37.66, 36.05, 34.87, 33.92, 33.13, 32.45, 31.85, 31.31, 30.81, 30.36, 29.94, 29.54, 29.17, 28.82, 28.49, 28.17, 27.87, 27.58, 27.3, 27.03, 26.77, 26.52, 26.28, 26.04, 25.81, 25.58, 25.36, 25.15, 24.94, 24.73, 24.53, 24.33, 24.14, 23.95, 23.76, 23.57, 23.39, 23.21, 23.03, 22.85, 22.68, 22.51, 22.34, 22.17, 22.0, 21.83, 21.67, 21.5, 21.34, 21.17, 21.01, 20.85, 20.69, 20.53, 20.37, 20.21, 20.05, 19.89, 19.73, 19.57, 19.41, 19.25, 19.09, 18.92, 18.76, 18.6, 18.43, 18.27, 18.1, 17.93, 17.76, 17.59, 17.42, 17.24, 17.06, 16.88, 16.69, 16.51, 16.31, 16.12, 15.92, 15.71, 15.5, 15.28, 15.05, 14.82, 14.57, 14.31, 14.04, 13.75, 13.45, 13.11, 12.75, 12.34, 11.87, 11.31, 10.6, 9.54], [70.55, 60.57, 49.73, 41.64, 38.97, 37.33, 36.13, 35.17, 34.37, 33.68, 33.06, 32.51, 32.01, 31.54, 31.11, 30.71, 30.34, 29.98, 29.64, 29.32, 29.01, 28.71, 28.43, 28.15, 27.89, 27.63, 27.38, 27.14, 26.91, 26.68, 26.45, 26.23, 26.02, 25.81, 25.6, 25.4, 25.2, 25.01, 24.81, 24.62, 24.44, 24.25, 24.07, 23.89, 23.71, 23.53, 23.36, 23.19, 23.01, 22.84, 22.67, 22.5, 22.34, 22.17, 22.0, 21.84, 21.67, 21.51, 21.35, 21.18, 21.02, 20.85, 20.69, 20.53, 20.36, 20.2, 20.03, 19.87, 19.7, 19.53, 19.36, 19.19, 19.02, 18.85, 18.67, 18.5, 18.32, 18.14, 17.95, 17.77, 17.58, 17.38, 17.19, 16.98, 16.78, 16.57, 16.35, 16.12, 15.89, 15.65, 15.39, 15.13, 14.85, 14.55, 14.23, 13.89, 13.51, 13.09, 12.61, 12.03, 11.29, 10.2], [72.23, 62.14, 51.18, 42.98, 40.27, 38.61, 37.39, 36.42, 35.6, 34.89, 34.27, 33.71, 33.2, 32.73, 32.29, 31.88, 31.5, 31.13, 30.79, 30.46, 30.14, 29.84, 29.55, 29.27, 29.0, 28.74, 28.49, 28.24, 28.0, 27.77, 27.54, 27.31, 27.1, 26.88, 26.67, 26.47, 26.26, 26.06, 25.87, 25.67, 25.48, 25.29, 25.11, 24.92, 24.74, 24.56, 24.38, 24.2, 24.03, 23.85, 23.68, 23.51, 23.34, 23.17, 23.0, 22.83, 22.66, 22.49, 22.32, 22.16, 21.99, 21.82, 21.65, 21.48, 21.32, 21.15, 20.98, 20.81, 20.64, 20.47, 20.29, 20.12, 19.94, 19.77, 19.59, 19.41, 19.22, 19.04, 18.85, 18.66, 18.46, 18.26, 18.06, 17.85, 17.64, 17.42, 17.2, 16.97, 16.73, 16.48, 16.22, 15.95, 15.66, 15.35, 15.03, 14.67, 14.28, 13.85, 13.35, 12.75, 11.99, 10.86], [73.89, 63.71, 52.62, 44.31, 41.57, 39.88, 38.64, 37.65, 36.82, 36.11, 35.47, 34.9, 34.38, 33.9, 33.46, 33.04, 32.65, 32.28, 31.93, 31.6, 31.28, 30.97, 30.68, 30.39, 30.12, 29.85, 29.59, 29.34, 29.09, 28.86, 28.62, 28.39, 28.17, 27.95, 27.74, 27.53, 27.32, 27.12, 26.92, 26.72, 26.53, 26.33, 26.14, 25.96, 25.77, 25.59, 25.4, 25.22, 25.04, 24.86, 24.69, 24.51, 24.34, 24.16, 23.99, 23.82, 23.64, 23.47, 23.3, 23.13, 22.96, 22.79, 22.62, 22.44, 22.27, 22.1, 21.93, 21.75, 21.58, 21.4, 21.22, 21.05, 20.87, 20.69, 20.5, 20.32, 20.13, 19.94, 19.75, 19.55, 19.35, 19.15, 18.94, 18.73, 18.51, 18.29, 18.06, 17.82, 17.57, 17.32, 17.05, 16.77, 16.47, 16.16, 15.82, 15.46, 15.06, 14.61, 14.1, 13.48, 12.7, 11.52], [75.55, 65.26, 54.05, 45.64, 42.86, 41.15, 39.89, 38.89, 38.04, 37.32, 36.67, 36.09, 35.56, 35.08, 34.62, 34.2, 33.81, 33.43, 33.07, 32.73, 32.41, 32.09, 31.79, 31.5, 31.22, 30.95, 30.69, 30.43, 30.19, 29.94, 29.71, 29.47, 29.25, 29.02, 28.81, 28.59, 28.38, 28.17, 27.97, 27.77, 27.57, 27.37, 27.18, 26.99, 26.8, 26.61, 26.42, 26.24, 26.06, 25.87, 25.69, 25.51, 25.34, 25.16, 24.98, 24.81, 24.63, 24.45, 24.28, 24.1, 23.93, 23.75, 23.58, 23.4, 23.23, 23.05, 22.88, 22.7, 22.52, 22.34, 22.16, 21.98, 21.79, 21.61, 21.42, 21.23, 21.04, 20.84, 20.65, 20.45, 20.24, 20.03, 19.82, 19.6, 19.38, 19.15, 18.91, 18.67, 18.42, 18.16, 17.88, 17.6, 17.29, 16.97, 16.62, 16.25, 15.84, 15.38, 14.85, 14.22, 13.41, 12.2], [77.19, 66.81, 55.48, 46.96, 44.14, 42.41, 41.13, 40.11, 39.26, 38.52, 37.87, 37.28, 36.74, 36.25, 35.79, 35.36, 34.96, 34.57, 34.21, 33.87, 33.53, 33.22, 32.91, 32.62, 32.33, 32.06, 31.79, 31.53, 31.27, 31.03, 30.79, 30.55, 30.32, 30.09, 29.87, 29.65, 29.44, 29.23, 29.02, 28.81, 28.61, 28.41, 28.21, 28.02, 27.83, 27.63, 27.44, 27.26, 27.07, 26.89, 26.7, 26.52, 26.34, 26.16, 25.97, 25.79, 25.62, 25.44, 25.26, 25.08, 24.9, 24.72, 24.54, 24.37, 24.19, 24.01, 23.83, 23.64, 23.46, 23.28, 23.09, 22.91, 22.72, 22.53, 22.34, 22.14, 21.95, 21.75, 21.55, 21.34, 21.13, 20.92, 20.7, 20.48, 20.25, 20.02, 19.78, 19.53, 19.27, 19.0, 18.72, 18.42, 18.11, 17.78, 17.43, 17.05, 16.62, 16.15, 15.61, 14.96, 14.13, 12.88], [78.82, 68.34, 56.89, 48.28, 45.42, 43.66, 42.37, 41.34, 40.47, 39.72, 39.06, 38.46, 37.92, 37.41, 36.95, 36.51, 36.1, 35.71, 35.35, 35.0, 34.66, 34.34, 34.03, 33.73, 33.44, 33.16, 32.89, 32.62, 32.36, 32.11, 31.87, 31.63, 31.39, 31.16, 30.93, 30.71, 30.49, 30.28, 30.07, 29.86, 29.65, 29.45, 29.25, 29.05, 28.85, 28.66, 28.47, 28.27, 28.08, 27.9, 27.71, 27.52, 27.34, 27.15, 26.97, 26.78, 26.6, 26.42, 26.24, 26.06, 25.87, 25.69, 25.51, 25.33, 25.14, 24.96, 24.78, 24.59, 24.4, 24.22, 24.03, 23.84, 23.65, 23.45, 23.26, 23.06, 22.86, 22.66, 22.45, 22.24, 22.03, 21.81, 21.59, 21.36, 21.13, 20.89, 20.64, 20.39, 20.12, 19.85, 19.56, 19.26, 18.94, 18.6, 18.24, 17.84, 17.41, 16.93, 16.37, 15.7, 14.85, 13.56], [80.44, 69.87, 58.3, 49.59, 46.69, 44.91, 43.6, 42.56, 41.68, 40.92, 40.25, 39.64, 39.09, 38.58, 38.11, 37.66, 37.25, 36.85, 36.48, 36.12, 35.78, 35.45, 35.14, 34.84, 34.54, 34.26, 33.98, 33.71, 33.45, 33.19, 32.94, 32.7, 32.46, 32.23, 32.0, 31.77, 31.55, 31.33, 31.12, 30.9, 30.69, 30.49, 30.28, 30.08, 29.88, 29.68, 29.49, 29.29, 29.1, 28.91, 28.71, 28.52, 28.34, 28.15, 27.96, 27.77, 27.59, 27.4, 27.22, 27.03, 26.85, 26.66, 26.48, 26.29, 26.1, 25.92, 25.73, 25.54, 25.35, 25.16, 24.97, 24.77, 24.58, 24.38, 24.18, 23.98, 23.77, 23.57, 23.36, 23.14, 22.92, 22.7, 22.48, 22.24, 22.0, 21.76, 21.51, 21.25, 20.98, 20.7, 20.4, 20.09, 19.77, 19.42, 19.05, 18.65, 18.2, 17.71, 17.14, 16.45, 15.57, 14.26], [82.04, 71.38, 59.7, 50.89, 47.96, 46.16, 44.83, 43.77, 42.88, 42.11, 41.43, 40.82, 40.26, 39.74, 39.26, 38.81, 38.39, 37.99, 37.61, 37.25, 36.9, 36.57, 36.25, 35.94, 35.64, 35.35, 35.07, 34.8, 34.53, 34.27, 34.02, 33.77, 33.53, 33.29, 33.06, 32.83, 32.6, 32.38, 32.16, 31.95, 31.73, 31.52, 31.32, 31.11, 30.91, 30.71, 30.51, 30.31, 30.11, 29.92, 29.72, 29.53, 29.34, 29.14, 28.95, 28.76, 28.57, 28.39, 28.2, 28.01, 27.82, 27.63, 27.44, 27.25, 27.06, 26.87, 26.68, 26.49, 26.29, 26.1, 25.9, 25.71, 25.51, 25.31, 25.1, 24.9, 24.69, 24.48, 24.26, 24.04, 23.82, 23.6, 23.36, 23.13, 22.88, 22.63, 22.38, 22.11, 21.83, 21.55, 21.25, 20.93, 20.6, 20.25, 19.87, 19.45, 19.0, 18.49, 17.91, 17.21, 16.31, 14.95], [83.64, 72.89, 61.1, 52.19, 49.23, 47.4, 46.06, 44.99, 44.08, 43.3, 42.61, 41.99, 41.42, 40.9, 40.41, 39.96, 39.53, 39.12, 38.74, 38.37, 38.02, 37.68, 37.36, 37.05, 36.74, 36.45, 36.16, 35.89, 35.62, 35.35, 35.1, 34.84, 34.6, 34.36, 34.12, 33.89, 33.66, 33.43, 33.21, 32.99, 32.77, 32.56, 32.35, 32.14, 31.93, 31.73, 31.52, 31.32, 31.12, 30.92, 30.73, 30.53, 30.34, 30.14, 29.95, 29.75, 29.56, 29.37, 29.18, 28.99, 28.79, 28.6, 28.41, 28.22, 28.02, 27.83, 27.63, 27.44, 27.24, 27.04, 26.84, 26.64, 26.44, 26.23, 26.03, 25.82, 25.61, 25.39, 25.17, 24.95, 24.72, 24.49, 24.26, 24.01, 23.77, 23.51, 23.25, 22.98, 22.69, 22.4, 22.1, 21.77, 21.43, 21.07, 20.68, 20.26, 19.8, 19.28, 18.68, 17.97, 17.04, 15.66], [85.23, 74.39, 62.49, 53.49, 50.49, 48.64, 47.28, 46.19, 45.28, 44.49, 43.79, 43.16, 42.58, 42.05, 41.56, 41.1, 40.67, 40.26, 39.87, 39.49, 39.14, 38.8, 38.47, 38.15, 37.84, 37.54, 37.25, 36.97, 36.7, 36.43, 36.17, 35.92, 35.66, 35.42, 35.18, 34.94, 34.71, 34.48, 34.25, 34.03, 33.81, 33.6, 33.38, 33.17, 32.96, 32.75, 32.54, 32.34, 32.14, 31.93, 31.73, 31.53, 31.34, 31.14, 30.94, 30.74, 30.55, 30.35, 30.16, 29.96, 29.77, 29.57, 29.38, 29.18, 28.98, 28.79, 28.59, 28.39, 28.19, 27.99, 27.78, 27.58, 27.37, 27.16, 26.95, 26.74, 26.52, 26.3, 26.08, 25.85, 25.62, 25.39, 25.15, 24.9, 24.65, 24.39, 24.12, 23.84, 23.56, 23.26, 22.95, 22.62, 22.27, 21.9, 21.51, 21.08, 20.6, 20.07, 19.46, 18.73, 17.78, 16.36], [86.81, 75.88, 63.87, 54.78, 51.74, 49.88, 48.5, 47.4, 46.48, 45.68, 44.97, 44.33, 43.75, 43.21, 42.71, 42.24, 41.8, 41.39, 40.99, 40.61, 40.25, 39.91, 39.57, 39.25, 38.94, 38.64, 38.34, 38.06, 37.78, 37.51, 37.24, 36.98, 36.73, 36.48, 36.24, 36.0, 35.76, 35.53, 35.3, 35.07, 34.85, 34.63, 34.41, 34.2, 33.98, 33.77, 33.56, 33.36, 33.15, 32.94, 32.74, 32.54, 32.34, 32.13, 31.93, 31.74, 31.54, 31.34, 31.14, 30.94, 30.74, 30.54, 30.34, 30.15, 29.95, 29.74, 29.54, 29.34, 29.14, 28.93, 28.73, 28.52, 28.31, 28.09, 27.88, 27.66, 27.44, 27.22, 26.99, 26.76, 26.53, 26.29, 26.04, 25.79, 25.53, 25.27, 25.0, 24.71, 24.42, 24.12, 23.8, 23.46, 23.11, 22.73, 22.33, 21.89, 21.41, 20.87, 20.24, 19.49, 18.53, 17.07], [88.38, 77.37, 65.25, 56.06, 53.0, 51.11, 49.72, 48.6, 47.67, 46.86, 46.14, 45.49, 44.9, 44.36, 43.85, 43.38, 42.94, 42.51, 42.11, 41.73, 41.37, 41.01, 40.68, 40.35, 40.03, 39.73, 39.43, 39.14, 38.86, 38.58, 38.32, 38.05, 37.8, 37.54, 37.3, 37.05, 36.81, 36.58, 36.34, 36.11, 35.89, 35.66, 35.44, 35.23, 35.01, 34.79, 34.58, 34.37, 34.16, 33.95, 33.75, 33.54, 33.34, 33.13, 32.93, 32.73, 32.52, 32.32, 32.12, 31.92, 31.72, 31.52, 31.31, 31.11, 30.91, 30.7, 30.5, 30.29, 30.09, 29.88, 29.67, 29.46, 29.24, 29.03, 28.81, 28.59, 28.36, 28.14, 27.91, 27.67, 27.43, 27.19, 26.94, 26.68, 26.42, 26.15, 25.87, 25.59, 25.29, 24.98, 24.65, 24.31, 23.95, 23.57, 23.16, 22.71, 22.22, 21.66, 21.03, 20.26, 19.28, 17.79], [89.95, 78.84, 66.62, 57.34, 54.24, 52.34, 50.93, 49.8, 48.86, 48.04, 47.31, 46.66, 46.06, 45.51, 45.0, 44.52, 44.07, 43.64, 43.23, 42.85, 42.48, 42.12, 41.78, 41.45, 41.13, 40.82, 40.52, 40.22, 39.94, 39.66, 39.39, 39.12, 38.86, 38.6, 38.35, 38.11, 37.86, 37.62, 37.39, 37.15, 36.93, 36.7, 36.47, 36.25, 36.03, 35.82, 35.6, 35.39, 35.17, 34.96, 34.75, 34.54, 34.34, 34.13, 33.92, 33.72, 33.51, 33.31, 33.1, 32.9, 32.69, 32.49, 32.28, 32.08, 31.87, 31.66, 31.45, 31.25, 31.04, 30.82, 30.61, 30.4, 30.18, 29.96, 29.74, 29.51, 29.28, 29.05, 28.82, 28.58, 28.34, 28.09, 27.84, 27.58, 27.31, 27.04, 26.75, 26.46, 26.16, 25.84, 25.51, 25.16, 24.8, 24.41, 23.99, 23.53, 23.03, 22.47, 21.82, 21.03, 20.03, 18.51], [91.5, 80.31, 67.99, 58.62, 55.49, 53.56, 52.14, 51.0, 50.04, 49.21, 48.48, 47.82, 47.21, 46.66, 46.14, 45.65, 45.2, 44.76, 44.35, 43.96, 43.59, 43.23, 42.88, 42.54, 42.22, 41.91, 41.6, 41.3, 41.01, 40.73, 40.46, 40.19, 39.92, 39.66, 39.41, 39.16, 38.91, 38.67, 38.43, 38.19, 37.96, 37.73, 37.5, 37.28, 37.06, 36.84, 36.62, 36.4, 36.19, 35.97, 35.76, 35.55, 35.34, 35.13, 34.92, 34.71, 34.5, 34.29, 34.08, 33.88, 33.67, 33.46, 33.25, 33.04, 32.83, 32.62, 32.41, 32.2, 31.99, 31.77, 31.55, 31.34, 31.12, 30.89, 30.67, 30.44, 30.21, 29.97, 29.73, 29.49, 29.24, 28.99, 28.73, 28.47, 28.2, 27.92, 27.63, 27.34, 27.03, 26.71, 26.37, 26.02, 25.64, 25.25, 24.82, 24.35, 23.84, 23.27, 22.61, 21.81, 20.78, 19.23], [93.05, 81.78, 69.35, 59.89, 56.73, 54.78, 53.34, 52.19, 51.23, 50.39, 49.64, 48.97, 48.36, 47.8, 47.28, 46.79, 46.32, 45.89, 45.47, 45.07, 44.69, 44.33, 43.98, 43.64, 43.31, 42.99, 42.68, 42.38, 42.09, 41.8, 41.53, 41.25, 40.98, 40.72, 40.46, 40.21, 39.96, 39.71, 39.47, 39.23, 39.0, 38.77, 38.53, 38.31, 38.08, 37.86, 37.64, 37.42, 37.2, 36.98, 36.76, 36.55, 36.34, 36.12, 35.91, 35.7, 35.49, 35.28, 35.07, 34.85, 34.64, 34.43, 34.22, 34.01, 33.8, 33.58, 33.37, 33.15, 32.94, 32.72, 32.5, 32.28, 32.05, 31.83, 31.6, 31.37, 31.13, 30.89, 30.65, 30.4, 30.15, 29.9, 29.64, 29.37, 29.09, 28.81, 28.52, 28.21, 27.9, 27.57, 27.23, 26.87, 26.49, 26.09, 25.65, 25.18, 24.66, 24.07, 23.4, 22.59, 21.54, 19.96], [94.59, 83.24, 70.7, 61.16, 57.97, 56.0, 54.55, 53.38, 52.41, 51.56, 50.81, 50.13, 49.51, 48.94, 48.41, 47.92, 47.45, 47.01, 46.59, 46.19, 45.8, 45.43, 45.08, 44.73, 44.4, 44.08, 43.77, 43.46, 43.17, 42.88, 42.59, 42.32, 42.05, 41.78, 41.52, 41.26, 41.01, 40.76, 40.51, 40.27, 40.03, 39.8, 39.56, 39.33, 39.1, 38.88, 38.65, 38.43, 38.21, 37.99, 37.77, 37.55, 37.34, 37.12, 36.9, 36.69, 36.48, 36.26, 36.05, 35.83, 35.62, 35.41, 35.19, 34.98, 34.76, 34.54, 34.33, 34.11, 33.89, 33.67, 33.44, 33.22, 32.99, 32.76, 32.53, 32.29, 32.06, 31.81, 31.57, 31.32, 31.06, 30.8, 30.54, 30.26, 29.99, 29.7, 29.4, 29.09, 28.77, 28.44, 28.09, 27.73, 27.34, 26.93, 26.49, 26.01, 25.48, 24.88, 24.2, 23.37, 22.3, 20.69], [96.13, 84.69, 72.05, 62.43, 59.2, 57.22, 55.75, 54.57, 53.58, 52.73, 51.97, 51.28, 50.66, 50.08, 49.55, 49.05, 48.57, 48.13, 47.7, 47.29, 46.91, 46.53, 46.17, 45.83, 45.49, 45.16, 44.85, 44.54, 44.24, 43.95, 43.66, 43.38, 43.11, 42.84, 42.57, 42.31, 42.06, 41.8, 41.56, 41.31, 41.07, 40.83, 40.59, 40.36, 40.13, 39.9, 39.67, 39.44, 39.22, 39.0, 38.78, 38.56, 38.34, 38.12, 37.9, 37.68, 37.46, 37.25, 37.03, 36.81, 36.6, 36.38, 36.16, 35.94, 35.73, 35.51, 35.29, 35.06, 34.84, 34.62, 34.39, 34.16, 33.93, 33.7, 33.46, 33.22, 32.98, 32.74, 32.49, 32.23, 31.97, 31.71, 31.44, 31.16, 30.88, 30.59, 30.29, 29.97, 29.65, 29.31, 28.96, 28.59, 28.2, 27.78, 27.33, 26.84, 26.3, 25.7, 25.0, 24.16, 23.07, 21.43], [97.65, 86.14, 73.4, 63.69, 60.44, 58.43, 56.95, 55.76, 54.76, 53.9, 53.13, 52.44, 51.81, 51.22, 50.68, 50.17, 49.7, 49.24, 48.81, 48.4, 48.01, 47.63, 47.27, 46.92, 46.58, 46.25, 45.93, 45.62, 45.31, 45.02, 44.73, 44.44, 44.16, 43.89, 43.62, 43.36, 43.1, 42.85, 42.6, 42.35, 42.1, 41.86, 41.62, 41.39, 41.15, 40.92, 40.69, 40.46, 40.23, 40.01, 39.78, 39.56, 39.34, 39.11, 38.89, 38.67, 38.45, 38.23, 38.01, 37.79, 37.57, 37.35, 37.13, 36.91, 36.69, 36.47, 36.25, 36.02, 35.79, 35.57, 35.34, 35.11, 34.87, 34.64, 34.4, 34.15, 33.91, 33.66, 33.41, 33.15, 32.89, 32.62, 32.34, 32.06, 31.78, 31.48, 31.17, 30.86, 30.53, 30.18, 29.83, 29.45, 29.05, 28.63, 28.17, 27.67, 27.12, 26.51, 25.8, 24.94, 23.84, 22.16], [99.17, 87.58, 74.74, 64.95, 61.67, 59.64, 58.14, 56.94, 55.93, 55.06, 54.29, 53.59, 52.95, 52.36, 51.81, 51.3, 50.82, 50.36, 49.93, 49.51, 49.11, 48.73, 48.36, 48.01, 47.66, 47.33, 47.01, 46.69, 46.38, 46.08, 45.79, 45.5, 45.22, 44.95, 44.68, 44.41, 44.15, 43.89, 43.64, 43.39, 43.14, 42.89, 42.65, 42.41, 42.17, 41.94, 41.7, 41.47, 41.24, 41.01, 40.79, 40.56, 40.34, 40.11, 39.89, 39.66, 39.44, 39.22, 39.0, 38.77, 38.55, 38.33, 38.11, 37.88, 37.66, 37.43, 37.21, 36.98, 36.75, 36.52, 36.28, 36.05, 35.81, 35.57, 35.33, 35.09, 34.84, 34.58, 34.33, 34.07, 33.8, 33.53, 33.25, 32.97, 32.67, 32.37, 32.06, 31.74, 31.41, 31.06, 30.69, 30.31, 29.91, 29.48, 29.01, 28.51, 27.95, 27.33, 26.6, 25.73, 24.61, 22.91], [100.69, 89.01, 76.08, 66.21, 62.89, 60.85, 59.33, 58.12, 57.11, 56.22, 55.44, 54.73, 54.09, 53.5, 52.94, 52.42, 51.94, 51.47, 51.04, 50.62, 50.21, 49.83, 49.46, 49.1, 48.75, 48.41, 48.08, 47.77, 47.46, 47.15, 46.86, 46.57, 46.28, 46.0, 45.73, 45.46, 45.19, 44.93, 44.68, 44.42, 44.17, 43.92, 43.68, 43.44, 43.2, 42.96, 42.72, 42.49, 42.25, 42.02, 41.79, 41.56, 41.34, 41.11, 40.88, 40.66, 40.43, 40.2, 39.98, 39.75, 39.53, 39.3, 39.08, 38.85, 38.62, 38.39, 38.17, 37.93, 37.7, 37.47, 37.23, 37.0, 36.75, 36.51, 36.27, 36.02, 35.77, 35.51, 35.25, 34.98, 34.71, 34.44, 34.16, 33.87, 33.57, 33.27, 32.95, 32.63, 32.29, 31.93, 31.56, 31.18, 30.77, 30.33, 29.86, 29.34, 28.78, 28.14, 27.41, 26.53, 25.38, 23.65], [102.2, 90.44, 77.42, 67.46, 64.12, 62.05, 60.53, 59.3, 58.28, 57.38, 56.59, 55.88, 55.23, 54.63, 54.07, 53.55, 53.05, 52.59, 52.14, 51.72, 51.31, 50.92, 50.55, 50.19, 49.83, 49.49, 49.16, 48.84, 48.53, 48.22, 47.92, 47.63, 47.34, 47.06, 46.78, 46.51, 46.24, 45.98, 45.72, 45.46, 45.2, 44.95, 44.71, 44.46, 44.22, 43.98, 43.74, 43.5, 43.26, 43.03, 42.8, 42.57, 42.34, 42.11, 41.88, 41.65, 41.42, 41.19, 40.96, 40.74, 40.51, 40.28, 40.05, 39.82, 39.59, 39.36, 39.13, 38.89, 38.66, 38.42, 38.18, 37.94, 37.7, 37.45, 37.2, 36.95, 36.7, 36.44, 36.17, 35.9, 35.63, 35.35, 35.07, 34.77, 34.47, 34.16, 33.84, 33.51, 33.17, 32.81, 32.44, 32.04, 31.63, 31.18, 30.7, 30.18, 29.61, 28.96, 28.22, 27.32, 26.16, 24.4], [103.7, 91.87, 78.75, 68.71, 65.34, 63.25, 61.71, 60.48, 59.44, 58.54, 57.75, 57.03, 56.37, 55.76, 55.2, 54.67, 54.17, 53.7, 53.25, 52.82, 52.41, 52.02, 51.64, 51.27, 50.92, 50.57, 50.24, 49.91, 49.6, 49.29, 48.98, 48.69, 48.4, 48.11, 47.83, 47.56, 47.28, 47.02, 46.75, 46.49, 46.24, 45.98, 45.73, 45.49, 45.24, 45.0, 44.75, 44.51, 44.28, 44.04, 43.8, 43.57, 43.34, 43.1, 42.87, 42.64, 42.41, 42.18, 41.95, 41.72, 41.49, 41.25, 41.02, 40.79, 40.56, 40.32, 40.09, 39.85, 39.61, 39.37, 39.13, 38.89, 38.64, 38.39, 38.14, 37.88, 37.63, 37.36, 37.1, 36.82, 36.55, 36.26, 35.97, 35.68, 35.37, 35.06, 34.74, 34.4, 34.05, 33.69, 33.31, 32.91, 32.49, 32.04, 31.55, 31.02, 30.44, 29.79, 29.03, 28.12, 26.94, 25.15], [105.2, 93.29, 80.08, 69.96, 66.56, 64.45, 62.9, 61.66, 60.61, 59.7, 58.9, 58.17, 57.51, 56.89, 56.32, 55.79, 55.29, 54.81, 54.36, 53.92, 53.51, 53.11, 52.73, 52.36, 52.0, 51.65, 51.31, 50.98, 50.66, 50.35, 50.05, 49.75, 49.45, 49.16, 48.88, 48.6, 48.33, 48.06, 47.79, 47.53, 47.27, 47.01, 46.76, 46.51, 46.26, 46.01, 45.77, 45.53, 45.29, 45.05, 44.81, 44.57, 44.34, 44.1, 43.87, 43.63, 43.4, 43.16, 42.93, 42.7, 42.46, 42.23, 42.0, 41.76, 41.52, 41.29, 41.05, 40.81, 40.57, 40.33, 40.08, 39.83, 39.58, 39.33, 39.08, 38.82, 38.56, 38.29, 38.02, 37.75, 37.46, 37.18, 36.88, 36.58, 36.28, 35.96, 35.63, 35.29, 34.94, 34.57, 34.18, 33.78, 33.35, 32.89, 32.4, 31.87, 31.28, 30.61, 29.84, 28.92, 27.72, 25.9], [106.69, 94.71, 81.4, 71.2, 67.77, 65.65, 64.09, 62.83, 61.77, 60.86, 60.04, 59.31, 58.64, 58.02, 57.45, 56.91, 56.4, 55.92, 55.46, 55.03, 54.61, 54.21, 53.82, 53.44, 53.08, 52.73, 52.39, 52.06, 51.73, 51.42, 51.11, 50.8, 50.51, 50.22, 49.93, 49.65, 49.37, 49.1, 48.83, 48.56, 48.3, 48.04, 47.79, 47.53, 47.28, 47.03, 46.79, 46.54, 46.3, 46.05, 45.81, 45.57, 45.34, 45.1, 44.86, 44.62, 44.39, 44.15, 43.91, 43.68, 43.44, 43.21, 42.97, 42.73, 42.49, 42.25, 42.01, 41.77, 41.52, 41.28, 41.03, 40.78, 40.53, 40.27, 40.02, 39.75, 39.49, 39.22, 38.95, 38.67, 38.38, 38.09, 37.8, 37.49, 37.18, 36.86, 36.52, 36.18, 35.82, 35.45, 35.06, 34.65, 34.22, 33.75, 33.25, 32.71, 32.11, 31.44, 30.66, 29.72, 28.5, 26.66], [108.18, 96.12, 82.72, 72.44, 68.99, 66.85, 65.27, 64.0, 62.94, 62.01, 61.19, 60.45, 59.77, 59.15, 58.57, 58.03, 57.51, 57.03, 56.57, 56.13, 55.7, 55.3, 54.91, 54.53, 54.16, 53.81, 53.46, 53.13, 52.8, 52.48, 52.17, 51.86, 51.56, 51.27, 50.98, 50.69, 50.41, 50.14, 49.87, 49.6, 49.33, 49.07, 48.81, 48.56, 48.3, 48.05, 47.8, 47.55, 47.31, 47.06, 46.82, 46.58, 46.34, 46.09, 45.85, 45.62, 45.38, 45.14, 44.9, 44.66, 44.42, 44.18, 43.94, 43.7, 43.46, 43.22, 42.97, 42.73, 42.48, 42.23, 41.98, 41.73, 41.47, 41.22, 40.95, 40.69, 40.42, 40.15, 39.87, 39.59, 39.3, 39.01, 38.71, 38.4, 38.08, 37.76, 37.42, 37.07, 36.71, 36.33, 35.94, 35.52, 35.08, 34.61, 34.11, 33.56, 32.95, 32.27, 31.48, 30.53, 29.29, 27.42], [109.66, 97.53, 84.04, 73.68, 70.2, 68.04, 66.45, 65.17, 64.1, 63.16, 62.34, 61.59, 60.91, 60.28, 59.69, 59.14, 58.63, 58.14, 57.67, 57.22, 56.8, 56.39, 55.99, 55.61, 55.24, 54.88, 54.54, 54.2, 53.87, 53.54, 53.23, 52.92, 52.62, 52.32, 52.03, 51.74, 51.46, 51.18, 50.9, 50.63, 50.37, 50.1, 49.84, 49.58, 49.32, 49.07, 48.82, 48.57, 48.32, 48.07, 47.82, 47.58, 47.34, 47.09, 46.85, 46.61, 46.37, 46.12, 45.88, 45.64, 45.4, 45.16, 44.92, 44.67, 44.43, 44.18, 43.94, 43.69, 43.44, 43.19, 42.93, 42.68, 42.42, 42.16, 41.89, 41.63, 41.36, 41.08, 40.8, 40.51, 40.22, 39.92, 39.62, 39.31, 38.99, 38.66, 38.32, 37.96, 37.6, 37.22, 36.82, 36.4, 35.95, 35.47, 34.96, 34.4, 33.79, 33.1, 32.3, 31.33, 30.08, 28.18], [111.14, 98.93, 85.35, 74.92, 71.41, 69.23, 67.63, 66.34, 65.25, 64.31, 63.48, 62.73, 62.04, 61.4, 60.81, 60.26, 59.74, 59.24, 58.77, 58.32, 57.89, 57.48, 57.08, 56.69, 56.32, 55.96, 55.61, 55.27, 54.93, 54.61, 54.29, 53.98, 53.67, 53.37, 53.07, 52.79, 52.5, 52.22, 51.94, 51.67, 51.4, 51.13, 50.87, 50.6, 50.34, 50.09, 49.83, 49.58, 49.33, 49.08, 48.83, 48.58, 48.33, 48.09, 47.84, 47.6, 47.36, 47.11, 46.87, 46.62, 46.38, 46.13, 45.89, 45.64, 45.4, 45.15, 44.9, 44.65, 44.4, 44.14, 43.89, 43.63, 43.37, 43.1, 42.83, 42.56, 42.29, 42.01, 41.73, 41.44, 41.14, 40.84, 40.53, 40.22, 39.89, 39.56, 39.22, 38.86, 38.49, 38.1, 37.7, 37.27, 36.82, 36.34, 35.82, 35.25, 34.63, 33.93, 33.12, 32.14, 30.87, 28.94], [112.61, 100.33, 86.66, 76.15, 72.61, 70.42, 68.8, 67.5, 66.41, 65.46, 64.62, 63.86, 63.17, 62.53, 61.93, 61.37, 60.84, 60.35, 59.87, 59.42, 58.98, 58.57, 58.16, 57.78, 57.4, 57.03, 56.68, 56.33, 56.0, 55.67, 55.35, 55.03, 54.72, 54.42, 54.12, 53.83, 53.54, 53.26, 52.98, 52.7, 52.43, 52.16, 51.89, 51.63, 51.37, 51.11, 50.85, 50.59, 50.34, 50.09, 49.83, 49.58, 49.33, 49.09, 48.84, 48.59, 48.35, 48.1, 47.85, 47.61, 47.36, 47.11, 46.86, 46.62, 46.37, 46.12, 45.86, 45.61, 45.35, 45.1, 44.84, 44.58, 44.31, 44.05, 43.78, 43.5, 43.22, 42.94, 42.66, 42.36, 42.07, 41.76, 41.45, 41.13, 40.8, 40.46, 40.12, 39.75, 39.38, 38.99, 38.58, 38.15, 37.69, 37.2, 36.68, 36.11, 35.47, 34.76, 33.94, 32.95, 31.66, 29.71], [114.08, 101.73, 87.97, 77.39, 73.82, 71.61, 69.98, 68.67, 67.57, 66.61, 65.76, 65.0, 64.3, 63.65, 63.05, 62.48, 61.95, 61.45, 60.97, 60.51, 60.08, 59.65, 59.25, 58.86, 58.48, 58.11, 57.75, 57.4, 57.06, 56.73, 56.4, 56.09, 55.78, 55.47, 55.17, 54.87, 54.58, 54.3, 54.01, 53.73, 53.46, 53.19, 52.92, 52.65, 52.39, 52.12, 51.86, 51.6, 51.35, 51.09, 50.84, 50.59, 50.33, 50.08, 49.83, 49.58, 49.34, 49.09, 48.84, 48.59, 48.34, 48.09, 47.84, 47.59, 47.34, 47.08, 46.83, 46.57, 46.31, 46.05, 45.79, 45.53, 45.26, 44.99, 44.72, 44.44, 44.16, 43.87, 43.58, 43.29, 42.99, 42.68, 42.36, 42.04, 41.71, 41.37, 41.02, 40.65, 40.27, 39.87, 39.46, 39.02, 38.56, 38.07, 37.54, 36.96, 36.32, 35.6, 34.77, 33.76, 32.46, 30.48], [115.54, 103.12, 89.27, 78.62, 75.02, 72.8, 71.15, 69.83, 68.72, 67.76, 66.9, 66.13, 65.42, 64.77, 64.16, 63.6, 63.06, 62.55, 62.07, 61.61, 61.17, 60.74, 60.33, 59.94, 59.55, 59.18, 58.82, 58.47, 58.13, 57.79, 57.46, 57.14, 56.83, 56.52, 56.22, 55.92, 55.62, 55.33, 55.05, 54.77, 54.49, 54.21, 53.94, 53.67, 53.41, 53.14, 52.88, 52.62, 52.36, 52.1, 51.84, 51.59, 51.33, 51.08, 50.83, 50.58, 50.33, 50.07, 49.82, 49.57, 49.32, 49.07, 48.81, 48.56, 48.3, 48.05, 47.79, 47.53, 47.27, 47.01, 46.75, 46.48, 46.21, 45.94, 45.66, 45.38, 45.1, 44.81, 44.51, 44.22, 43.91, 43.6, 43.28, 42.95, 42.62, 42.27, 41.92, 41.55, 41.16, 40.76, 40.34, 39.9, 39.43, 38.93, 38.4, 37.81, 37.16, 36.44, 35.59, 34.58, 33.26, 31.25], [117.0, 104.5, 90.57, 79.84, 76.22, 73.98, 72.32, 70.99, 69.87, 68.9, 68.04, 67.26, 66.55, 65.89, 65.28, 64.71, 64.17, 63.65, 63.17, 62.7, 62.26, 61.83, 61.41, 61.02, 60.63, 60.25, 59.89, 59.53, 59.19, 58.85, 58.52, 58.2, 57.88, 57.57, 57.26, 56.96, 56.66, 56.37, 56.08, 55.8, 55.52, 55.24, 54.97, 54.69, 54.43, 54.16, 53.89, 53.63, 53.37, 53.11, 52.85, 52.59, 52.33, 52.08, 51.82, 51.57, 51.32, 51.06, 50.81, 50.55, 50.3, 50.04, 49.79, 49.53, 49.27, 49.02, 48.76, 48.5, 48.23, 47.97, 47.7, 47.43, 47.16, 46.88, 46.6, 46.32, 46.03, 45.74, 45.44, 45.14, 44.84, 44.52, 44.2, 43.87, 43.53, 43.18, 42.82, 42.45, 42.06, 41.65, 41.23, 40.78, 40.31, 39.8, 39.26, 38.67, 38.01, 37.28, 36.42, 35.39, 34.06, 32.02], [118.45, 105.89, 91.87, 81.07, 77.42, 75.16, 73.49, 72.15, 71.02, 70.04, 69.18, 68.39, 67.67, 67.01, 66.39, 65.82, 65.27, 64.76, 64.26, 63.79, 63.35, 62.91, 62.5, 62.09, 61.7, 61.33, 60.96, 60.6, 60.25, 59.91, 59.58, 59.25, 58.93, 58.62, 58.31, 58.0, 57.7, 57.41, 57.12, 56.83, 56.55, 56.27, 55.99, 55.72, 55.45, 55.18, 54.91, 54.64, 54.38, 54.12, 53.85, 53.59, 53.33, 53.08, 52.82, 52.56, 52.31, 52.05, 51.79, 51.54, 51.28, 51.02, 50.76, 50.5, 50.24, 49.98, 49.72, 49.46, 49.19, 48.92, 48.65, 48.38, 48.11, 47.83, 47.55, 47.26, 46.97, 46.68, 46.38, 46.07, 45.76, 45.44, 45.12, 44.78, 44.44, 44.09, 43.72, 43.34, 42.95, 42.54, 42.11, 41.66, 41.18, 40.67, 40.12, 39.52, 38.86, 38.12, 37.25, 36.21, 34.86, 32.79], [119.9, 107.27, 93.17, 82.29, 78.62, 76.34, 74.66, 73.31, 72.17, 71.19, 70.31, 69.52, 68.8, 68.13, 67.51, 66.92, 66.38, 65.86, 65.36, 64.89, 64.43, 64.0, 63.58, 63.17, 62.78, 62.4, 62.03, 61.66, 61.31, 60.97, 60.63, 60.3, 59.98, 59.66, 59.35, 59.05, 58.74, 58.45, 58.15, 57.86, 57.58, 57.3, 57.02, 56.74, 56.46, 56.19, 55.92, 55.65, 55.39, 55.12, 54.86, 54.6, 54.33, 54.07, 53.81, 53.55, 53.3, 53.04, 52.78, 52.52, 52.26, 52.0, 51.74, 51.48, 51.22, 50.95, 50.69, 50.42, 50.15, 49.88, 49.61, 49.33, 49.06, 48.77, 48.49, 48.2, 47.91, 47.61, 47.31, 47.0, 46.69, 46.36, 46.04, 45.7, 45.35, 45.0, 44.63, 44.24, 43.85, 43.43, 43.0, 42.54, 42.06, 41.54, 40.99, 40.38, 39.71, 38.96, 38.08, 37.03, 35.66, 33.57], [121.35, 108.65, 94.46, 83.51, 79.81, 77.52, 75.83, 74.47, 73.32, 72.33, 71.44, 70.65, 69.92, 69.25, 68.62, 68.03, 67.48, 66.95, 66.45, 65.98, 65.52, 65.08, 64.66, 64.25, 63.85, 63.47, 63.09, 62.73, 62.37, 62.03, 61.69, 61.36, 61.03, 60.71, 60.4, 60.09, 59.78, 59.48, 59.19, 58.9, 58.61, 58.32, 58.04, 57.76, 57.48, 57.21, 56.94, 56.67, 56.4, 56.13, 55.86, 55.6, 55.33, 55.07, 54.81, 54.55, 54.29, 54.02, 53.76, 53.5, 53.24, 52.98, 52.71, 52.45, 52.19, 51.92, 51.65, 51.38, 51.11, 50.84, 50.56, 50.29, 50.01, 49.72, 49.43, 49.14, 48.85, 48.55, 48.24, 47.93, 47.61, 47.29, 46.96, 46.61, 46.26, 45.9, 45.53, 45.15, 44.74, 44.33, 43.89, 43.43, 42.94, 42.42, 41.85, 41.24, 40.56, 39.8, 38.92, 37.85, 36.46, 34.35], [122.79, 110.02, 95.75, 84.73, 81.01, 78.7, 76.99, 75.62, 74.47, 73.47, 72.58, 71.77, 71.04, 70.36, 69.73, 69.14, 68.58, 68.05, 67.55, 67.07, 66.61, 66.16, 65.74, 65.32, 64.93, 64.54, 64.16, 63.79, 63.44, 63.09, 62.74, 62.41, 62.08, 61.76, 61.44, 61.13, 60.82, 60.52, 60.22, 59.93, 59.64, 59.35, 59.06, 58.78, 58.5, 58.23, 57.95, 57.68, 57.41, 57.14, 56.87, 56.6, 56.33, 56.07, 55.8, 55.54, 55.28, 55.01, 54.75, 54.49, 54.22, 53.96, 53.69, 53.42, 53.16, 52.89, 52.62, 52.35, 52.07, 51.8, 51.52, 51.24, 50.96, 50.67, 50.38, 50.08, 49.79, 49.48, 49.17, 48.86, 48.54, 48.21, 47.88, 47.53, 47.18, 46.81, 46.44, 46.05, 45.64, 45.22, 44.78, 44.31, 43.82, 43.29, 42.72, 42.1, 41.42, 40.65, 39.75, 38.67, 37.27, 35.13], [124.23, 111.39, 97.04, 85.95, 82.2, 79.88, 78.16, 76.78, 75.62, 74.61, 73.71, 72.9, 72.16, 71.48, 70.84, 70.24, 69.68, 69.15, 68.64, 68.16, 67.69, 67.25, 66.82, 66.4, 66.0, 65.61, 65.23, 64.86, 64.5, 64.14, 63.8, 63.46, 63.13, 62.8, 62.48, 62.17, 61.86, 61.56, 61.26, 60.96, 60.67, 60.38, 60.09, 59.8, 59.52, 59.24, 58.96, 58.69, 58.42, 58.14, 57.87, 57.6, 57.33, 57.07, 56.8, 56.53, 56.27, 56.0, 55.73, 55.47, 55.2, 54.93, 54.67, 54.4, 54.13, 53.86, 53.59, 53.31, 53.03, 52.76, 52.48, 52.19, 51.91, 51.62, 51.32, 51.03, 50.73, 50.42, 50.11, 49.79, 49.47, 49.14, 48.8, 48.45, 48.09, 47.72, 47.34, 46.95, 46.54, 46.11, 45.67, 45.2, 44.7, 44.16, 43.59, 42.96, 42.27, 41.49, 40.59, 39.5, 38.08, 35.91], [125.66, 112.76, 98.32, 87.17, 83.39, 81.05, 79.32, 77.93, 76.76, 75.74, 74.84, 74.02, 73.28, 72.59, 71.95, 71.35, 70.78, 70.25, 69.73, 69.25, 68.78, 68.33, 67.89, 67.48, 67.07, 66.68, 66.29, 65.92, 65.56, 65.2, 64.85, 64.51, 64.18, 63.85, 63.53, 63.21, 62.9, 62.59, 62.29, 61.99, 61.69, 61.4, 61.11, 60.82, 60.54, 60.26, 59.98, 59.7, 59.43, 59.15, 58.88, 58.61, 58.33, 58.06, 57.8, 57.53, 57.26, 56.99, 56.72, 56.45, 56.18, 55.91, 55.64, 55.37, 55.1, 54.83, 54.55, 54.27, 54.0, 53.72, 53.43, 53.15, 52.86, 52.57, 52.27, 51.97, 51.67, 51.36, 51.04, 50.72, 50.39, 50.06, 49.72, 49.37, 49.01, 48.64, 48.25, 47.85, 47.44, 47.01, 46.56, 46.08, 45.58, 45.04, 44.46, 43.83, 43.13, 42.34, 41.43, 40.32, 38.89, 36.7], [127.1, 114.12, 99.61, 88.38, 84.58, 82.23, 80.48, 79.08, 77.9, 76.88, 75.97, 75.15, 74.4, 73.7, 73.06, 72.45, 71.88, 71.34, 70.83, 70.33, 69.86, 69.41, 68.97, 68.55, 68.14, 67.74, 67.36, 66.98, 66.61, 66.26, 65.91, 65.56, 65.23, 64.9, 64.57, 64.25, 63.94, 63.63, 63.32, 63.02, 62.72, 62.43, 62.13, 61.85, 61.56, 61.27, 60.99, 60.71, 60.43, 60.16, 59.88, 59.61, 59.33, 59.06, 58.79, 58.52, 58.25, 57.98, 57.71, 57.44, 57.16, 56.89, 56.62, 56.35, 56.07, 55.8, 55.52, 55.24, 54.96, 54.67, 54.39, 54.1, 53.81, 53.51, 53.22, 52.91, 52.61, 52.29, 51.98, 51.65, 51.32, 50.99, 50.64, 50.29, 49.92, 49.55, 49.16, 48.76, 48.34, 47.91, 47.45, 46.97, 46.46, 45.91, 45.33, 44.69, 43.98, 43.19, 42.27, 41.15, 39.7, 37.48], [128.52, 115.49, 100.89, 89.59, 85.77, 83.4, 81.64, 80.23, 79.04, 78.01, 77.1, 76.27, 75.51, 74.82, 74.17, 73.56, 72.98, 72.44, 71.92, 71.42, 70.95, 70.49, 70.05, 69.62, 69.21, 68.81, 68.42, 68.04, 67.67, 67.31, 66.96, 66.61, 66.27, 65.94, 65.61, 65.29, 64.98, 64.66, 64.35, 64.05, 63.75, 63.45, 63.16, 62.87, 62.58, 62.29, 62.01, 61.72, 61.44, 61.16, 60.89, 60.61, 60.33, 60.06, 59.79, 59.51, 59.24, 58.97, 58.69, 58.42, 58.15, 57.87, 57.6, 57.32, 57.04, 56.77, 56.49, 56.2, 55.92, 55.63, 55.35, 55.06, 54.76, 54.46, 54.16, 53.86, 53.55, 53.23, 52.91, 52.59, 52.25, 51.91, 51.56, 51.21, 50.84, 50.46, 50.07, 49.66, 49.24, 48.8, 48.34, 47.86, 47.34, 46.79, 46.2, 45.56, 44.84, 44.04, 43.11, 41.98, 40.51, 38.27], [129.95, 116.85, 102.17, 90.8, 86.95, 84.57, 82.8, 81.38, 80.19, 79.15, 78.22, 77.39, 76.63, 75.93, 75.27, 74.66, 74.08, 73.53, 73.01, 72.51, 72.03, 71.57, 71.13, 70.7, 70.28, 69.88, 69.49, 69.1, 68.73, 68.37, 68.01, 67.66, 67.32, 66.99, 66.66, 66.33, 66.01, 65.7, 65.39, 65.08, 64.78, 64.48, 64.18, 63.89, 63.6, 63.31, 63.02, 62.74, 62.45, 62.17, 61.89, 61.61, 61.33, 61.06, 60.78, 60.51, 60.23, 59.95, 59.68, 59.4, 59.13, 58.85, 58.57, 58.3, 58.02, 57.74, 57.45, 57.17, 56.88, 56.59, 56.3, 56.01, 55.71, 55.41, 55.11, 54.8, 54.49, 54.17, 53.85, 53.52, 53.18, 52.84, 52.49, 52.13, 51.76, 51.37, 50.98, 50.57, 50.14, 49.7, 49.24, 48.75, 48.23, 47.67, 47.07, 46.42, 45.7, 44.89, 43.95, 42.81, 41.33, 39.06], [131.37, 118.2, 103.44, 92.01, 88.14, 85.74, 83.96, 82.53, 81.33, 80.28, 79.35, 78.51, 77.75, 77.04, 76.38, 75.76, 75.18, 74.62, 74.1, 73.59, 73.11, 72.65, 72.2, 71.77, 71.35, 70.94, 70.55, 70.16, 69.79, 69.42, 69.06, 68.71, 68.37, 68.03, 67.7, 67.37, 67.05, 66.73, 66.42, 66.11, 65.8, 65.5, 65.2, 64.91, 64.61, 64.32, 64.03, 63.75, 63.46, 63.18, 62.9, 62.61, 62.33, 62.06, 61.78, 61.5, 61.22, 60.94, 60.67, 60.39, 60.11, 59.83, 59.55, 59.27, 58.99, 58.71, 58.42, 58.13, 57.85, 57.56, 57.26, 56.97, 56.67, 56.36, 56.06, 55.75, 55.43, 55.11, 54.78, 54.45, 54.11, 53.77, 53.41, 53.05, 52.67, 52.29, 51.89, 51.48, 51.05, 50.6, 50.13, 49.64, 49.11, 48.55, 47.95, 47.29, 46.56, 45.74, 44.79, 43.64, 42.14, 39.86], [132.79, 119.55, 104.72, 93.22, 89.32, 86.9, 85.11, 83.68, 82.46, 81.41, 80.48, 79.63, 78.86, 78.15, 77.48, 76.86, 76.27, 75.72, 75.19, 74.68, 74.19, 73.73, 73.28, 72.84, 72.42, 72.01, 71.61, 71.23, 70.85, 70.48, 70.12, 69.76, 69.42, 69.08, 68.74, 68.41, 68.09, 67.77, 67.45, 67.14, 66.83, 66.53, 66.23, 65.93, 65.63, 65.34, 65.05, 64.76, 64.47, 64.18, 63.9, 63.62, 63.33, 63.05, 62.77, 62.49, 62.21, 61.93, 61.65, 61.37, 61.09, 60.81, 60.53, 60.25, 59.96, 59.68, 59.39, 59.1, 58.81, 58.52, 58.22, 57.92, 57.62, 57.31, 57.0, 56.69, 56.37, 56.05, 55.72, 55.39, 55.04, 54.69, 54.34, 53.97, 53.59, 53.2, 52.8, 52.38, 51.95, 51.5, 51.03, 50.53, 50.0, 49.43, 48.82, 48.16, 47.42, 46.59, 45.63, 44.47, 42.96, 40.65], [134.2, 120.9, 105.99, 94.42, 90.5, 88.07, 86.27, 84.82, 83.6, 82.54, 81.6, 80.75, 79.97, 79.26, 78.59, 77.96, 77.37, 76.81, 76.27, 75.76, 75.27, 74.8, 74.35, 73.91, 73.49, 73.08, 72.68, 72.28, 71.9, 71.53, 71.17, 70.81, 70.46, 70.12, 69.78, 69.45, 69.12, 68.8, 68.48, 68.17, 67.86, 67.55, 67.25, 66.95, 66.65, 66.35, 66.06, 65.77, 65.48, 65.19, 64.9, 64.62, 64.33, 64.05, 63.77, 63.49, 63.2, 62.92, 62.64, 62.36, 62.07, 61.79, 61.51, 61.22, 60.93, 60.65, 60.36, 60.07, 59.77, 59.48, 59.18, 58.88, 58.57, 58.27, 57.95, 57.64, 57.32, 56.99, 56.66, 56.32, 55.98, 55.62, 55.26, 54.89, 54.51, 54.12, 53.71, 53.29, 52.86, 52.4, 51.92, 51.42, 50.88, 50.31, 49.7, 49.03, 48.29, 47.45, 46.48, 45.31, 43.78, 41.44], [135.61, 122.25, 107.26, 95.63, 91.68, 89.23, 87.42, 85.96, 84.74, 83.67, 82.72, 81.87, 81.09, 80.36, 79.69, 79.06, 78.46, 77.9, 77.36, 76.85, 76.35, 75.88, 75.42, 74.98, 74.56, 74.14, 73.74, 73.34, 72.96, 72.59, 72.22, 71.86, 71.51, 71.16, 70.82, 70.49, 70.16, 69.83, 69.51, 69.2, 68.89, 68.58, 68.27, 67.97, 67.67, 67.37, 67.07, 66.78, 66.49, 66.2, 65.91, 65.62, 65.33, 65.05, 64.76, 64.48, 64.19, 63.91, 63.63, 63.34, 63.06, 62.77, 62.48, 62.2, 61.91, 61.62, 61.33, 61.03, 60.74, 60.44, 60.14, 59.83, 59.53, 59.22, 58.9, 58.58, 58.26, 57.93, 57.6, 57.26, 56.91, 56.55, 56.19, 55.81, 55.43, 55.03, 54.63, 54.2, 53.76, 53.3, 52.82, 52.31, 51.77, 51.19, 50.57, 49.9, 49.15, 48.31, 47.33, 46.14, 44.6, 42.24], [137.02, 123.6, 108.53, 96.83, 92.86, 90.4, 88.57, 87.11, 85.87, 84.8, 83.85, 82.98, 82.2, 81.47, 80.79, 80.16, 79.56, 78.99, 78.45, 77.93, 77.43, 76.96, 76.5, 76.05, 75.62, 75.21, 74.8, 74.4, 74.02, 73.64, 73.27, 72.91, 72.55, 72.21, 71.86, 71.53, 71.2, 70.87, 70.55, 70.23, 69.91, 69.6, 69.29, 68.99, 68.69, 68.39, 68.09, 67.79, 67.5, 67.2, 66.91, 66.62, 66.33, 66.05, 65.76, 65.47, 65.19, 64.9, 64.61, 64.33, 64.04, 63.75, 63.46, 63.17, 62.88, 62.59, 62.29, 62.0, 61.7, 61.4, 61.1, 60.79, 60.48, 60.17, 59.85, 59.53, 59.2, 58.87, 58.53, 58.19, 57.84, 57.48, 57.11, 56.74, 56.35, 55.95, 55.54, 55.11, 54.67, 54.2, 53.72, 53.2, 52.66, 52.08, 51.45, 50.77, 50.01, 49.16, 48.17, 46.98, 45.42, 43.04], [138.43, 124.94, 109.79, 98.03, 94.04, 91.56, 89.73, 88.25, 87.01, 85.93, 84.97, 84.1, 83.31, 82.58, 81.89, 81.25, 80.65, 80.08, 79.53, 79.01, 78.51, 78.03, 77.57, 77.12, 76.69, 76.27, 75.86, 75.46, 75.07, 74.69, 74.32, 73.96, 73.6, 73.25, 72.9, 72.57, 72.23, 71.9, 71.58, 71.26, 70.94, 70.63, 70.32, 70.01, 69.7, 69.4, 69.1, 68.8, 68.51, 68.21, 67.92, 67.63, 67.33, 67.04, 66.75, 66.47, 66.18, 65.89, 65.6, 65.31, 65.02, 64.73, 64.44, 64.15, 63.85, 63.56, 63.26, 62.97, 62.66, 62.36, 62.06, 61.75, 61.44, 61.12, 60.8, 60.48, 60.15, 59.81, 59.47, 59.13, 58.77, 58.41, 58.04, 57.66, 57.27, 56.87, 56.45, 56.02, 55.57, 55.11, 54.61, 54.1, 53.55, 52.96, 52.33, 51.64, 50.88, 50.02, 49.02, 47.82, 46.24, 43.84], [139.83, 126.28, 111.06, 99.23, 95.21, 92.72, 90.88, 89.39, 88.14, 87.05, 86.09, 85.22, 84.42, 83.68, 82.99, 82.35, 81.74, 81.17, 80.62, 80.09, 79.59, 79.11, 78.64, 78.19, 77.76, 77.33, 76.92, 76.52, 76.13, 75.75, 75.37, 75.0, 74.64, 74.29, 73.94, 73.6, 73.27, 72.93, 72.61, 72.28, 71.97, 71.65, 71.34, 71.03, 70.72, 70.42, 70.11, 69.81, 69.51, 69.22, 68.92, 68.63, 68.33, 68.04, 67.75, 67.46, 67.17, 66.88, 66.59, 66.29, 66.0, 65.71, 65.42, 65.12, 64.83, 64.53, 64.23, 63.93, 63.63, 63.32, 63.02, 62.71, 62.39, 62.07, 61.75, 61.42, 61.09, 60.76, 60.41, 60.06, 59.71, 59.34, 58.97, 58.59, 58.19, 57.79, 57.37, 56.93, 56.48, 56.01, 55.51, 54.99, 54.44, 53.85, 53.21, 52.51, 51.75, 50.88, 49.87, 48.66, 47.07, 44.64], [141.23, 127.62, 112.32, 100.43, 96.39, 93.88, 92.02, 90.53, 89.27, 88.18, 87.21, 86.33, 85.53, 84.79, 84.09, 83.45, 82.83, 82.26, 81.7, 81.18, 80.67, 80.18, 79.71, 79.26, 78.82, 78.4, 77.98, 77.58, 77.18, 76.8, 76.42, 76.05, 75.69, 75.33, 74.98, 74.64, 74.3, 73.97, 73.64, 73.31, 72.99, 72.67, 72.36, 72.05, 71.74, 71.43, 71.13, 70.82, 70.52, 70.22, 69.93, 69.63, 69.33, 69.04, 68.75, 68.45, 68.16, 67.87, 67.57, 67.28, 66.99, 66.69, 66.4, 66.1, 65.8, 65.5, 65.2, 64.9, 64.59, 64.29, 63.98, 63.66, 63.35, 63.03, 62.7, 62.37, 62.04, 61.7, 61.35, 61.0, 60.64, 60.27, 59.9, 59.51, 59.11, 58.71, 58.28, 57.84, 57.39, 56.91, 56.41, 55.89, 55.33, 54.73, 54.09, 53.39, 52.61, 51.74, 50.72, 49.5, 47.89, 45.44], [142.63, 128.95, 113.58, 101.62, 97.56, 95.04, 93.17, 91.67, 90.4, 89.3, 88.33, 87.44, 86.64, 85.89, 85.19, 84.54, 83.93, 83.34, 82.79, 82.26, 81.75, 81.26, 80.79, 80.33, 79.89, 79.46, 79.04, 78.63, 78.24, 77.85, 77.47, 77.1, 76.73, 76.38, 76.02, 75.68, 75.34, 75.0, 74.67, 74.34, 74.02, 73.7, 73.38, 73.07, 72.75, 72.45, 72.14, 71.83, 71.53, 71.23, 70.93, 70.63, 70.33, 70.04, 69.74, 69.45, 69.15, 68.86, 68.56, 68.26, 67.97, 67.67, 67.37, 67.08, 66.78, 66.47, 66.17, 65.87, 65.56, 65.25, 64.94, 64.62, 64.3, 63.98, 63.65, 63.32, 62.98, 62.64, 62.29, 61.94, 61.58, 61.21, 60.83, 60.44, 60.04, 59.62, 59.2, 58.76, 58.3, 57.82, 57.31, 56.78, 56.22, 55.62, 54.97, 54.26, 53.48, 52.6, 51.58, 50.34, 48.72, 46.25], [144.02, 130.29, 114.84, 102.82, 98.73, 96.2, 94.32, 92.81, 91.54, 90.43, 89.44, 88.56, 87.74, 86.99, 86.29, 85.64, 85.02, 84.43, 83.87, 83.34, 82.82, 82.33, 81.86, 81.4, 80.95, 80.52, 80.1, 79.69, 79.29, 78.9, 78.52, 78.14, 77.78, 77.42, 77.06, 76.71, 76.37, 76.03, 75.7, 75.37, 75.04, 74.72, 74.4, 74.08, 73.77, 73.46, 73.15, 72.84, 72.54, 72.24, 71.93, 71.63, 71.33, 71.04, 70.74, 70.44, 70.14, 69.85, 69.55, 69.25, 68.95, 68.65, 68.35, 68.05, 67.75, 67.45, 67.14, 66.83, 66.52, 66.21, 65.9, 65.58, 65.26, 64.93, 64.6, 64.27, 63.93, 63.58, 63.23, 62.88, 62.51, 62.14, 61.76, 61.36, 60.96, 60.54, 60.11, 59.67, 59.21, 58.72, 58.22, 57.68, 57.11, 56.51, 55.85, 55.14, 54.35, 53.46, 52.43, 51.18, 49.55, 47.05], [145.41, 131.62, 116.09, 104.01, 99.9, 97.35, 95.46, 93.95, 92.66, 91.55, 90.56, 89.67, 88.85, 88.09, 87.39, 86.73, 86.11, 85.52, 84.95, 84.42, 83.9, 83.41, 82.93, 82.46, 82.02, 81.58, 81.16, 80.75, 80.34, 79.95, 79.57, 79.19, 78.82, 78.46, 78.1, 77.75, 77.41, 77.06, 76.73, 76.4, 76.07, 75.74, 75.42, 75.1, 74.79, 74.47, 74.16, 73.86, 73.55, 73.24, 72.94, 72.64, 72.33, 72.03, 71.73, 71.43, 71.13, 70.83, 70.54, 70.24, 69.94, 69.63, 69.33, 69.03, 68.72, 68.42, 68.11, 67.8, 67.49, 67.18, 66.86, 66.54, 66.21, 65.89, 65.55, 65.22, 64.88, 64.53, 64.17, 63.81, 63.45, 63.07, 62.69, 62.29, 61.88, 61.47, 61.03, 60.58, 60.12, 59.63, 59.12, 58.58, 58.01, 57.4, 56.74, 56.02, 55.22, 54.33, 53.28, 52.02, 50.38, 47.86], [146.8, 132.94, 117.35, 105.2, 101.07, 98.51, 96.61, 95.08, 93.79, 92.67, 91.68, 90.78, 89.96, 89.2, 88.49, 87.82, 87.2, 86.6, 86.04, 85.5, 84.98, 84.48, 84.0, 83.53, 83.08, 82.64, 82.22, 81.8, 81.4, 81.0, 80.62, 80.24, 79.86, 79.5, 79.14, 78.79, 78.44, 78.1, 77.76, 77.42, 77.09, 76.77, 76.44, 76.12, 75.8, 75.49, 75.18, 74.87, 74.56, 74.25, 73.94, 73.64, 73.33, 73.03, 72.73, 72.43, 72.13, 71.82, 71.52, 71.22, 70.92, 70.62, 70.31, 70.01, 69.7, 69.39, 69.08, 68.77, 68.46, 68.14, 67.82, 67.5, 67.17, 66.84, 66.51, 66.17, 65.82, 65.47, 65.12, 64.75, 64.38, 64.0, 63.62, 63.22, 62.81, 62.39, 61.95, 61.5, 61.03, 60.54, 60.02, 59.48, 58.9, 58.28, 57.62, 56.9, 56.09, 55.19, 54.14, 52.87, 51.21, 48.67], [148.19, 134.27, 118.6, 106.39, 102.24, 99.66, 97.75, 96.22, 94.92, 93.79, 92.79, 91.89, 91.06, 90.3, 89.58, 88.92, 88.29, 87.69, 87.12, 86.57, 86.05, 85.55, 85.07, 84.6, 84.14, 83.7, 83.28, 82.86, 82.45, 82.05, 81.66, 81.28, 80.91, 80.54, 80.18, 79.82, 79.47, 79.13, 78.79, 78.45, 78.12, 77.79, 77.46, 77.14, 76.82, 76.5, 76.19, 75.88, 75.56, 75.26, 74.95, 74.64, 74.33, 74.03, 73.73, 73.42, 73.12, 72.81, 72.51, 72.21, 71.9, 71.6, 71.29, 70.98, 70.67, 70.36, 70.05, 69.74, 69.42, 69.1, 68.78, 68.46, 68.13, 67.79, 67.46, 67.12, 66.77, 66.42, 66.06, 65.69, 65.32, 64.94, 64.55, 64.15, 63.73, 63.31, 62.87, 62.41, 61.94, 61.44, 60.92, 60.38, 59.79, 59.17, 58.5, 57.77, 56.97, 56.05, 55.0, 53.71, 52.04, 49.48], [149.57, 135.6, 119.85, 107.58, 103.41, 100.82, 98.9, 97.35, 96.05, 94.92, 93.91, 93.0, 92.17, 91.4, 90.68, 90.01, 89.37, 88.77, 88.2, 87.65, 87.13, 86.62, 86.13, 85.66, 85.21, 84.76, 84.33, 83.91, 83.5, 83.1, 82.71, 82.33, 81.95, 81.58, 81.22, 80.86, 80.51, 80.16, 79.82, 79.48, 79.14, 78.81, 78.48, 78.16, 77.84, 77.52, 77.2, 76.89, 76.57, 76.26, 75.95, 75.64, 75.33, 75.03, 74.72, 74.41, 74.11, 73.8, 73.5, 73.19, 72.89, 72.58, 72.27, 71.96, 71.65, 71.34, 71.02, 70.71, 70.39, 70.07, 69.74, 69.42, 69.08, 68.75, 68.41, 68.07, 67.72, 67.36, 67.0, 66.63, 66.26, 65.87, 65.48, 65.07, 64.66, 64.23, 63.79, 63.33, 62.85, 62.35, 61.83, 61.28, 60.69, 60.06, 59.39, 58.65, 57.84, 56.92, 55.85, 54.56, 52.87, 50.29], [150.95, 136.92, 121.1, 108.77, 104.58, 101.97, 100.04, 98.48, 97.17, 96.03, 95.02, 94.11, 93.27, 92.5, 91.78, 91.1, 90.46, 89.86, 89.28, 88.73, 88.2, 87.69, 87.2, 86.73, 86.27, 85.82, 85.39, 84.97, 84.56, 84.15, 83.76, 83.37, 82.99, 82.62, 82.26, 81.9, 81.54, 81.19, 80.85, 80.51, 80.17, 79.84, 79.51, 79.18, 78.85, 78.53, 78.21, 77.9, 77.58, 77.27, 76.96, 76.64, 76.33, 76.03, 75.72, 75.41, 75.1, 74.79, 74.49, 74.18, 73.87, 73.56, 73.25, 72.94, 72.62, 72.31, 71.99, 71.68, 71.35, 71.03, 70.7, 70.37, 70.04, 69.7, 69.36, 69.02, 68.66, 68.31, 67.94, 67.57, 67.19, 66.81, 66.41, 66.0, 65.58, 65.15, 64.71, 64.24, 63.76, 63.26, 62.73, 62.18, 61.59, 60.96, 60.28, 59.53, 58.71, 57.79, 56.71, 55.41, 53.71, 51.1], [152.33, 138.24, 122.35, 109.96, 105.74, 103.12, 101.18, 99.62, 98.3, 97.15, 96.14, 95.22, 94.37, 93.6, 92.87, 92.19, 91.55, 90.94, 90.36, 89.81, 89.28, 88.76, 88.27, 87.79, 87.33, 86.88, 86.45, 86.02, 85.61, 85.2, 84.81, 84.42, 84.04, 83.66, 83.29, 82.93, 82.57, 82.22, 81.88, 81.53, 81.19, 80.86, 80.53, 80.2, 79.87, 79.55, 79.23, 78.91, 78.59, 78.27, 77.96, 77.65, 77.33, 77.02, 76.71, 76.4, 76.09, 75.78, 75.47, 75.16, 74.85, 74.54, 74.23, 73.91, 73.6, 73.28, 72.96, 72.64, 72.32, 72.0, 71.67, 71.33, 71.0, 70.66, 70.32, 69.97, 69.61, 69.25, 68.89, 68.51, 68.13, 67.74, 67.34, 66.93, 66.51, 66.07, 65.63, 65.16, 64.67, 64.17, 63.64, 63.08, 62.48, 61.85, 61.16, 60.42, 59.59, 58.65, 57.57, 56.26, 54.54, 51.91], [153.71, 139.55, 123.59, 111.14, 106.91, 104.27, 102.32, 100.75, 99.42, 98.27, 97.25, 96.32, 95.48, 94.69, 93.96, 93.28, 92.64, 92.02, 91.44, 90.88, 90.35, 89.83, 89.34, 88.86, 88.39, 87.94, 87.5, 87.08, 86.66, 86.25, 85.85, 85.46, 85.08, 84.7, 84.33, 83.97, 83.61, 83.25, 82.9, 82.56, 82.22, 81.88, 81.55, 81.22, 80.89, 80.56, 80.24, 79.92, 79.6, 79.28, 78.96, 78.65, 78.33, 78.02, 77.71, 77.4, 77.08, 76.77, 76.46, 76.15, 75.84, 75.52, 75.21, 74.89, 74.58, 74.26, 73.94, 73.61, 73.29, 72.96, 72.63, 72.3, 71.96, 71.62, 71.27, 70.92, 70.56, 70.2, 69.83, 69.45, 69.07, 68.68, 68.27, 67.86, 67.44, 67.0, 66.55, 66.08, 65.59, 65.08, 64.54, 63.98, 63.38, 62.74, 62.05, 61.3, 60.46, 59.52, 58.43, 57.1, 55.38, 52.72], [155.08, 140.87, 124.84, 112.33, 108.07, 105.42, 103.46, 101.88, 100.55, 99.39, 98.36, 97.43, 96.58, 95.79, 95.06, 94.37, 93.72, 93.11, 92.52, 91.96, 91.42, 90.9, 90.41, 89.92, 89.46, 89.0, 88.56, 88.13, 87.71, 87.3, 86.9, 86.51, 86.12, 85.74, 85.37, 85.0, 84.64, 84.28, 83.93, 83.59, 83.24, 82.9, 82.57, 82.23, 81.9, 81.58, 81.25, 80.93, 80.61, 80.29, 79.97, 79.65, 79.33, 79.02, 78.7, 78.39, 78.08, 77.76, 77.45, 77.13, 76.82, 76.5, 76.19, 75.87, 75.55, 75.23, 74.91, 74.58, 74.26, 73.93, 73.59, 73.26, 72.92, 72.57, 72.22, 71.87, 71.51, 71.14, 70.77, 70.39, 70.01, 69.61, 69.21, 68.79, 68.36, 67.92, 67.47, 66.99, 66.5, 65.99, 65.45, 64.88, 64.28, 63.63, 62.94, 62.18, 61.34, 60.39, 59.29, 57.96, 56.21, 53.54], [156.45, 142.18, 126.08, 113.51, 109.23, 106.57, 104.6, 103.01, 101.67, 100.51, 99.47, 98.54, 97.68, 96.89, 96.15, 95.46, 94.81, 94.19, 93.6, 93.03, 92.49, 91.97, 91.47, 90.99, 90.52, 90.06, 89.62, 89.18, 88.76, 88.35, 87.95, 87.55, 87.16, 86.78, 86.41, 86.04, 85.67, 85.31, 84.96, 84.61, 84.27, 83.92, 83.59, 83.25, 82.92, 82.59, 82.26, 81.94, 81.61, 81.29, 80.97, 80.65, 80.33, 80.02, 79.7, 79.38, 79.07, 78.75, 78.44, 78.12, 77.8, 77.49, 77.17, 76.85, 76.53, 76.2, 75.88, 75.55, 75.22, 74.89, 74.55, 74.22, 73.87, 73.53, 73.18, 72.82, 72.46, 72.09, 71.72, 71.34, 70.95, 70.55, 70.14, 69.72, 69.29, 68.85, 68.39, 67.91, 67.42, 66.9, 66.36, 65.78, 65.18, 64.53, 63.83, 63.06, 62.22, 61.26, 60.15, 58.81, 57.05, 54.36], [157.82, 143.5, 127.32, 114.69, 110.39, 107.72, 105.73, 104.14, 102.79, 101.62, 100.58, 99.64, 98.78, 97.98, 97.24, 96.55, 95.89, 95.27, 94.68, 94.11, 93.57, 93.04, 92.54, 92.05, 91.58, 91.12, 90.67, 90.24, 89.81, 89.4, 88.99, 88.59, 88.2, 87.82, 87.44, 87.07, 86.71, 86.34, 85.99, 85.64, 85.29, 84.95, 84.61, 84.27, 83.93, 83.6, 83.27, 82.95, 82.62, 82.3, 81.98, 81.65, 81.33, 81.02, 80.7, 80.38, 80.06, 79.74, 79.43, 79.11, 78.79, 78.47, 78.15, 77.83, 77.5, 77.18, 76.85, 76.52, 76.19, 75.86, 75.52, 75.18, 74.83, 74.48, 74.13, 73.77, 73.41, 73.04, 72.66, 72.28, 71.89, 71.48, 71.07, 70.65, 70.22, 69.77, 69.31, 68.83, 68.33, 67.81, 67.26, 66.69, 66.08, 65.42, 64.72, 63.95, 63.09, 62.13, 61.01, 59.66, 57.89, 55.17], [159.19, 144.81, 128.56, 115.88, 111.55, 108.87, 106.87, 105.27, 103.91, 102.74, 101.69, 100.75, 99.88, 99.08, 98.34, 97.64, 96.98, 96.35, 95.75, 95.18, 94.64, 94.11, 93.6, 93.11, 92.64, 92.18, 91.73, 91.29, 90.86, 90.44, 90.04, 89.64, 89.24, 88.86, 88.48, 88.11, 87.74, 87.37, 87.02, 86.66, 86.31, 85.97, 85.63, 85.29, 84.95, 84.62, 84.29, 83.96, 83.63, 83.3, 82.98, 82.66, 82.33, 82.01, 81.69, 81.37, 81.05, 80.73, 80.41, 80.09, 79.77, 79.45, 79.13, 78.8, 78.48, 78.15, 77.82, 77.49, 77.16, 76.82, 76.48, 76.14, 75.79, 75.44, 75.08, 74.72, 74.36, 73.99, 73.61, 73.22, 72.83, 72.42, 72.01, 71.58, 71.15, 70.7, 70.23, 69.75, 69.25, 68.72, 68.17, 67.59, 66.98, 66.32, 65.61, 64.83, 63.97, 63.0, 61.88, 60.51, 58.73, 55.99], [160.55, 146.11, 129.8, 117.06, 112.71, 110.01, 108.01, 106.39, 105.03, 103.85, 102.8, 101.85, 100.98, 100.18, 99.43, 98.72, 98.06, 97.43, 96.83, 96.26, 95.71, 95.18, 94.67, 94.18, 93.7, 93.23, 92.78, 92.34, 91.91, 91.49, 91.08, 90.68, 90.28, 89.9, 89.51, 89.14, 88.77, 88.4, 88.04, 87.69, 87.34, 86.99, 86.65, 86.3, 85.97, 85.63, 85.3, 84.97, 84.64, 84.31, 83.98, 83.66, 83.33, 83.01, 82.69, 82.37, 82.05, 81.72, 81.4, 81.08, 80.76, 80.43, 80.11, 79.78, 79.46, 79.13, 78.79, 78.46, 78.13, 77.79, 77.45, 77.1, 76.75, 76.4, 76.04, 75.68, 75.31, 74.93, 74.55, 74.16, 73.77, 73.36, 72.94, 72.52, 72.08, 71.62, 71.15, 70.67, 70.16, 69.63, 69.08, 68.5, 67.88, 67.21, 66.5, 65.72, 64.85, 63.88, 62.74, 61.37, 59.57, 56.81], [161.92, 147.42, 131.04, 118.24, 113.87, 111.16, 109.14, 107.52, 106.15, 104.97, 103.91, 102.95, 102.08, 101.27, 100.52, 99.81, 99.14, 98.51, 97.91, 97.33, 96.78, 96.25, 95.73, 95.24, 94.76, 94.29, 93.84, 93.39, 92.96, 92.54, 92.13, 91.72, 91.32, 90.93, 90.55, 90.17, 89.8, 89.43, 89.07, 88.71, 88.36, 88.01, 87.67, 87.32, 86.98, 86.64, 86.31, 85.98, 85.64, 85.31, 84.99, 84.66, 84.33, 84.01, 83.69, 83.36, 83.04, 82.71, 82.39, 82.07, 81.74, 81.42, 81.09, 80.76, 80.43, 80.1, 79.77, 79.43, 79.09, 78.75, 78.41, 78.06, 77.71, 77.35, 76.99, 76.63, 76.26, 75.88, 75.5, 75.11, 74.71, 74.3, 73.88, 73.45, 73.01, 72.55, 72.08, 71.59, 71.08, 70.55, 69.99, 69.4, 68.78, 68.11, 67.39, 66.6, 65.73, 64.75, 63.61, 62.22, 60.41, 57.63], [163.28, 148.73, 132.28, 119.41, 115.03, 112.3, 110.28, 108.65, 107.27, 106.08, 105.02, 104.06, 103.18, 102.36, 101.61, 100.9, 100.23, 99.59, 98.98, 98.41, 97.85, 97.31, 96.8, 96.3, 95.82, 95.35, 94.89, 94.45, 94.01, 93.59, 93.17, 92.76, 92.37, 91.97, 91.59, 91.21, 90.83, 90.46, 90.1, 89.74, 89.38, 89.03, 88.68, 88.34, 88.0, 87.66, 87.32, 86.99, 86.65, 86.32, 85.99, 85.66, 85.33, 85.01, 84.68, 84.36, 84.03, 83.7, 83.38, 83.05, 82.73, 82.4, 82.07, 81.74, 81.41, 81.07, 80.74, 80.4, 80.06, 79.72, 79.37, 79.02, 78.67, 78.31, 77.95, 77.58, 77.21, 76.83, 76.44, 76.05, 75.65, 75.23, 74.81, 74.38, 73.94, 73.48, 73.0, 72.51, 72.0, 71.46, 70.9, 70.31, 69.68, 69.01, 68.28, 67.49, 66.61, 65.62, 64.47, 63.08, 61.25, 58.46], [164.64, 150.03, 133.51, 120.59, 116.18, 113.44, 111.41, 109.77, 108.39, 107.19, 106.12, 105.16, 104.28, 103.46, 102.7, 101.98, 101.31, 100.67, 100.06, 99.48, 98.92, 98.38, 97.86, 97.36, 96.88, 96.4, 95.94, 95.5, 95.06, 94.63, 94.22, 93.81, 93.41, 93.01, 92.62, 92.24, 91.86, 91.49, 91.13, 90.77, 90.41, 90.05, 89.7, 89.36, 89.01, 88.67, 88.33, 87.99, 87.66, 87.33, 86.99, 86.66, 86.33, 86.01, 85.68, 85.35, 85.02, 84.69, 84.37, 84.04, 83.71, 83.38, 83.05, 82.72, 82.38, 82.05, 81.71, 81.37, 81.03, 80.69, 80.34, 79.99, 79.63, 79.27, 78.91, 78.54, 78.16, 77.78, 77.39, 76.99, 76.59, 76.17, 75.75, 75.31, 74.87, 74.4, 73.93, 73.43, 72.91, 72.38, 71.81, 71.21, 70.58, 69.9, 69.17, 68.38, 67.49, 66.5, 65.34, 63.93, 62.1, 59.28], [165.99, 151.33, 134.75, 121.77, 117.34, 114.59, 112.54, 110.9, 109.51, 108.3, 107.23, 106.26, 105.37, 104.55, 103.79, 103.07, 102.39, 101.75, 101.14, 100.55, 99.99, 99.45, 98.93, 98.42, 97.93, 97.46, 97.0, 96.55, 96.11, 95.68, 95.26, 94.85, 94.44, 94.05, 93.66, 93.27, 92.9, 92.52, 92.15, 91.79, 91.43, 91.08, 90.72, 90.37, 90.03, 89.68, 89.34, 89.0, 88.67, 88.33, 88.0, 87.67, 87.33, 87.0, 86.67, 86.34, 86.01, 85.69, 85.36, 85.03, 84.69, 84.36, 84.03, 83.7, 83.36, 83.02, 82.69, 82.34, 82.0, 81.65, 81.3, 80.95, 80.59, 80.23, 79.86, 79.49, 79.11, 78.73, 78.33, 77.94, 77.53, 77.11, 76.69, 76.25, 75.8, 75.33, 74.85, 74.35, 73.83, 73.29, 72.72, 72.12, 71.48, 70.8, 70.07, 69.27, 68.38, 67.37, 66.21, 64.79, 62.94, 60.1], [167.35, 152.63, 135.98, 122.94, 118.49, 115.73, 113.67, 112.02, 110.63, 109.41, 108.34, 107.36, 106.47, 105.64, 104.88, 104.15, 103.47, 102.83, 102.21, 101.62, 101.06, 100.51, 99.99, 99.48, 98.99, 98.52, 98.05, 97.6, 97.16, 96.73, 96.3, 95.89, 95.48, 95.09, 94.69, 94.31, 93.93, 93.55, 93.18, 92.82, 92.45, 92.1, 91.74, 91.39, 91.04, 90.7, 90.35, 90.01, 89.68, 89.34, 89.0, 88.67, 88.33, 88.0, 87.67, 87.34, 87.01, 86.68, 86.34, 86.01, 85.68, 85.35, 85.01, 84.68, 84.34, 84.0, 83.66, 83.31, 82.97, 82.62, 82.27, 81.91, 81.55, 81.19, 80.82, 80.44, 80.06, 79.68, 79.28, 78.88, 78.47, 78.05, 77.62, 77.18, 76.73, 76.26, 75.78, 75.27, 74.75, 74.21, 73.63, 73.03, 72.39, 71.7, 70.96, 70.15, 69.26, 68.25, 67.07, 65.65, 63.79, 60.93], [168.7, 153.93, 137.21, 124.12, 119.65, 116.87, 114.81, 113.15, 111.74, 110.53, 109.44, 108.46, 107.57, 106.74, 105.96, 105.24, 104.55, 103.9, 103.29, 102.69, 102.13, 101.58, 101.05, 100.54, 100.05, 99.57, 99.1, 98.65, 98.21, 97.77, 97.35, 96.93, 96.52, 96.12, 95.73, 95.34, 94.96, 94.58, 94.21, 93.84, 93.48, 93.12, 92.76, 92.41, 92.06, 91.71, 91.37, 91.02, 90.68, 90.34, 90.01, 89.67, 89.33, 89.0, 88.67, 88.33, 88.0, 87.67, 87.33, 87.0, 86.66, 86.33, 85.99, 85.65, 85.32, 84.97, 84.63, 84.29, 83.94, 83.59, 83.23, 82.87, 82.51, 82.14, 81.77, 81.4, 81.01, 80.62, 80.23, 79.82, 79.41, 78.99, 78.56, 78.11, 77.66, 77.19, 76.7, 76.2, 75.67, 75.12, 74.54, 73.94, 73.29, 72.6, 71.86, 71.04, 70.14, 69.13, 67.94, 66.51, 64.63, 61.75], [170.05, 155.22, 138.44, 125.29, 120.8, 118.01, 115.94, 114.27, 112.86, 111.64, 110.55, 109.56, 108.66, 107.83, 107.05, 106.32, 105.63, 104.98, 104.36, 103.77, 103.19, 102.65, 102.12, 101.6, 101.11, 100.63, 100.16, 99.7, 99.25, 98.82, 98.39, 97.97, 97.56, 97.16, 96.76, 96.37, 95.99, 95.61, 95.24, 94.87, 94.5, 94.14, 93.78, 93.43, 93.07, 92.72, 92.38, 92.03, 91.69, 91.35, 91.01, 90.67, 90.33, 90.0, 89.66, 89.33, 88.99, 88.66, 88.32, 87.99, 87.65, 87.31, 86.97, 86.63, 86.29, 85.95, 85.6, 85.26, 84.91, 84.55, 84.2, 83.84, 83.47, 83.1, 82.73, 82.35, 81.97, 81.57, 81.18, 80.77, 80.35, 79.93, 79.5, 79.05, 78.59, 78.12, 77.63, 77.12, 76.59, 76.04, 75.46, 74.84, 74.2, 73.5, 72.75, 71.93, 71.03, 70.0, 68.81, 67.37, 65.48, 62.58], [171.4, 156.52, 139.67, 126.46, 121.95, 119.15, 117.07, 115.39, 113.98, 112.74, 111.65, 110.66, 109.76, 108.92, 108.14, 107.41, 106.71, 106.06, 105.43, 104.84, 104.26, 103.71, 103.18, 102.66, 102.17, 101.68, 101.21, 100.75, 100.3, 99.86, 99.43, 99.01, 98.6, 98.2, 97.8, 97.41, 97.02, 96.64, 96.26, 95.89, 95.52, 95.16, 94.8, 94.44, 94.09, 93.74, 93.39, 93.04, 92.7, 92.35, 92.01, 91.67, 91.33, 91.0, 90.66, 90.32, 89.98, 89.65, 89.31, 88.97, 88.63, 88.3, 87.95, 87.61, 87.27, 86.92, 86.58, 86.23, 85.88, 85.52, 85.16, 84.8, 84.43, 84.06, 83.69, 83.31, 82.92, 82.52, 82.12, 81.71, 81.3, 80.87, 80.43, 79.98, 79.52, 79.05, 78.55, 78.04, 77.51, 76.95, 76.37, 75.75, 75.1, 74.4, 73.65, 72.82, 71.91, 70.88, 69.68, 68.23, 66.33, 63.41], [172.75, 157.81, 140.89, 127.63, 123.1, 120.29, 118.19, 116.51, 115.09, 113.85, 112.75, 111.76, 110.85, 110.01, 109.22, 108.49, 107.79, 107.13, 106.51, 105.91, 105.33, 104.78, 104.24, 103.72, 103.22, 102.74, 102.26, 101.8, 101.35, 100.91, 100.48, 100.06, 99.64, 99.23, 98.83, 98.44, 98.05, 97.67, 97.29, 96.91, 96.55, 96.18, 95.82, 95.46, 95.1, 94.75, 94.4, 94.05, 93.7, 93.36, 93.02, 92.68, 92.33, 91.99, 91.65, 91.32, 90.98, 90.64, 90.3, 89.96, 89.62, 89.28, 88.94, 88.59, 88.25, 87.9, 87.55, 87.2, 86.85, 86.49, 86.13, 85.76, 85.39, 85.02, 84.64, 84.26, 83.87, 83.47, 83.07, 82.66, 82.24, 81.81, 81.37, 80.92, 80.45, 79.97, 79.48, 78.96, 78.43, 77.87, 77.28, 76.66, 76.01, 75.3, 74.54, 73.72, 72.8, 71.76, 70.55, 69.09, 67.18, 64.24], [174.09, 159.1, 142.12, 128.8, 124.26, 121.42, 119.32, 117.63, 116.2, 114.96, 113.86, 112.86, 111.94, 111.1, 110.31, 109.57, 108.87, 108.21, 107.58, 106.98, 106.4, 105.84, 105.3, 104.78, 104.28, 103.79, 103.31, 102.85, 102.4, 101.95, 101.52, 101.1, 100.68, 100.27, 99.87, 99.47, 99.08, 98.69, 98.31, 97.94, 97.57, 97.2, 96.84, 96.48, 96.12, 95.76, 95.41, 95.06, 94.71, 94.37, 94.02, 93.68, 93.33, 92.99, 92.65, 92.31, 91.97, 91.63, 91.29, 90.95, 90.6, 90.26, 89.92, 89.57, 89.22, 88.88, 88.52, 88.17, 87.81, 87.46, 87.09, 86.73, 86.36, 85.98, 85.6, 85.21, 84.82, 84.42, 84.02, 83.61, 83.18, 82.75, 82.31, 81.85, 81.39, 80.9, 80.41, 79.89, 79.35, 78.79, 78.2, 77.57, 76.91, 76.2, 75.44, 74.61, 73.68, 72.64, 71.43, 69.95, 68.03, 65.07], [175.44, 160.39, 143.34, 129.97, 125.4, 122.56, 120.45, 118.75, 117.32, 116.07, 114.96, 113.96, 113.04, 112.19, 111.4, 110.65, 109.95, 109.29, 108.65, 108.05, 107.46, 106.9, 106.36, 105.84, 105.34, 104.84, 104.37, 103.9, 103.44, 103.0, 102.56, 102.14, 101.72, 101.31, 100.9, 100.5, 100.11, 99.72, 99.34, 98.96, 98.59, 98.22, 97.85, 97.49, 97.13, 96.78, 96.42, 96.07, 95.72, 95.37, 95.02, 94.68, 94.33, 93.99, 93.65, 93.3, 92.96, 92.62, 92.28, 91.93, 91.59, 91.24, 90.9, 90.55, 90.2, 89.85, 89.5, 89.14, 88.78, 88.42, 88.06, 87.69, 87.32, 86.94, 86.56, 86.17, 85.78, 85.38, 84.97, 84.55, 84.13, 83.69, 83.25, 82.79, 82.32, 81.84, 81.33, 80.81, 80.27, 79.71, 79.11, 78.48, 77.82, 77.11, 76.34, 75.5, 74.57, 73.52, 72.3, 70.82, 68.88, 65.9], [176.78, 161.68, 144.57, 131.14, 126.55, 123.7, 121.58, 119.87, 118.43, 117.18, 116.06, 115.05, 114.13, 113.28, 112.48, 111.74, 111.03, 110.36, 109.72, 109.12, 108.53, 107.97, 107.43, 106.9, 106.39, 105.9, 105.42, 104.95, 104.49, 104.04, 103.61, 103.18, 102.76, 102.34, 101.94, 101.53, 101.14, 100.75, 100.37, 99.99, 99.61, 99.24, 98.87, 98.51, 98.15, 97.79, 97.43, 97.08, 96.73, 96.38, 96.03, 95.68, 95.33, 94.99, 94.64, 94.3, 93.95, 93.61, 93.27, 92.92, 92.58, 92.23, 91.88, 91.53, 91.18, 90.83, 90.47, 90.12, 89.75, 89.39, 89.02, 88.65, 88.28, 87.9, 87.52, 87.13, 86.73, 86.33, 85.92, 85.5, 85.07, 84.63, 84.19, 83.73, 83.25, 82.77, 82.26, 81.74, 81.19, 80.62, 80.03, 79.39, 78.73, 78.01, 77.24, 76.39, 75.46, 74.4, 73.17, 71.68, 69.73, 66.73], [178.12, 162.97, 145.79, 132.31, 127.7, 124.83, 122.7, 120.99, 119.54, 118.28, 117.16, 116.15, 115.22, 114.37, 113.57, 112.82, 112.11, 111.44, 110.8, 110.18, 109.6, 109.03, 108.49, 107.96, 107.45, 106.95, 106.47, 106.0, 105.54, 105.09, 104.65, 104.22, 103.79, 103.38, 102.97, 102.57, 102.17, 101.78, 101.39, 101.01, 100.63, 100.26, 99.89, 99.53, 99.16, 98.8, 98.44, 98.09, 97.73, 97.38, 97.03, 96.68, 96.33, 95.99, 95.64, 95.29, 94.95, 94.6, 94.25, 93.91, 93.56, 93.21, 92.86, 92.51, 92.16, 91.8, 91.45, 91.09, 90.73, 90.36, 89.99, 89.62, 89.24, 88.86, 88.47, 88.08, 87.68, 87.28, 86.87, 86.44, 86.02, 85.58, 85.13, 84.66, 84.19, 83.7, 83.19, 82.66, 82.11, 81.54, 80.94, 80.31, 79.63, 78.91, 78.13, 77.29, 76.35, 75.28, 74.05, 72.54, 70.58, 67.56], [179.46, 164.25, 147.01, 133.48, 128.85, 125.97, 123.83, 122.11, 120.65, 119.39, 118.26, 117.25, 116.32, 115.45, 114.65, 113.9, 113.19, 112.51, 111.87, 111.25, 110.66, 110.09, 109.55, 109.02, 108.5, 108.0, 107.52, 107.05, 106.58, 106.13, 105.69, 105.26, 104.83, 104.41, 104.0, 103.6, 103.2, 102.81, 102.42, 102.04, 101.66, 101.28, 100.91, 100.54, 100.18, 99.81, 99.45, 99.1, 98.74, 98.39, 98.04, 97.68, 97.33, 96.98, 96.64, 96.29, 95.94, 95.59, 95.24, 94.9, 94.55, 94.2, 93.84, 93.49, 93.14, 92.78, 92.42, 92.06, 91.7, 91.33, 90.96, 90.58, 90.2, 89.82, 89.43, 89.04, 88.64, 88.23, 87.81, 87.39, 86.96, 86.52, 86.07, 85.6, 85.12, 84.63, 84.12, 83.59, 83.04, 82.46, 81.86, 81.22, 80.54, 79.82, 79.03, 78.18, 77.23, 76.16, 74.92, 73.41, 71.43, 68.4], [180.79, 165.54, 148.23, 134.64, 130.0, 127.1, 124.95, 123.23, 121.77, 120.49, 119.36, 118.34, 117.41, 116.54, 115.74, 114.98, 114.26, 113.59, 112.94, 112.32, 111.73, 111.16, 110.61, 110.07, 109.56, 109.06, 108.57, 108.09, 107.63, 107.18, 106.73, 106.3, 105.87, 105.45, 105.04, 104.63, 104.23, 103.83, 103.44, 103.06, 102.68, 102.3, 101.93, 101.56, 101.19, 100.83, 100.47, 100.11, 99.75, 99.39, 99.04, 98.69, 98.33, 97.98, 97.63, 97.28, 96.93, 96.58, 96.23, 95.88, 95.53, 95.18, 94.83, 94.47, 94.11, 93.76, 93.4, 93.03, 92.67, 92.3, 91.92, 91.55, 91.17, 90.78, 90.39, 89.99, 89.59, 89.18, 88.76, 88.34, 87.9, 87.46, 87.01, 86.54, 86.06, 85.56, 85.05, 84.51, 83.96, 83.38, 82.77, 82.13, 81.45, 80.72, 79.93, 79.07, 78.12, 77.05, 75.79, 74.28, 72.29, 69.23]];

/**
 * Signifance levels used by `computeChi2PValue`.
 */
const SIGNIFICANCE_LEVELS = exports.SIGNIFICANCE_LEVELS = [0.000001, 0.000032, 0.001, 0.01, 0.02, 0.03, 0.04, 0.05, 0.06, 0.07, 0.08, 0.09, 0.1, 0.11, 0.12, 0.13, 0.14, 0.15, 0.16, 0.17, 0.18, 0.19, 0.2, 0.21, 0.22, 0.23, 0.24, 0.25, 0.26, 0.27, 0.28, 0.29, 0.3, 0.31, 0.32, 0.33, 0.34, 0.35, 0.36, 0.37, 0.38, 0.39, 0.4, 0.41, 0.42, 0.43, 0.44, 0.45, 0.46, 0.47, 0.48, 0.49, 0.5, 0.51, 0.52, 0.53, 0.54, 0.55, 0.56, 0.57, 0.58, 0.59, 0.6, 0.61, 0.62, 0.63, 0.64, 0.65, 0.66, 0.67, 0.68, 0.69, 0.7, 0.71, 0.72, 0.73, 0.74, 0.75, 0.76, 0.77, 0.78, 0.79, 0.8, 0.81, 0.82, 0.83, 0.84, 0.85, 0.86, 0.87, 0.88, 0.89, 0.9, 0.91, 0.92, 0.93, 0.94, 0.95, 0.96, 0.97, 0.98, 0.99];