"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.createMetricsClientMock = createMetricsClientMock;
exports.createStartServicesAccessorMock = createStartServicesAccessorMock;
var _mocks = require("@kbn/core/public/mocks");
var _i18nReact = require("@kbn/i18n-react");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function createStartServicesAccessorMock() {
  const core = _mocks.coreMock.createStart();
  core.i18n.Context.mockImplementation(_i18nReact.I18nProvider);
  const coreProvidersPropsMock = {
    core,
    theme$: core.theme.theme$
  };
  const getStartServices = () => [coreProvidersPropsMock.core];
  return {
    coreProvidersPropsMock,
    fetch: core.http.fetch,
    getStartServices
  };
}
function createMetricsClientMock(metricsExplorerData) {
  return {
    metricsIndices: jest.fn().mockResolvedValue({
      metricIndices: 'metrics-*',
      metricIndicesExist: true
    }),
    metricsExplorer: jest.fn().mockResolvedValue(metricsExplorerData)
  };
}