"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.NumberCell = NumberCell;
var _eui = require("@elastic/eui");
var _react = _interopRequireDefault(require("react"));
var _i18nReact = require("@kbn/i18n-react");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function NumberCell({
  value,
  unit
}) {
  if (value === null || value === undefined || isNaN(value)) {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiTextColor, {
      color: "subdued"
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.metricsData.metricsTable.numberCell.metricNotAvailableLabel",
      defaultMessage: "N/A",
      description: "N/A is short for not available"
    }));
  }
  if (!unit) {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiI18nNumber, {
      value: roundToOneDecimal(value)
    });
  }
  return /*#__PURE__*/_react.default.createElement("span", null, /*#__PURE__*/_react.default.createElement(_eui.EuiI18nNumber, {
    value: roundToOneDecimal(value)
  }), unit);
}
function roundToOneDecimal(value) {
  return Math.round(value * 10) / 10;
}