"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.MetricsNodeDetailsLink = void 0;
var _datemath = require("@kbn/datemath");
var _eui = require("@elastic/eui");
var _react = _interopRequireDefault(require("react"));
var _public = require("@kbn/observability-shared-plugin/public");
var _use_node_details_redirect = require("../../../../pages/link_to/use_node_details_redirect");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const MetricsNodeDetailsLink = ({
  id,
  label,
  nodeType,
  timerange
}) => {
  var _parse, _parse2;
  const {
    getNodeDetailUrl
  } = (0, _use_node_details_redirect.useNodeDetailsRedirect)();
  const linkProps = (0, _public.useLinkProps)(getNodeDetailUrl({
    nodeType,
    nodeId: id,
    search: {
      from: (_parse = (0, _datemath.parse)(timerange.from)) === null || _parse === void 0 ? void 0 : _parse.valueOf(),
      to: (_parse2 = (0, _datemath.parse)(timerange.to)) === null || _parse2 === void 0 ? void 0 : _parse2.valueOf()
    }
  }));
  return /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
    "data-test-subj": "infraMetricsNodeDetailsLinkLink",
    href: linkProps.href
  }, label);
};
exports.MetricsNodeDetailsLink = MetricsNodeDetailsLink;