"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.TSVBSeriesRT = exports.TSVBPercentileItemRT = exports.TSVBMetricTypeRT = exports.TSVBMetricRT = exports.TSVBMetricModelVariableRT = exports.TSVBMetricModelSeriesAggRT = exports.TSVBMetricModelRT = exports.TSVBMetricModelDerivativeRT = exports.TSVBMetricModelCountRT = exports.TSVBMetricModelBucketScriptRT = exports.TSVBMetricModelBasicMetricRT = exports.TSVBMetricModePercentileAggRT = exports.SnapshotMetricTypeRT = exports.SnapshotMetricTypeKeys = exports.MetricsUIAggregationRT = exports.ItemTypeRT = exports.InventoryVisTypeRT = exports.InventoryMetricRT = exports.InventoryFormatterTypeRT = exports.ESTopMetricsAggRT = exports.ESTermsWithAggregationRT = exports.ESSumBucketAggRT = exports.ESPercentileAggRT = exports.ESMaxPeriodFilterExistsAggRT = exports.ESDerivativeAggRT = exports.ESCumulativeSumAggRT = exports.ESCaridnalityAggRT = exports.ESBucketScriptAggRT = exports.ESBasicMetricAggRT = exports.ESAggregationRT = void 0;
var rt = _interopRequireWildcard(require("io-ts"));
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ItemTypeRT = exports.ItemTypeRT = rt.keyof({
  host: null,
  pod: null,
  container: null,
  awsEC2: null,
  awsS3: null,
  awsSQS: null,
  awsRDS: null
});
const InventoryVisTypeRT = exports.InventoryVisTypeRT = rt.keyof({
  line: null,
  area: null,
  bar: null
});
const InventoryFormatterTypeRT = exports.InventoryFormatterTypeRT = rt.keyof({
  abbreviatedNumber: null,
  bits: null,
  bytes: null,
  number: null,
  percent: null,
  highPrecision: null
});
const InventoryMetricRT = exports.InventoryMetricRT = rt.keyof({
  hostSystemOverview: null,
  hostCpuUsage: null,
  hostFilesystem: null,
  hostK8sOverview: null,
  hostK8sCpuCap: null,
  hostK8sDiskCap: null,
  hostK8sMemoryCap: null,
  hostK8sPodCap: null,
  hostLoad: null,
  hostMemoryUsage: null,
  hostNetworkTraffic: null,
  hostDockerOverview: null,
  hostDockerInfo: null,
  hostDockerTop5ByCpu: null,
  hostDockerTop5ByMemory: null,
  podOverview: null,
  podCpuUsage: null,
  podMemoryUsage: null,
  podLogUsage: null,
  podNetworkTraffic: null,
  containerOverview: null,
  containerCpuKernel: null,
  containerCpuUsage: null,
  containerDiskIOOps: null,
  containerDiskIOBytes: null,
  containerMemory: null,
  containerNetworkTraffic: null,
  containerK8sOverview: null,
  containerK8sCpuUsage: null,
  containerK8sMemoryUsage: null,
  nginxHits: null,
  nginxRequestRate: null,
  nginxActiveConnections: null,
  nginxRequestsPerConnection: null,
  awsOverview: null,
  awsCpuUtilization: null,
  awsNetworkBytes: null,
  awsNetworkPackets: null,
  awsDiskioBytes: null,
  awsDiskioOps: null,
  awsEC2CpuUtilization: null,
  awsEC2NetworkTraffic: null,
  awsEC2DiskIOBytes: null,
  awsS3TotalRequests: null,
  awsS3NumberOfObjects: null,
  awsS3BucketSize: null,
  awsS3DownloadBytes: null,
  awsS3UploadBytes: null,
  awsRDSCpuTotal: null,
  awsRDSConnections: null,
  awsRDSQueriesExecuted: null,
  awsRDSActiveTransactions: null,
  awsRDSLatency: null,
  awsSQSMessagesVisible: null,
  awsSQSMessagesDelayed: null,
  awsSQSMessagesSent: null,
  awsSQSMessagesEmpty: null,
  awsSQSOldestMessage: null,
  custom: null
});
const TSVBMetricTypeRT = exports.TSVBMetricTypeRT = rt.keyof({
  avg: null,
  max: null,
  min: null,
  calculation: null,
  cardinality: null,
  series_agg: null,
  positive_only: null,
  derivative: null,
  count: null,
  sum: null,
  cumulative_sum: null
});
const TSVBMetricModelCountRT = exports.TSVBMetricModelCountRT = rt.type({
  id: rt.string,
  type: rt.literal('count')
});
const TSVBMetricModelBasicMetricRT = exports.TSVBMetricModelBasicMetricRT = rt.intersection([rt.type({
  id: rt.string,
  type: TSVBMetricTypeRT
}), rt.partial({
  field: rt.string
})]);
const TSVBMetricModelVariableRT = exports.TSVBMetricModelVariableRT = rt.type({
  field: rt.string,
  id: rt.string,
  name: rt.string
});
const TSVBMetricModelBucketScriptRT = exports.TSVBMetricModelBucketScriptRT = rt.type({
  id: rt.string,
  script: rt.string,
  type: rt.literal('calculation'),
  variables: rt.array(TSVBMetricModelVariableRT)
});
const TSVBMetricModelDerivativeRT = exports.TSVBMetricModelDerivativeRT = rt.type({
  id: rt.string,
  field: rt.string,
  unit: rt.string,
  type: rt.literal('derivative')
});
const TSVBMetricModelSeriesAggRT = exports.TSVBMetricModelSeriesAggRT = rt.type({
  id: rt.string,
  function: rt.string,
  type: rt.literal('series_agg')
});
const TSVBPercentileItemRT = exports.TSVBPercentileItemRT = rt.type({
  id: rt.string,
  value: rt.number
});
const TSVBMetricModePercentileAggRT = exports.TSVBMetricModePercentileAggRT = rt.intersection([rt.type({
  id: rt.string,
  type: rt.literal('percentile'),
  percentiles: rt.array(TSVBPercentileItemRT)
}), rt.partial({
  field: rt.string
})]);
const TSVBMetricRT = exports.TSVBMetricRT = rt.union([TSVBMetricModelCountRT, TSVBMetricModelBasicMetricRT, TSVBMetricModelBucketScriptRT, TSVBMetricModelDerivativeRT, TSVBMetricModePercentileAggRT, TSVBMetricModelSeriesAggRT]);
const TSVBSeriesRT = exports.TSVBSeriesRT = rt.intersection([rt.type({
  id: rt.string,
  metrics: rt.array(TSVBMetricRT),
  split_mode: rt.string
}), rt.partial({
  terms_field: rt.string,
  terms_size: rt.number,
  terms_order_by: rt.string,
  filter: rt.type({
    query: rt.string,
    language: rt.keyof({
      lucene: null,
      kuery: null
    })
  })
})]);
const TSVBMetricModelRT = exports.TSVBMetricModelRT = rt.intersection([rt.type({
  id: InventoryMetricRT,
  requires: rt.array(rt.string),
  index_pattern: rt.union([rt.string, rt.array(rt.string)]),
  interval: rt.string,
  time_field: rt.string,
  type: rt.string,
  series: rt.array(TSVBSeriesRT)
}), rt.partial({
  filter: rt.string,
  map_field_to: rt.string,
  id_type: rt.keyof({
    cloud: null,
    node: null
  }),
  drop_last_bucket: rt.boolean
})]);
const ESBasicMetricAggRT = exports.ESBasicMetricAggRT = rt.record(rt.string, rt.union([rt.undefined, rt.type({
  field: rt.string
})]));
const ESPercentileAggRT = exports.ESPercentileAggRT = rt.type({
  percentiles: rt.type({
    field: rt.string,
    percents: rt.array(rt.number)
  })
});
const ESCaridnalityAggRT = exports.ESCaridnalityAggRT = rt.type({
  cardinality: rt.partial({
    field: rt.string
  })
});
const ESBucketScriptAggRT = exports.ESBucketScriptAggRT = rt.type({
  bucket_script: rt.intersection([rt.type({
    buckets_path: rt.record(rt.string, rt.string),
    script: rt.type({
      source: rt.string,
      lang: rt.keyof({
        painless: null,
        expression: null
      })
    })
  }), rt.partial({
    gap_policy: rt.keyof({
      skip: null,
      insert_zeros: null
    })
  })])
});
const ESCumulativeSumAggRT = exports.ESCumulativeSumAggRT = rt.type({
  cumulative_sum: rt.type({
    buckets_path: rt.string
  })
});
const ESDerivativeAggRT = exports.ESDerivativeAggRT = rt.type({
  derivative: rt.type({
    buckets_path: rt.string,
    gap_policy: rt.keyof({
      skip: null,
      insert_zeros: null
    }),
    unit: rt.string
  })
});
const ESSumBucketAggRT = exports.ESSumBucketAggRT = rt.type({
  sum_bucket: rt.type({
    buckets_path: rt.string
  })
});
const ESTopMetricsAggRT = exports.ESTopMetricsAggRT = rt.type({
  top_metrics: rt.intersection([rt.type({
    metrics: rt.union([rt.array(rt.type({
      field: rt.string
    })), rt.type({
      field: rt.string
    })])
  }), rt.partial({
    size: rt.number,
    sort: rt.record(rt.string, rt.union([rt.literal('desc'), rt.literal('asc')]))
  })])
});
const ESMaxPeriodFilterExistsAggRT = exports.ESMaxPeriodFilterExistsAggRT = rt.type({
  filter: rt.type({
    exists: rt.type({
      field: rt.string
    })
  }),
  aggs: rt.type({
    period: rt.type({
      max: rt.type({
        field: rt.string
      })
    })
  })
});
const ESTermsWithAggregationRT = exports.ESTermsWithAggregationRT = rt.recursion('SnapshotModelRT', () => rt.type({
  terms: rt.type({
    field: rt.string
  }),
  aggregations: MetricsUIAggregationRT
}));
const ESAggregationRT = exports.ESAggregationRT = rt.union([ESBasicMetricAggRT, ESPercentileAggRT, ESBucketScriptAggRT, ESCumulativeSumAggRT, ESDerivativeAggRT, ESSumBucketAggRT, ESTermsWithAggregationRT, ESCaridnalityAggRT, ESTopMetricsAggRT, ESMaxPeriodFilterExistsAggRT]);
const MetricsUIAggregationRT = exports.MetricsUIAggregationRT = rt.record(rt.string, ESAggregationRT);
const SnapshotMetricTypeKeys = exports.SnapshotMetricTypeKeys = {
  count: null,
  cpu: null,
  diskLatency: null,
  diskSpaceUsage: null,
  load: null,
  memory: null,
  memoryFree: null,
  memoryTotal: null,
  normalizedLoad1m: null,
  tx: null,
  rx: null,
  logRate: null,
  diskIOReadBytes: null,
  diskIOWriteBytes: null,
  s3TotalRequests: null,
  s3NumberOfObjects: null,
  s3BucketSize: null,
  s3DownloadBytes: null,
  s3UploadBytes: null,
  rdsConnections: null,
  rdsQueriesExecuted: null,
  rdsActiveTransactions: null,
  rdsLatency: null,
  sqsMessagesVisible: null,
  sqsMessagesDelayed: null,
  sqsMessagesSent: null,
  sqsMessagesEmpty: null,
  sqsOldestMessage: null,
  custom: null
};
const SnapshotMetricTypeRT = exports.SnapshotMetricTypeRT = rt.keyof(SnapshotMetricTypeKeys);