"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.nodeMemoryUsed = exports.nodeMemoryCapacity = void 0;
var _i18n = require("@kbn/i18n");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const nodeMemoryCapacity = exports.nodeMemoryCapacity = {
  label: _i18n.i18n.translate('xpack.metricsData.assetDetails.formulas.kubernetes.capacity', {
    defaultMessage: 'Capacity'
  }),
  value: 'max(kubernetes.node.memory.allocatable.bytes)',
  format: 'bytes',
  decimals: 1
};
const nodeMemoryUsed = exports.nodeMemoryUsed = {
  label: _i18n.i18n.translate('xpack.metricsData.assetDetails.formulas.kubernetes.used', {
    defaultMessage: 'Used'
  }),
  value: 'average(kubernetes.node.memory.usage.bytes)',
  format: 'bytes',
  decimals: 1
};